/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;

public class CompactorTasks
implements LeaderElection.LeadershipStateListener {
    private final Configuration configuration;
    private final boolean runOnlyWorker;
    private Map<MetaStoreThread, AtomicBoolean> metastoreThreadsMap;

    public CompactorTasks(Configuration configuration, boolean runOnlyWorker) {
        this.configuration = new Configuration(Objects.requireNonNull(configuration, "configuration is null"));
        this.runOnlyWorker = runOnlyWorker;
    }

    private MetaStoreThread instantiateThread(String classname) throws Exception {
        Object o = JavaUtils.newInstance(Class.forName(classname));
        if (MetaStoreThread.class.isAssignableFrom(o.getClass())) {
            return (MetaStoreThread)o;
        }
        String s = classname + " is not an instance of MetaStoreThread.";
        HiveMetaStore.LOG.error(s);
        throw new IOException(s);
    }

    public List<MetaStoreThread> getCompactorThreads() throws Exception {
        ArrayList<MetaStoreThread> compactors = new ArrayList<MetaStoreThread>();
        if (!this.runOnlyWorker) {
            if (MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON)) {
                MetaStoreThread initiator = this.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Initiator");
                compactors.add(initiator);
            }
            if (MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON)) {
                MetaStoreThread cleaner = this.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Cleaner");
                compactors.add(cleaner);
            }
        } else {
            boolean runInMetastore = MetastoreConf.getVar(this.configuration, MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN).equals("metastore");
            if (runInMetastore) {
                HiveMetaStore.LOG.warn("Running compaction workers on HMS side is not suggested because compaction pools are not supported in HMS (HIVE-26443). Consider removing the hive.metastore.runworker.in configuration setting, as it will be comletely removed in future releases.");
                int numWorkers = MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS);
                for (int i = 0; i < numWorkers; ++i) {
                    MetaStoreThread worker = this.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Worker");
                    compactors.add(worker);
                }
            }
        }
        return compactors;
    }

    private void logCompactionParameters() {
        if (!this.runOnlyWorker) {
            HiveMetaStore.LOG.info("Compaction HMS parameters:");
            HiveMetaStore.LOG.info("metastore.compactor.initiator.on = {}", (Object)MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON));
            HiveMetaStore.LOG.info("metastore.compactor.cleaner.on = {}", (Object)MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON));
            HiveMetaStore.LOG.info("metastore.compactor.worker.threads = {}", (Object)MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS));
            HiveMetaStore.LOG.info("hive.metastore.runworker.in = {}", (Object)MetastoreConf.getVar(this.configuration, MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN));
            HiveMetaStore.LOG.info("metastore.compactor.history.retention.attempted = {}", (Object)MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE));
            HiveMetaStore.LOG.info("metastore.compactor.history.retention.failed = {}", (Object)MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED));
            HiveMetaStore.LOG.info("metastore.compactor.history.retention.succeeded = {}", (Object)MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED));
            HiveMetaStore.LOG.info("metastore.compactor.initiator.failed.compacts.threshold = {}", (Object)MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD));
            if (!MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON)) {
                HiveMetaStore.LOG.warn("Compactor Initiator is turned Off. Automatic compaction will not be triggered.");
            }
            if (!MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON)) {
                HiveMetaStore.LOG.warn("Compactor Cleaner is turned Off. Automatic compaction cleaner will not be triggered.");
            }
        } else {
            int numThreads = MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS);
            if (numThreads < 1) {
                HiveMetaStore.LOG.warn("Invalid number of Compactor Worker threads({}) on HMS", (Object)numThreads);
            }
        }
    }

    @Override
    public void takeLeadership(LeaderElection election) throws Exception {
        if (this.metastoreThreadsMap != null) {
            throw new IllegalStateException("There should be no running tasks before taking the leadership!");
        }
        this.logCompactionParameters();
        this.metastoreThreadsMap = new IdentityHashMap<MetaStoreThread, AtomicBoolean>();
        List<MetaStoreThread> metaStoreThreads = this.getCompactorThreads();
        for (MetaStoreThread thread : metaStoreThreads) {
            AtomicBoolean flag = new AtomicBoolean();
            thread.setConf(this.configuration);
            thread.init(flag);
            this.metastoreThreadsMap.put(thread, flag);
            HiveMetaStore.LOG.info("Starting metastore thread of type " + thread.getClass().getName());
            thread.start();
        }
    }

    @Override
    public void lossLeadership(LeaderElection election) {
        if (this.metastoreThreadsMap != null) {
            this.metastoreThreadsMap.forEach((thread, flag) -> {
                flag.set(true);
                if (thread instanceof Thread) {
                    ((Thread)((Object)thread)).interrupt();
                }
                HiveMetaStore.LOG.info("Stopped the Compaction task: {}.", (Object)thread.getClass().getName());
            });
            this.metastoreThreadsMap = null;
        }
    }
}

