/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ReloadEvent
extends ListenerEvent {
    private final Table tableObj;
    private final Partition ptnObj;
    private final boolean refreshEvent;

    public ReloadEvent(String catName, String db, String table, List<String> partVals, boolean status, boolean refreshEvent, Map<String, String> tblParams, IHMSHandler handler) throws MetaException, NoSuchObjectException {
        super(status, handler);
        GetTableRequest req = new GetTableRequest(db, table);
        req.setCatName(catName);
        req.setCapabilities(new ClientCapabilities(Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.TEST_CAPABILITY, ClientCapability.INSERT_ONLY_TABLES})));
        try {
            this.tableObj = handler.get_table_req(req).getTable();
            if (tblParams != null) {
                this.tableObj.getParameters().putAll(tblParams);
            }
            this.ptnObj = partVals != null ? handler.get_partition(MetaStoreUtils.prependNotNullCatToDbName(catName, db), table, partVals) : null;
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw MetaStoreUtils.newMetaException((Exception)((Object)e));
        }
        this.refreshEvent = refreshEvent;
    }

    public Table getTableObj() {
        return this.tableObj;
    }

    public Partition getPartitionObj() {
        return this.ptnObj;
    }

    public boolean isRefreshEvent() {
        return this.refreshEvent;
    }
}

