/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CommitCompactionEvent
extends ListenerEvent {
    private final Long txnId;
    private final Long compactionId;
    private final CompactionType type;
    private final String dbname;
    private final String tableName;
    private final String partName;

    public CommitCompactionEvent(Long txnId, CompactionInfo ci) {
        this(txnId, ci.id, ci.type, ci.dbname, ci.tableName, ci.partName, null);
    }

    public CommitCompactionEvent(Long txnId, CompactionInfo ci, IHMSHandler handler) {
        this(txnId, ci.id, ci.type, ci.dbname, ci.tableName, ci.partName, handler);
    }

    public CommitCompactionEvent(Long txnId, Long compactionId, CompactionType type, String dbname, String tableName, String partName, IHMSHandler handler) {
        super(true, handler);
        this.txnId = txnId;
        this.compactionId = compactionId;
        this.type = type;
        this.dbname = dbname;
        this.tableName = tableName;
        this.partName = partName;
    }

    public Long getTxnId() {
        return this.txnId;
    }

    public Long getCompactionId() {
        return this.compactionId;
    }

    public CompactionType getType() {
        return this.type;
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPartName() {
        return this.partName;
    }
}

