/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.codahale.metrics.MetricRegistry;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HikariCPDataSourceProvider.class);
    static final String HIKARI = "hikaricp";
    private static final String CONNECTION_TIMEOUT_PROPERTY = "hikaricp.connectionTimeout";
    private static final String LEAK_DETECTION_THRESHOLD = "hikaricp.leakDetectionThreshold";

    @Override
    public DataSource create(Configuration hdpConfig, int maxPoolSize) throws SQLException {
        HikariConfig config;
        String poolName = DataSourceProvider.getDataSourceName(hdpConfig);
        LOG.info("Creating Hikari connection pool for the MetaStore, maxPoolSize: {}, name: {}", (Object)maxPoolSize, (Object)poolName);
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        Properties properties = this.replacePrefix(DataSourceProvider.getPrefixedProperties(hdpConfig, HIKARI));
        long connectionTimeout = hdpConfig.getLong(CONNECTION_TIMEOUT_PROPERTY, 30000L);
        long leakDetectionThreshold = hdpConfig.getLong(LEAK_DETECTION_THRESHOLD, 3600000L);
        try {
            config = new HikariConfig(properties);
        }
        catch (Exception e) {
            throw new SQLException("Cannot create HikariCP configuration: ", e);
        }
        config.setMaximumPoolSize(maxPoolSize);
        config.setJdbcUrl(driverUrl);
        config.setUsername(user);
        config.setPassword(passwd);
        config.setLeakDetectionThreshold(leakDetectionThreshold);
        if (!StringUtils.isEmpty(poolName)) {
            config.setPoolName(poolName);
        }
        if ("mutex".equals(poolName)) {
            int minimumIdle = Integer.valueOf(hdpConfig.get("hikaricp.minimumIdle", "2"));
            config.setMinimumIdle(Math.min(maxPoolSize, minimumIdle));
        }
        config.setConnectionTimeout(connectionTimeout);
        DatabaseProduct dbProduct = DatabaseProduct.determineDatabaseProduct(driverUrl);
        switch (dbProduct) {
            case MYSQL: {
                config.setConnectionInitSql("SET @@session.sql_mode=ANSI_QUOTES");
                config.addDataSourceProperty("allowMultiQueries", (Object)true);
                config.addDataSourceProperty("rewriteBatchedStatements", (Object)true);
                break;
            }
            case POSTGRES: {
                config.addDataSourceProperty("reWriteBatchedInserts", (Object)true);
            }
        }
        return new HikariDataSource(HikariCPDataSourceProvider.initMetrics(config));
    }

    @Override
    public boolean mayReturnClosedConnection() {
        return false;
    }

    @Override
    public String getPoolingType() {
        return HIKARI;
    }

    private Properties replacePrefix(Properties props) {
        Properties newProps = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> newProps.put(key.toString().replaceFirst("hikaricp.", ""), value)));
        return newProps;
    }

    private static HikariConfig initMetrics(HikariConfig config) {
        MetricRegistry registry = Metrics.getRegistry();
        if (registry != null) {
            config.setMetricRegistry((Object)registry);
        }
        return config;
    }
}

