/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import java.sql.SQLException;
import java.time.Duration;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DbCPDataSourceProvider.class);
    static final String DBCP = "dbcp";
    private static final String CONNECTION_TIMEOUT_PROPERTY = "dbcp.maxWait";
    private static final String CONNECTION_MAX_IDLE_PROPERTY = "dbcp.maxIdle";
    private static final String CONNECTION_MIN_IDLE_PROPERTY = "dbcp.minIdle";
    private static final String CONNECTION_TEST_BORROW_PROPERTY = "dbcp.testOnBorrow";
    private static final String CONNECTION_MIN_EVICT_MILLIS_PROPERTY = "dbcp.minEvictableIdleTimeMillis";
    private static final String CONNECTION_TEST_IDLEPROPERTY = "dbcp.testWhileIdle";
    private static final String CONNECTION_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "dbcp.timeBetweenEvictionRunsMillis";
    private static final String CONNECTION_NUM_TESTS_PER_EVICTION_RUN = "dbcp.numTestsPerEvictionRun";
    private static final String CONNECTION_TEST_ON_RETURN = "dbcp.testOnReturn";
    private static final String CONNECTION_SOFT_MIN_EVICTABLE_IDLE_TIME = "dbcp.softMinEvictableIdleTimeMillis";
    private static final String CONNECTION_LIFO = "dbcp.lifo";

    @Override
    public DataSource create(Configuration hdpConfig, int maxPoolSize) throws SQLException {
        String poolName = DataSourceProvider.getDataSourceName(hdpConfig);
        LOG.info("Creating dbcp connection pool for the MetaStore, maxPoolSize: {}, name: {}", (Object)maxPoolSize, (Object)poolName);
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        BasicDataSource dbcpDs = new BasicDataSource();
        dbcpDs.setUrl(driverUrl);
        dbcpDs.setUsername(user);
        dbcpDs.setPassword(passwd);
        dbcpDs.setDefaultReadOnly(Boolean.valueOf(false));
        dbcpDs.setDefaultAutoCommit(Boolean.valueOf(true));
        DatabaseProduct dbProduct = DatabaseProduct.determineDatabaseProduct(driverUrl);
        switch (dbProduct) {
            case MYSQL: {
                dbcpDs.setConnectionProperties("allowMultiQueries=true");
                dbcpDs.setConnectionProperties("rewriteBatchedStatements=true");
                break;
            }
            case POSTGRES: {
                dbcpDs.setConnectionProperties("reWriteBatchedInserts=true");
                break;
            }
        }
        long connectionTimeout = hdpConfig.getLong(CONNECTION_TIMEOUT_PROPERTY, 30000L);
        int connectionMaxIlde = hdpConfig.getInt(CONNECTION_MAX_IDLE_PROPERTY, 8);
        int connectionMinIlde = hdpConfig.getInt(CONNECTION_MIN_IDLE_PROPERTY, 0);
        boolean testOnBorrow = hdpConfig.getBoolean(CONNECTION_TEST_BORROW_PROPERTY, false);
        long evictionTimeMillis = hdpConfig.getLong(CONNECTION_MIN_EVICT_MILLIS_PROPERTY, BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION.toMillis());
        boolean testWhileIdle = hdpConfig.getBoolean(CONNECTION_TEST_IDLEPROPERTY, false);
        long timeBetweenEvictionRuns = hdpConfig.getLong(CONNECTION_TIME_BETWEEN_EVICTION_RUNS_MILLIS, BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS.toMillis());
        int numTestsPerEvictionRun = hdpConfig.getInt(CONNECTION_NUM_TESTS_PER_EVICTION_RUN, 3);
        boolean testOnReturn = hdpConfig.getBoolean(CONNECTION_TEST_ON_RETURN, false);
        long softMinEvictableIdleTimeMillis = hdpConfig.getLong(CONNECTION_SOFT_MIN_EVICTABLE_IDLE_TIME, BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION.toMillis());
        boolean lifo = hdpConfig.getBoolean(CONNECTION_LIFO, true);
        DataSourceConnectionFactory connFactory = new DataSourceConnectionFactory((DataSource)dbcpDs);
        PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        GenericObjectPool objectPool = new GenericObjectPool((PooledObjectFactory)poolableConnFactory);
        objectPool.setMaxTotal(maxPoolSize);
        objectPool.setMaxWait(Duration.ofMillis(connectionTimeout));
        objectPool.setMaxIdle(connectionMaxIlde);
        objectPool.setMinIdle(connectionMinIlde);
        objectPool.setTestOnBorrow(testOnBorrow);
        objectPool.setTestWhileIdle(testWhileIdle);
        objectPool.setMinEvictableIdleDuration(Duration.ofMillis(evictionTimeMillis));
        objectPool.setDurationBetweenEvictionRuns(Duration.ofMillis(timeBetweenEvictionRuns));
        objectPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        objectPool.setTestOnReturn(testOnReturn);
        objectPool.setSoftMinEvictableIdleDuration(Duration.ofMillis(softMinEvictableIdleTimeMillis));
        objectPool.setLifo(lifo);
        if ("mutex".equalsIgnoreCase(poolName)) {
            if (timeBetweenEvictionRuns < 0L) {
                objectPool.setDurationBetweenEvictionRuns(Duration.ofMillis(30000L));
            }
            if (softMinEvictableIdleTimeMillis < 0L) {
                objectPool.setSoftMinEvictableIdleDuration(Duration.ofMillis(600000L));
            }
        }
        if (dbProduct == DatabaseProduct.MYSQL) {
            poolableConnFactory.setValidationQuery("SET @@session.sql_mode=ANSI_QUOTES");
        }
        return new PoolingDataSource((ObjectPool)objectPool);
    }

    @Override
    public boolean mayReturnClosedConnection() {
        return false;
    }

    @Override
    public String getPoolingType() {
        return DBCP;
    }
}

