/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.MySQLConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLConnectorProvider
extends AbstractJDBCConnectorProvider {
    private static Logger LOG = LoggerFactory.getLogger(MySQLConnectorProvider.class);
    private static final String DRIVER_CLASS = "org.postgresql.Driver".intern();

    public PostgreSQLConnectorProvider(String dbName, DataConnector dataConn) {
        super(dbName, dataConn, DRIVER_CLASS);
    }

    @Override
    protected ResultSet fetchTableMetadata(String tableName) throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getTables(this.scoped_db, null, null, new String[]{"TABLE"});
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve table names from remote datasource, cause:" + sqle.getMessage());
            throw new MetaException("Could not retrieve table names from remote datasource, cause:" + sqle.getMessage());
        }
        return rs;
    }

    @Override
    protected ResultSet fetchTableNames() throws MetaException {
        return null;
    }

    @Override
    protected String getCatalogName() {
        return this.scoped_db;
    }

    @Override
    protected String getDatabaseName() {
        return null;
    }

    @Override
    protected String getDataType(String dbDataType, int size) {
        String mappedType = super.getDataType(dbDataType, size);
        if (!mappedType.equalsIgnoreCase("void")) {
            return mappedType;
        }
        switch (dbDataType.toLowerCase()) {
            case "bpchar": 
            case "character": {
                mappedType = "char" + this.wrapSize(size);
                break;
            }
            case "int2": {
                mappedType = "smallint";
                break;
            }
            case "int4": {
                mappedType = "int";
                break;
            }
            case "int8": {
                mappedType = "bigint";
                break;
            }
            case "float4": {
                mappedType = "float";
                break;
            }
            case "float8": {
                mappedType = "double";
                break;
            }
            default: {
                mappedType = "void";
            }
        }
        return mappedType;
    }
}

