/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorProvider
extends AbstractJDBCConnectorProvider {
    private static Logger LOG = LoggerFactory.getLogger(OracleConnectorProvider.class);
    private static final String DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver".intern();

    public OracleConnectorProvider(String dbName, DataConnector dataConn) {
        super(dbName, dataConn, DRIVER_CLASS);
        this.driverClassName = DRIVER_CLASS;
    }

    @Override
    protected ResultSet fetchTableMetadata(String tableName) throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getColumns(null, this.scoped_db, tableName, null);
        }
        catch (Exception ex) {
            LOG.warn("Could not retrieve table names from remote datasource, cause:" + ex.getMessage());
            throw new MetaException("Could not retrieve table names from remote datasource, cause:" + ex);
        }
        return rs;
    }

    @Override
    protected ResultSet fetchTableNames() throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getTables(null, this.scoped_db, null, new String[]{"TABLE"});
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve table names from remote datasource, cause:" + sqle.getMessage());
            throw new MetaException("Could not retrieve table names from remote datasource, cause:" + sqle);
        }
        return rs;
    }

    @Override
    protected String getCatalogName() {
        return null;
    }

    @Override
    protected String getDatabaseName() {
        return this.scoped_db;
    }

    @Override
    protected String getDataType(String dbDataType, int size) {
        String mappedType = super.getDataType(dbDataType, size);
        if (!mappedType.equalsIgnoreCase("void")) {
            return mappedType;
        }
        switch (dbDataType.toLowerCase()) {
            case "varchar2": 
            case "nchar": 
            case "nvarchar2": {
                mappedType = "varchar" + this.wrapSize(size);
                break;
            }
            case "raw": 
            case "long raw": {
                mappedType = "string";
                break;
            }
            case "number": {
                mappedType = "int";
                break;
            }
            default: {
                mappedType = "void";
            }
        }
        return mappedType;
    }
}

