/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLConnectorProvider
extends AbstractJDBCConnectorProvider {
    private static Logger LOG = LoggerFactory.getLogger(MySQLConnectorProvider.class);
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver".intern();

    public MySQLConnectorProvider(String dbName, DataConnector dataConn) {
        super(dbName, dataConn, DRIVER_CLASS);
    }

    @Override
    protected ResultSet fetchTableNames() throws MetaException {
        ResultSet rs = null;
        try {
            rs = this.getConnection().getMetaData().getTables(this.scoped_db, null, null, new String[]{"TABLE"});
        }
        catch (SQLException sqle) {
            LOG.warn("Could not retrieve table names from remote datasource, cause:" + sqle.getMessage());
            throw new MetaException("Could not retrieve table names from remote datasource, cause:" + sqle);
        }
        return rs;
    }

    @Override
    public ResultSet fetchTableMetadata(String tableName) throws MetaException {
        try {
            Statement stmt = this.getConnection().createStatement();
            ResultSet rs = stmt.executeQuery("SELECT table_name, column_name, is_nullable, data_type, character_maximum_length FROM INFORMATION_SCHEMA.Columns where table_schema='" + this.scoped_db + "' and table_name='" + tableName + "'");
            return rs;
        }
        catch (Exception e) {
            LOG.warn("Exception retrieving remote table " + this.scoped_db + "." + tableName + " via data connector " + this.connector.getName());
            throw new MetaException("Error retrieving remote table:" + e);
        }
    }

    @Override
    protected String getCatalogName() {
        return this.scoped_db;
    }

    @Override
    protected String getDatabaseName() {
        return null;
    }

    @Override
    protected String getDataType(String dbDataType, int size) {
        String mappedType = super.getDataType(dbDataType, size);
        if (!mappedType.equalsIgnoreCase("void")) {
            return mappedType;
        }
        switch (dbDataType.toLowerCase()) {
            default: 
        }
        mappedType = "void";
        return mappedType;
    }
}

