/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class DoubleColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Object newEst;
        Object oldEst;
        DoubleColumnStatsDataInspector aggregateData = ColumnsStatsUtils.doubleInspectorFromStats(aggregateColStats);
        DoubleColumnStatsDataInspector newData = ColumnsStatsUtils.doubleInspectorFromStats(newColStats);
        this.setLowValue(aggregateData, newData);
        this.setHighValue(aggregateData, newData);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            long ndv;
            oldEst = aggregateData.getNdvEstimator();
            if (oldEst.canMerge((NumDistinctValueEstimator)(newEst = newData.getNdvEstimator()))) {
                oldEst.mergeEstimators((NumDistinctValueEstimator)newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator((NumDistinctValueEstimator)oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            LOG.debug("Use bitvector to merge column {}'s ndvs of {} and {} to be {}", new Object[]{aggregateColStats.getColName(), aggregateData.getNumDVs(), newData.getNumDVs(), ndv});
            aggregateData.setNumDVs(ndv);
        }
        oldEst = aggregateData.getHistogramEstimator();
        newEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), (KllHistogramEstimator)oldEst, (KllHistogramEstimator)newEst));
        aggregateColStats.getStatsData().setDoubleStats(aggregateData);
    }

    public void setLowValue(DoubleColumnStatsDataInspector aggregateData, DoubleColumnStatsDataInspector newData) {
        if (!aggregateData.isSetLowValue() && !newData.isSetLowValue()) {
            return;
        }
        double lowValue = Math.min(aggregateData.isSetLowValue() ? aggregateData.getLowValue() : Double.MAX_VALUE, newData.isSetLowValue() ? newData.getLowValue() : Double.MAX_VALUE);
        aggregateData.setLowValue(lowValue);
    }

    public void setHighValue(DoubleColumnStatsDataInspector aggregateData, DoubleColumnStatsDataInspector newData) {
        if (!aggregateData.isSetHighValue() && !newData.isSetHighValue()) {
            return;
        }
        double highValue = Math.max(aggregateData.isSetHighValue() ? aggregateData.getHighValue() : Double.MIN_VALUE, newData.isSetHighValue() ? newData.getHighValue() : Double.MIN_VALUE);
        aggregateData.setHighValue(highValue);
    }
}

