/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class DecimalColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Object newEst;
        Object oldEst;
        DecimalColumnStatsDataInspector aggregateData = ColumnsStatsUtils.decimalInspectorFromStats(aggregateColStats);
        DecimalColumnStatsDataInspector newData = ColumnsStatsUtils.decimalInspectorFromStats(newColStats);
        this.setLowValue(aggregateData, newData);
        this.setHighValue(aggregateData, newData);
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            oldEst = aggregateData.getNdvEstimator();
            newEst = newData.getNdvEstimator();
            long ndv = -1L;
            if (oldEst.canMerge((NumDistinctValueEstimator)newEst)) {
                oldEst.mergeEstimators((NumDistinctValueEstimator)newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator((NumDistinctValueEstimator)oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
        }
        oldEst = aggregateData.getHistogramEstimator();
        newEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), (KllHistogramEstimator)oldEst, (KllHistogramEstimator)newEst));
        aggregateColStats.getStatsData().setDecimalStats(aggregateData);
    }

    public void setLowValue(DecimalColumnStatsDataInspector aggregateData, DecimalColumnStatsDataInspector newData) {
        if (!aggregateData.isSetLowValue() && !newData.isSetLowValue()) {
            return;
        }
        Decimal aggregateLowValue = aggregateData.getLowValue();
        Decimal newLowValue = newData.getLowValue();
        Decimal mergedLowValue = null;
        mergedLowValue = aggregateData.isSetLowValue() && newData.isSetLowValue() ? (aggregateLowValue.compareTo(newLowValue) > 0 ? newLowValue : aggregateLowValue) : (aggregateLowValue == null ? newLowValue : aggregateLowValue);
        aggregateData.setLowValue(mergedLowValue);
    }

    public void setHighValue(DecimalColumnStatsDataInspector aggregateData, DecimalColumnStatsDataInspector newData) {
        if (!aggregateData.isSetHighValue() && !newData.isSetHighValue()) {
            return;
        }
        Decimal aggregateHighValue = aggregateData.getHighValue();
        Decimal newHighValue = newData.getHighValue();
        Decimal mergedHighValue = null;
        mergedHighValue = aggregateData.isSetHighValue() && newData.isSetHighValue() ? (aggregateHighValue.compareTo(newHighValue) > 0 ? aggregateHighValue : newHighValue) : (aggregateHighValue == null ? newHighValue : aggregateHighValue);
        aggregateData.setHighValue(mergedHighValue);
    }
}

