/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnStatsMerger {
    protected static final Logger LOG = LoggerFactory.getLogger(ColumnStatsMerger.class);

    public abstract void merge(ColumnStatisticsObj var1, ColumnStatisticsObj var2);

    protected KllHistogramEstimator mergeHistogramEstimator(String columnName, KllHistogramEstimator oldEst, KllHistogramEstimator newEst) {
        if (oldEst != null && newEst != null) {
            if (oldEst.canMerge(newEst)) {
                LOG.trace("Merging old sketch {} with new sketch {}...", (Object)oldEst.getSketch(), (Object)newEst.getSketch());
                oldEst.mergeEstimators(newEst);
                LOG.trace("Resulting sketch is {}", (Object)oldEst.getSketch());
                return oldEst;
            }
            LOG.debug("Merging histograms of column {}", (Object)columnName);
        } else if (newEst != null) {
            LOG.trace("Old sketch is empty, the new sketch is used {}", (Object)newEst.getSketch());
            return newEst;
        }
        return oldEst;
    }
}

