/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.cache;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimatorFactory;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;

public class DoubleColumnStatsDataInspector
extends DoubleColumnStatsData {
    private NumDistinctValueEstimator ndvEstimator;
    private KllHistogramEstimator histogramEstimator;

    public DoubleColumnStatsDataInspector() {
    }

    public DoubleColumnStatsDataInspector(long numNulls, long numDVs) {
        super(numNulls, numDVs);
    }

    public DoubleColumnStatsDataInspector(DoubleColumnStatsDataInspector other) {
        super(other);
        if (other.ndvEstimator != null) {
            super.setBitVectors(this.ndvEstimator.serialize());
        }
        if (other.histogramEstimator != null) {
            super.setHistogram(this.histogramEstimator.serialize());
        }
    }

    public DoubleColumnStatsDataInspector(DoubleColumnStatsData other) {
        super(other);
    }

    @Override
    public DoubleColumnStatsDataInspector deepCopy() {
        return new DoubleColumnStatsDataInspector(this);
    }

    @Override
    public byte[] getBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.getBitVectors();
    }

    @Override
    public byte[] getHistogram() {
        if (this.histogramEstimator != null) {
            this.updateHistogram();
        }
        return super.getHistogram();
    }

    @Override
    public ByteBuffer bufferForBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.bufferForBitVectors();
    }

    @Override
    public ByteBuffer bufferForHistogram() {
        if (this.histogramEstimator != null) {
            this.updateHistogram();
        }
        return super.bufferForHistogram();
    }

    @Override
    public void setBitVectors(byte[] bitVectors) {
        super.setBitVectors(bitVectors);
        this.ndvEstimator = null;
    }

    @Override
    public void setBitVectors(ByteBuffer bitVectors) {
        super.setBitVectors(bitVectors);
        this.ndvEstimator = null;
    }

    @Override
    public void setHistogram(byte[] stats) {
        super.setHistogram(stats);
        this.histogramEstimator = null;
    }

    @Override
    public void setHistogram(ByteBuffer stats) {
        super.setHistogram(stats);
        this.histogramEstimator = null;
    }

    @Override
    public void unsetBitVectors() {
        super.unsetBitVectors();
        this.ndvEstimator = null;
    }

    @Override
    public void unsetHistogram() {
        super.unsetHistogram();
        this.histogramEstimator = null;
    }

    @Override
    public boolean isSetBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.isSetBitVectors();
    }

    @Override
    public boolean isSetHistogram() {
        if (this.histogramEstimator != null) {
            this.updateHistogram();
        }
        return super.isSetHistogram();
    }

    @Override
    public void setBitVectorsIsSet(boolean value) {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        super.setBitVectorsIsSet(value);
    }

    @Override
    public void setHistogramIsSet(boolean value) {
        if (this.histogramEstimator != null) {
            this.updateHistogram();
        }
        super.setHistogramIsSet(value);
    }

    public NumDistinctValueEstimator getNdvEstimator() {
        if (this.ndvEstimator == null && this.isSetBitVectors() && this.getBitVectors().length != 0) {
            this.updateNdvEstimator();
        }
        return this.ndvEstimator;
    }

    public KllHistogramEstimator getHistogramEstimator() {
        if (this.histogramEstimator == null && this.isSetHistogram() && this.getHistogram().length != 0) {
            this.updateHistogramEstimator();
        }
        return this.histogramEstimator;
    }

    public void setNdvEstimator(NumDistinctValueEstimator ndvEstimator) {
        super.unsetBitVectors();
        this.ndvEstimator = ndvEstimator;
    }

    public void setHistogramEstimator(KllHistogramEstimator histogramEstimator) {
        super.unsetHistogram();
        this.histogramEstimator = histogramEstimator;
    }

    private void updateBitVectors() {
        super.setBitVectors(this.ndvEstimator.serialize());
        this.ndvEstimator = null;
    }

    private void updateHistogram() {
        super.setHistogram(this.histogramEstimator.serialize());
        this.histogramEstimator = null;
    }

    private void updateNdvEstimator() {
        this.ndvEstimator = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator(super.getBitVectors());
        super.unsetBitVectors();
    }

    private void updateHistogramEstimator() {
        this.histogramEstimator = KllHistogramEstimatorFactory.getKllHistogramEstimator(super.getHistogram());
        super.unsetHistogram();
    }
}

