/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.utils.DecimalUtils;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.aggr.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.DecimalColumnStatsMerger;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalColumnStatsAggregator
extends ColumnStatsAggregator
implements IExtrapolatePartStatus {
    private static final Logger LOG = LoggerFactory.getLogger(DecimalColumnStatsAggregator.class);

    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        this.checkStatisticsList(colStatsWithSourceInfo);
        ColumnStatisticsObj statsObj = null;
        String colName = null;
        boolean doAllPartitionContainStats = partNames.size() == colStatsWithSourceInfo.size();
        NumDistinctValueEstimator ndvEstimator = null;
        boolean areAllNDVEstimatorsMergeable = true;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            DecimalColumnStatsDataInspector columnStatsData;
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                String colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
                LOG.trace("doAllPartitionContainStats for column: {} is: {}", (Object)colName, (Object)doAllPartitionContainStats);
            }
            if ((columnStatsData = ColumnsStatsUtils.decimalInspectorFromStats(cso)).getNdvEstimator() == null) {
                areAllNDVEstimatorsMergeable = false;
                break;
            }
            NumDistinctValueEstimator estimator = columnStatsData.getNdvEstimator();
            if (ndvEstimator == null) {
                ndvEstimator = estimator;
                continue;
            }
            if (ndvEstimator.canMerge(estimator)) continue;
            areAllNDVEstimatorsMergeable = false;
            break;
        }
        if (areAllNDVEstimatorsMergeable && ndvEstimator != null) {
            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
        }
        LOG.debug("all of the bit vectors can merge for {} is {}", colName, (Object)areAllNDVEstimatorsMergeable);
        ColumnStatisticsData columnStatisticsData = this.initColumnStatisticsData();
        if (doAllPartitionContainStats || colStatsWithSourceInfo.size() < 2) {
            DecimalColumnStatsData aggregateData = null;
            long lowerBound = 0L;
            long higherBound = 0L;
            double densityAvgSum = 0.0;
            DecimalColumnStatsMerger merger = new DecimalColumnStatsMerger();
            for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                ColumnStatisticsObj cso = csp.getColStatsObj();
                DecimalColumnStatsDataInspector newData = ColumnsStatsUtils.decimalInspectorFromStats(cso);
                lowerBound = Math.max(lowerBound, newData.getNumDVs());
                higherBound += newData.getNumDVs();
                if (newData.isSetLowValue() && newData.isSetHighValue()) {
                    densityAvgSum += (MetaStoreUtils.decimalToDouble(newData.getHighValue()) - MetaStoreUtils.decimalToDouble(newData.getLowValue())) / (double)newData.getNumDVs();
                }
                if (areAllNDVEstimatorsMergeable && ndvEstimator != null) {
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                merger.setLowValue((DecimalColumnStatsDataInspector)aggregateData, newData);
                merger.setHighValue((DecimalColumnStatsDataInspector)aggregateData, newData);
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            if (areAllNDVEstimatorsMergeable && ndvEstimator != null) {
                aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            } else {
                long estimation = 0L;
                if (this.useDensityFunctionForNDVEstimation && aggregateData != null && aggregateData.isSetLowValue() && aggregateData.isSetHighValue()) {
                    double densityAvg = densityAvgSum / (double)partNames.size();
                    if (aggregateData.getHighValue() != null && aggregateData.getLowValue() != null) {
                        estimation = (long)((MetaStoreUtils.decimalToDouble(aggregateData.getHighValue()) - MetaStoreUtils.decimalToDouble(aggregateData.getLowValue())) / densityAvg);
                    }
                    if (estimation < lowerBound) {
                        estimation = lowerBound;
                    } else if (estimation > higherBound) {
                        estimation = higherBound;
                    }
                } else {
                    estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * this.ndvTuner);
                }
                aggregateData.setNumDVs(estimation);
            }
            columnStatisticsData.setDecimalStats(aggregateData);
        } else {
            LOG.debug("start extrapolation for {}", (Object)colName);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap<String, Double> adjustedIndexMap = new HashMap<String, Double>();
            HashMap<String, ColumnStatisticsData> adjustedStatsMap = new HashMap<String, ColumnStatisticsData>();
            double densityAvgSum = 0.0;
            if (!areAllNDVEstimatorsMergeable) {
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    DecimalColumnStatsData newData = cso.getStatsData().getDecimalStats();
                    if (this.useDensityFunctionForNDVEstimation && newData.isSetLowValue() && newData.isSetHighValue() && newData.getHighValue() != null && newData.getLowValue() != null) {
                        densityAvgSum += (MetaStoreUtils.decimalToDouble(newData.getHighValue()) - MetaStoreUtils.decimalToDouble(newData.getLowValue())) / (double)newData.getNumDVs();
                    }
                    adjustedIndexMap.put(partName, (double)((Integer)indexMap.get(partName)));
                    adjustedStatsMap.put(partName, cso.getStatsData());
                }
            } else {
                StringBuilder pseudoPartName = new StringBuilder();
                double pseudoIndexSum = 0.0;
                int length = 0;
                int curIndex = -1;
                DecimalColumnStatsData aggregateData = null;
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    DecimalColumnStatsDataInspector newData = ColumnsStatsUtils.decimalInspectorFromStats(cso);
                    if ((Integer)indexMap.get(partName) != curIndex) {
                        if (length > 0) {
                            adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                            ColumnStatisticsData csd = new ColumnStatisticsData();
                            csd.setDecimalStats(aggregateData);
                            adjustedStatsMap.put(pseudoPartName.toString(), csd);
                            if (this.useDensityFunctionForNDVEstimation && aggregateData.getHighValue() != null && aggregateData.getLowValue() != null) {
                                densityAvgSum += (MetaStoreUtils.decimalToDouble(aggregateData.getHighValue()) - MetaStoreUtils.decimalToDouble(aggregateData.getLowValue())) / (double)aggregateData.getNumDVs();
                            }
                            pseudoPartName = new StringBuilder();
                            pseudoIndexSum = 0.0;
                            length = 0;
                            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
                        }
                        aggregateData = null;
                    }
                    curIndex = (Integer)indexMap.get(partName);
                    pseudoPartName.append(partName);
                    pseudoIndexSum += (double)curIndex;
                    ++length;
                    ++curIndex;
                    if (aggregateData == null) {
                        aggregateData = newData.deepCopy();
                    } else {
                        if (aggregateData.getLowValue() != null && newData.getLowValue() != null && MetaStoreUtils.decimalToDouble(aggregateData.getLowValue()) < MetaStoreUtils.decimalToDouble(newData.getLowValue())) {
                            aggregateData.setLowValue(aggregateData.getLowValue());
                        } else {
                            aggregateData.setLowValue(newData.getLowValue());
                        }
                        if (aggregateData.getHighValue() != null && newData.getHighValue() != null && MetaStoreUtils.decimalToDouble(aggregateData.getHighValue()) > MetaStoreUtils.decimalToDouble(newData.getHighValue())) {
                            aggregateData.setHighValue(aggregateData.getHighValue());
                        } else {
                            aggregateData.setHighValue(newData.getHighValue());
                        }
                        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                    }
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (length > 0) {
                    adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                    aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                    ColumnStatisticsData csd = new ColumnStatisticsData();
                    csd.setDecimalStats(aggregateData);
                    adjustedStatsMap.put(pseudoPartName.toString(), csd);
                    if (this.useDensityFunctionForNDVEstimation && aggregateData.getHighValue() != null && aggregateData.getLowValue() != null) {
                        densityAvgSum += (MetaStoreUtils.decimalToDouble(aggregateData.getHighValue()) - MetaStoreUtils.decimalToDouble(aggregateData.getLowValue())) / (double)aggregateData.getNumDVs();
                    }
                }
            }
            this.extrapolate(columnStatisticsData, partNames.size(), colStatsWithSourceInfo.size(), adjustedIndexMap, adjustedStatsMap, densityAvgSum / (double)adjustedStatsMap.size());
        }
        LOG.debug("Ndv estimation for {} is {}. # of partitions requested: {}. # of partitions found: {}", new Object[]{colName, columnStatisticsData.getDecimalStats().getNumDVs(), partNames.size(), colStatsWithSourceInfo.size()});
        KllHistogramEstimator mergedKllHistogramEstimator = this.mergeHistograms(colStatsWithSourceInfo);
        if (mergedKllHistogramEstimator != null) {
            columnStatisticsData.getDecimalStats().setHistogram(mergedKllHistogramEstimator.serialize());
        }
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    @Override
    protected ColumnStatisticsData initColumnStatisticsData() {
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (!columnStatisticsData.isSetDecimalStats()) {
            columnStatisticsData.setDecimalStats(new DecimalColumnStatsData());
        }
        return columnStatisticsData;
    }

    @Override
    public void extrapolate(ColumnStatisticsData extrapolateData, int numParts, int numPartsWithStats, Map<String, Double> adjustedIndexMap, Map<String, ColumnStatisticsData> adjustedStatsMap, double densityAvg) {
        long ndv;
        HashMap<String, DecimalColumnStatsData> extractedAdjustedStatsMap = new HashMap<String, DecimalColumnStatsData>();
        for (Map.Entry<String, ColumnStatisticsData> entry : adjustedStatsMap.entrySet()) {
            extractedAdjustedStatsMap.put(entry.getKey(), entry.getValue().getDecimalStats());
        }
        LinkedList list = new LinkedList(extractedAdjustedStatsMap.entrySet());
        list.sort(Comparator.comparing(o -> ((DecimalColumnStatsData)o.getValue()).getLowValue()));
        double minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        double maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        double min = MetaStoreUtils.decimalToDouble(((DecimalColumnStatsData)((Map.Entry)list.get(0)).getValue()).getLowValue());
        double max = MetaStoreUtils.decimalToDouble(((DecimalColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getLowValue());
        double lowValue = minInd == maxInd ? min : (minInd < maxInd ? max - (max - min) * maxInd / (maxInd - minInd) : max - (max - min) * ((double)numParts - maxInd) / (minInd - maxInd));
        list.sort(Comparator.comparing(o -> ((DecimalColumnStatsData)o.getValue()).getHighValue()));
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        min = MetaStoreUtils.decimalToDouble(((DecimalColumnStatsData)((Map.Entry)list.get(0)).getValue()).getHighValue());
        max = MetaStoreUtils.decimalToDouble(((DecimalColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getHighValue());
        double highValue = minInd == maxInd ? min : (minInd < maxInd ? min + (max - min) * ((double)numParts - minInd) / (maxInd - minInd) : min + (max - min) * minInd / (minInd - maxInd));
        long numNulls = 0L;
        for (Map.Entry entry : extractedAdjustedStatsMap.entrySet()) {
            numNulls += ((DecimalColumnStatsData)entry.getValue()).getNumNulls();
        }
        numNulls = numNulls * (long)numParts / (long)numPartsWithStats;
        list.sort(Comparator.comparingLong(o -> ((DecimalColumnStatsData)o.getValue()).getNumDVs()));
        long lowerBound = ((DecimalColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
        long higherBound = 0L;
        for (Map.Entry entry : list) {
            higherBound += ((DecimalColumnStatsData)entry.getValue()).getNumDVs();
        }
        if (this.useDensityFunctionForNDVEstimation && densityAvg != 0.0) {
            ndv = (long)((highValue - lowValue) / densityAvg);
            if (ndv < lowerBound) {
                ndv = lowerBound;
            } else if (ndv > higherBound) {
                ndv = higherBound;
            }
        } else {
            minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
            maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
            long ndvMin = ((DecimalColumnStatsData)((Map.Entry)list.get(0)).getValue()).getNumDVs();
            long ndvMax = ((DecimalColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
            ndv = minInd == maxInd ? ndvMin : (minInd < maxInd ? (long)((double)ndvMin + (double)(ndvMax - ndvMin) * ((double)numParts - minInd) / (maxInd - minInd)) : (long)((double)ndvMin + (double)(ndvMax - ndvMin) * minInd / (minInd - maxInd)));
        }
        DecimalColumnStatsData extrapolateDecimalData = extrapolateData.getDecimalStats();
        extrapolateDecimalData.setLowValue(DecimalUtils.createThriftDecimal(String.valueOf(lowValue)));
        extrapolateDecimalData.setHighValue(DecimalUtils.createThriftDecimal(String.valueOf(highValue)));
        extrapolateDecimalData.setNumNulls(numNulls);
        extrapolateDecimalData.setNumDVs(ndv);
    }
}

