/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class BooleanColumnStatsAggregator
extends ColumnStatsAggregator {
    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        this.checkStatisticsList(colStatsWithSourceInfo);
        ColumnStatisticsObj statsObj = null;
        BooleanColumnStatsData aggregateData = null;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                String colName = cso.getColName();
                String colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
            }
            BooleanColumnStatsData newData = cso.getStatsData().getBooleanStats();
            if (aggregateData == null) {
                aggregateData = newData.deepCopy();
                continue;
            }
            aggregateData.setNumTrues(aggregateData.getNumTrues() + newData.getNumTrues());
            aggregateData.setNumFalses(aggregateData.getNumFalses() + newData.getNumFalses());
            aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        }
        ColumnStatisticsData columnStatisticsData = this.initColumnStatisticsData();
        columnStatisticsData.setBooleanStats(aggregateData);
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    @Override
    protected ColumnStatisticsData initColumnStatisticsData() {
        return new ColumnStatisticsData();
    }
}

