/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.StorageDescriptorBuilder;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.thrift.TException;

public class TableBuilder
extends StorageDescriptorBuilder<TableBuilder> {
    private String catName;
    private String dbName = "default";
    private String tableName;
    private String owner;
    private String viewOriginalText;
    private String viewExpandedText;
    private String type;
    private String mvValidTxnList;
    private CreationMetadata cm;
    private List<FieldSchema> partCols;
    private int createTime;
    private int lastAccessTime;
    private int retention = 0;
    private Map<String, String> tableParams = new HashMap<String, String>();
    private boolean rewriteEnabled;
    private boolean temporary = false;
    private List<SourceTable> mvReferencedTables;
    private PrincipalType ownerType;

    public TableBuilder() {
        this.createTime = this.lastAccessTime = (int)(System.currentTimeMillis() / 1000L);
        this.partCols = new ArrayList<FieldSchema>();
        this.type = TableType.MANAGED_TABLE.name();
        this.mvReferencedTables = new ArrayList<SourceTable>();
        super.setChild(this);
    }

    public TableBuilder setCatName(String catName) {
        this.catName = catName;
        return this;
    }

    public TableBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public TableBuilder inDb(Database db) {
        this.dbName = db.getName();
        this.catName = db.getCatalogName();
        return this;
    }

    public TableBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableBuilder setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public TableBuilder setOwnerType(PrincipalType ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    public TableBuilder setViewOriginalText(String viewOriginalText) {
        this.viewOriginalText = viewOriginalText;
        return this;
    }

    public TableBuilder setViewExpandedText(String viewExpandedText) {
        this.viewExpandedText = viewExpandedText;
        return this;
    }

    public TableBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public TableBuilder setCreationMetadata(CreationMetadata cm) {
        this.cm = cm;
        return this;
    }

    public TableBuilder setPartCols(List<FieldSchema> partCols) {
        this.partCols = partCols;
        return this;
    }

    public TableBuilder addPartCol(String name, String type, String comment) {
        this.partCols.add(new FieldSchema(name, type, comment));
        return this;
    }

    public TableBuilder addPartCol(String name, String type) {
        return this.addPartCol(name, type, "");
    }

    public TableBuilder setCreateTime(int createTime) {
        this.createTime = createTime;
        return this;
    }

    public TableBuilder setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public TableBuilder setRetention(int retention) {
        this.retention = retention;
        return this;
    }

    public TableBuilder setTableParams(Map<String, String> tableParams) {
        this.tableParams = tableParams;
        return this;
    }

    public TableBuilder addTableParam(String key, String value) {
        if (this.tableParams == null) {
            this.tableParams = new HashMap<String, String>();
        }
        this.tableParams.put(key, value);
        return this;
    }

    public TableBuilder setRewriteEnabled(boolean rewriteEnabled) {
        this.rewriteEnabled = rewriteEnabled;
        return this;
    }

    public TableBuilder setTemporary(boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public TableBuilder addMaterializedViewReferencedTable(SourceTable sourceTable) {
        this.mvReferencedTables.add(sourceTable);
        return this;
    }

    public TableBuilder addMaterializedViewReferencedTables(Set<SourceTable> tableNames) {
        for (SourceTable tableName : tableNames) {
            this.addMaterializedViewReferencedTable(tableName);
        }
        return this;
    }

    public TableBuilder setMaterializedViewValidTxnList(ValidTxnList validTxnList) {
        this.mvValidTxnList = validTxnList.writeToString();
        return this;
    }

    public Table build(Configuration conf) throws MetaException {
        if (this.tableName == null) {
            throw new MetaException("You must set the table name");
        }
        if (this.ownerType == null) {
            this.ownerType = PrincipalType.USER;
        }
        if (this.owner == null) {
            try {
                this.owner = SecurityUtils.getUser();
            }
            catch (IOException e) {
                throw MetaStoreUtils.newMetaException(e);
            }
        }
        if (this.catName == null) {
            this.catName = MetaStoreUtils.getDefaultCatalog(conf);
        }
        Table t = new Table(this.tableName, this.dbName, this.owner, this.createTime, this.lastAccessTime, this.retention, this.buildSd(), this.partCols, this.tableParams, this.viewOriginalText, this.viewExpandedText, this.type);
        if (this.rewriteEnabled) {
            t.setRewriteEnabled(true);
        }
        if (this.temporary) {
            t.setTemporary(this.temporary);
        }
        t.setCatName(this.catName);
        if (!this.mvReferencedTables.isEmpty()) {
            Set<String> tablesUsed = this.mvReferencedTables.stream().map(sourceTable -> TableName.getDbTable((String)sourceTable.getTable().getDbName(), (String)sourceTable.getTable().getTableName())).collect(Collectors.toSet());
            CreationMetadata cm = new CreationMetadata(this.catName, this.dbName, this.tableName, tablesUsed);
            cm.setSourceTables(this.mvReferencedTables);
            if (this.mvValidTxnList != null) {
                cm.setValidTxnList(this.mvValidTxnList);
            }
            t.setCreationMetadata(cm);
        }
        return t;
    }

    public Table create(IMetaStoreClient client, Configuration conf) throws TException {
        Table t = this.build(conf);
        client.createTable(t);
        return t;
    }
}

