/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBasedJWKSProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)URLBasedJWKSProvider.class.getName());
    private static final String SKIP_SSL_CERT = "metastore.authentication.jwt.jwks.skip.ssl.cert";
    private final Configuration conf;
    private List<JWKSet> jwkSets = new ArrayList<JWKSet>();

    public URLBasedJWKSProvider(Configuration conf) throws IOException, ParseException, GeneralSecurityException {
        this.conf = conf;
        this.loadJWKSets();
    }

    private void loadJWKSets() throws IOException, ParseException, GeneralSecurityException {
        String[] jwksURLs;
        String jwksURL = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL);
        if (jwksURL == null || jwksURL.isEmpty()) {
            LOG.warn("Invalid value of property: {}, JWT authentication will not work without configuring keyset", (Object)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL.getHiveName());
            return;
        }
        for (String urlString : jwksURLs = jwksURL.split(",")) {
            SSLContext context = null;
            if ("true".equalsIgnoreCase(MetastoreConf.get(this.conf, SKIP_SSL_CERT))) {
                context = SSLContext.getInstance("TLS");
                X509TrustManager trustAllManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                };
                context.init(null, new X509TrustManager[]{trustAllManager}, new SecureRandom());
            }
            HttpGet get = new HttpGet(urlString);
            try (CloseableHttpClient httpClient = context == null ? HttpClients.createDefault() : HttpClients.custom().setSSLContext(context).build();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    this.jwkSets.add(JWKSet.load((InputStream)entity.getContent()));
                }
            }
            LOG.info("Loaded JWKS from " + urlString);
        }
    }

    public List<JWK> getJWKs(JWSHeader header) throws AuthenticationException {
        JWKMatcher matcher = JWKMatcher.forJWSHeader((JWSHeader)header);
        if (matcher == null) {
            throw new AuthenticationException("Unsupported algorithm: " + header.getAlgorithm());
        }
        ArrayList<JWK> jwks = new ArrayList<JWK>();
        JWKSelector selector = new JWKSelector(matcher);
        for (JWKSet jwkSet : this.jwkSets) {
            jwks.addAll(selector.select(jwkSet));
        }
        return jwks;
    }
}

