/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.jwt;

import com.cloudera.client.api.TokenProvider;
import com.cloudera.client.api.TokenProviderFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrbToJWTExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(KrbToJWTExchanger.class);
    private static final String RETRIES_LIMIT = "knox.jwt.client.failure.retries";
    private static KrbToJWTExchanger krbJwtExchanger;
    private final int retryLimit;
    private final LoadingCache<String, TokenProvider> tokenProviders;

    private KrbToJWTExchanger(final Configuration conf) {
        Objects.requireNonNull(conf, "conf is null");
        this.retryLimit = conf.getInt(RETRIES_LIMIT, 5);
        this.tokenProviders = CacheBuilder.newBuilder().maximumSize(1000L).softValues().expireAfterWrite(300000L, TimeUnit.MILLISECONDS).removalListener(removalNotification -> {
            LOGGER.info("Removed the TokenProvider for user: {}", removalNotification.getKey());
            try {
                ((TokenProvider)removalNotification.getValue()).close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close the TokenProvider", (Throwable)e);
            }
        }).build((CacheLoader)new CacheLoader<String, TokenProvider>(){

            public TokenProvider load(String user) throws Exception {
                LOGGER.info("Creating TokenProvider for user: {}", (Object)user);
                return TokenProviderFactory.getTokenProvider((Configuration)conf);
            }
        });
    }

    public static synchronized KrbToJWTExchanger getTokenProvider(Configuration conf) {
        if (krbJwtExchanger == null) {
            krbJwtExchanger = new KrbToJWTExchanger(conf);
        }
        return krbJwtExchanger;
    }

    public static boolean isKrbToJWTEnabled(Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return false;
        }
        String authType = MetastoreConf.getAsString(conf, MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE);
        if (!"jwt".equalsIgnoreCase(authType)) {
            return false;
        }
        if (StringUtils.isEmpty((String)MetastoreConf.get(conf, "knox.jwt.client.gateway.address"))) {
            LOGGER.warn("Kerberos ticket for JWT is disabled as knox.jwt.client.gateway.address is not configured");
            return false;
        }
        return true;
    }

    public String getJwtToken() throws Exception {
        String userName = SecurityUtils.getUser();
        final TokenProvider tokenProvider = (TokenProvider)this.tokenProviders.get((Object)userName);
        Retry<String> retry = new Retry<String>(this.retryLimit, 1000){

            @Override
            public String execute() throws Exception {
                LOGGER.debug("==> TokenProvider.getBearerToken(), tokenProvider: {}", (Object)tokenProvider);
                String jwtToken = tokenProvider.getBearerToken();
                if (LOGGER.isDebugEnabled()) {
                    int length = jwtToken.length();
                    LOGGER.debug("==> TokenProvider.getBearerToken(), token: {}", (Object)(StringUtils.repeat((String)"*", (int)(length / 2)) + jwtToken.substring(length / 2)));
                }
                return jwtToken;
            }
        };
        return (String)retry.runWithDelay();
    }

    private abstract class Retry<T> {
        private final int retryLimit;
        private final int retryInterval;
        private int retries;

        Retry(int retryLimit, int retryInterval) {
            this.retryLimit = retryLimit;
            this.retryInterval = retryInterval;
        }

        abstract T execute() throws Exception;

        T runWithDelay() throws Exception {
            try {
                return this.execute();
            }
            catch (Exception e) {
                ++this.retries;
                if (this.retryLimit <= this.retries) {
                    throw e;
                }
                Thread.sleep(this.retryInterval);
                return this.runWithDelay();
            }
        }
    }
}

