/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PropertySetRequest
implements TBase<PropertySetRequest, _Fields>,
Serializable,
Cloneable,
Comparable<PropertySetRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("PropertySetRequest");
    private static final TField NAME_SPACE_FIELD_DESC = new TField("nameSpace", 11, 1);
    private static final TField PROPERTY_MAP_FIELD_DESC = new TField("propertyMap", 13, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PropertySetRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PropertySetRequestTupleSchemeFactory();
    @Nullable
    private String nameSpace;
    @Nullable
    private Map<String, String> propertyMap;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PropertySetRequest() {
    }

    public PropertySetRequest(String nameSpace, Map<String, String> propertyMap) {
        this();
        this.nameSpace = nameSpace;
        this.propertyMap = propertyMap;
    }

    public PropertySetRequest(PropertySetRequest other) {
        if (other.isSetNameSpace()) {
            this.nameSpace = other.nameSpace;
        }
        if (other.isSetPropertyMap()) {
            HashMap<String, String> __this__propertyMap = new HashMap<String, String>(other.propertyMap);
            this.propertyMap = __this__propertyMap;
        }
    }

    public PropertySetRequest deepCopy() {
        return new PropertySetRequest(this);
    }

    public void clear() {
        this.nameSpace = null;
        this.propertyMap = null;
    }

    @Nullable
    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(@Nullable String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void unsetNameSpace() {
        this.nameSpace = null;
    }

    public boolean isSetNameSpace() {
        return this.nameSpace != null;
    }

    public void setNameSpaceIsSet(boolean value) {
        if (!value) {
            this.nameSpace = null;
        }
    }

    public int getPropertyMapSize() {
        return this.propertyMap == null ? 0 : this.propertyMap.size();
    }

    public void putToPropertyMap(String key, String val) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, String>();
        }
        this.propertyMap.put(key, val);
    }

    @Nullable
    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(@Nullable Map<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public void unsetPropertyMap() {
        this.propertyMap = null;
    }

    public boolean isSetPropertyMap() {
        return this.propertyMap != null;
    }

    public void setPropertyMapIsSet(boolean value) {
        if (!value) {
            this.propertyMap = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case NAME_SPACE: {
                if (value == null) {
                    this.unsetNameSpace();
                    break;
                }
                this.setNameSpace((String)value);
                break;
            }
            case PROPERTY_MAP: {
                if (value == null) {
                    this.unsetPropertyMap();
                    break;
                }
                this.setPropertyMap((Map)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME_SPACE: {
                return this.getNameSpace();
            }
            case PROPERTY_MAP: {
                return this.getPropertyMap();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME_SPACE: {
                return this.isSetNameSpace();
            }
            case PROPERTY_MAP: {
                return this.isSetPropertyMap();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof PropertySetRequest) {
            return this.equals((PropertySetRequest)that);
        }
        return false;
    }

    public boolean equals(PropertySetRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_nameSpace = this.isSetNameSpace();
        boolean that_present_nameSpace = that.isSetNameSpace();
        if (this_present_nameSpace || that_present_nameSpace) {
            if (!this_present_nameSpace || !that_present_nameSpace) {
                return false;
            }
            if (!this.nameSpace.equals(that.nameSpace)) {
                return false;
            }
        }
        boolean this_present_propertyMap = this.isSetPropertyMap();
        boolean that_present_propertyMap = that.isSetPropertyMap();
        if (this_present_propertyMap || that_present_propertyMap) {
            if (!this_present_propertyMap || !that_present_propertyMap) {
                return false;
            }
            if (!this.propertyMap.equals(that.propertyMap)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetNameSpace() ? 131071 : 524287);
        if (this.isSetNameSpace()) {
            hashCode = hashCode * 8191 + this.nameSpace.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPropertyMap() ? 131071 : 524287);
        if (this.isSetPropertyMap()) {
            hashCode = hashCode * 8191 + this.propertyMap.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(PropertySetRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetNameSpace(), other.isSetNameSpace());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNameSpace() && (lastComparison = TBaseHelper.compareTo((String)this.nameSpace, (String)other.nameSpace)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPropertyMap(), other.isSetPropertyMap());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPropertyMap() && (lastComparison = TBaseHelper.compareTo(this.propertyMap, other.propertyMap)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        PropertySetRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        PropertySetRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PropertySetRequest(");
        boolean first = true;
        sb.append("nameSpace:");
        if (this.nameSpace == null) {
            sb.append("null");
        } else {
            sb.append(this.nameSpace);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("propertyMap:");
        if (this.propertyMap == null) {
            sb.append("null");
        } else {
            sb.append(this.propertyMap);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetNameSpace()) {
            throw new TProtocolException("Required field 'nameSpace' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME_SPACE, new FieldMetaData("nameSpace", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROPERTY_MAP, new FieldMetaData("propertyMap", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PropertySetRequest.class, metaDataMap);
    }

    private static class PropertySetRequestTupleScheme
    extends TupleScheme<PropertySetRequest> {
        private PropertySetRequestTupleScheme() {
        }

        public void write(TProtocol prot, PropertySetRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.nameSpace);
            BitSet optionals = new BitSet();
            if (struct.isSetPropertyMap()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetPropertyMap()) {
                oprot.writeI32(struct.propertyMap.size());
                for (Map.Entry _iter1485 : struct.propertyMap.entrySet()) {
                    oprot.writeString((String)_iter1485.getKey());
                    oprot.writeString((String)_iter1485.getValue());
                }
            }
        }

        public void read(TProtocol prot, PropertySetRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.nameSpace = iprot.readString();
            struct.setNameSpaceIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                TMap _map1486 = iprot.readMapBegin((byte)11, (byte)11);
                struct.propertyMap = new HashMap(2 * _map1486.size);
                for (int _i1489 = 0; _i1489 < _map1486.size; ++_i1489) {
                    String _key1487 = iprot.readString();
                    String _val1488 = iprot.readString();
                    struct.propertyMap.put(_key1487, _val1488);
                }
                struct.setPropertyMapIsSet(true);
            }
        }
    }

    private static class PropertySetRequestTupleSchemeFactory
    implements SchemeFactory {
        private PropertySetRequestTupleSchemeFactory() {
        }

        public PropertySetRequestTupleScheme getScheme() {
            return new PropertySetRequestTupleScheme();
        }
    }

    private static class PropertySetRequestStandardScheme
    extends StandardScheme<PropertySetRequest> {
        private PropertySetRequestStandardScheme() {
        }

        public void read(TProtocol iprot, PropertySetRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.nameSpace = iprot.readString();
                            struct.setNameSpaceIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 13) {
                            TMap _map1480 = iprot.readMapBegin();
                            struct.propertyMap = new HashMap(2 * _map1480.size);
                            for (int _i1483 = 0; _i1483 < _map1480.size; ++_i1483) {
                                String _key1481 = iprot.readString();
                                String _val1482 = iprot.readString();
                                struct.propertyMap.put(_key1481, _val1482);
                            }
                            iprot.readMapEnd();
                            struct.setPropertyMapIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, PropertySetRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.nameSpace != null) {
                oprot.writeFieldBegin(NAME_SPACE_FIELD_DESC);
                oprot.writeString(struct.nameSpace);
                oprot.writeFieldEnd();
            }
            if (struct.propertyMap != null) {
                oprot.writeFieldBegin(PROPERTY_MAP_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.propertyMap.size()));
                for (Map.Entry _iter1484 : struct.propertyMap.entrySet()) {
                    oprot.writeString((String)_iter1484.getKey());
                    oprot.writeString((String)_iter1484.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PropertySetRequestStandardSchemeFactory
    implements SchemeFactory {
        private PropertySetRequestStandardSchemeFactory() {
        }

        public PropertySetRequestStandardScheme getScheme() {
            return new PropertySetRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME_SPACE(1, "nameSpace"),
        PROPERTY_MAP(2, "propertyMap");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME_SPACE;
                }
                case 2: {
                    return PROPERTY_MAP;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

