/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AddPartitionsRequest
implements TBase<AddPartitionsRequest, _Fields>,
Serializable,
Cloneable,
Comparable<AddPartitionsRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("AddPartitionsRequest");
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 1);
    private static final TField TBL_NAME_FIELD_DESC = new TField("tblName", 11, 2);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 15, 3);
    private static final TField IF_NOT_EXISTS_FIELD_DESC = new TField("ifNotExists", 2, 4);
    private static final TField NEED_RESULT_FIELD_DESC = new TField("needResult", 2, 5);
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 6);
    private static final TField VALID_WRITE_ID_LIST_FIELD_DESC = new TField("validWriteIdList", 11, 7);
    private static final TField SKIP_COLUMN_SCHEMA_FOR_PARTITION_FIELD_DESC = new TField("skipColumnSchemaForPartition", 2, 8);
    private static final TField PARTITION_COL_SCHEMA_FIELD_DESC = new TField("partitionColSchema", 15, 9);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new AddPartitionsRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new AddPartitionsRequestTupleSchemeFactory();
    @Nullable
    private String dbName;
    @Nullable
    private String tblName;
    @Nullable
    private List<Partition> parts;
    private boolean ifNotExists;
    private boolean needResult;
    @Nullable
    private String catName;
    @Nullable
    private String validWriteIdList;
    private boolean skipColumnSchemaForPartition;
    @Nullable
    private List<FieldSchema> partitionColSchema;
    private static final int __IFNOTEXISTS_ISSET_ID = 0;
    private static final int __NEEDRESULT_ISSET_ID = 1;
    private static final int __SKIPCOLUMNSCHEMAFORPARTITION_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.NEED_RESULT, _Fields.CAT_NAME, _Fields.VALID_WRITE_ID_LIST, _Fields.SKIP_COLUMN_SCHEMA_FOR_PARTITION, _Fields.PARTITION_COL_SCHEMA};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public AddPartitionsRequest() {
        this.needResult = true;
    }

    public AddPartitionsRequest(String dbName, String tblName, List<Partition> parts, boolean ifNotExists) {
        this();
        this.dbName = dbName;
        this.tblName = tblName;
        this.parts = parts;
        this.ifNotExists = ifNotExists;
        this.setIfNotExistsIsSet(true);
    }

    public AddPartitionsRequest(AddPartitionsRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTblName()) {
            this.tblName = other.tblName;
        }
        if (other.isSetParts()) {
            ArrayList<Partition> __this__parts = new ArrayList<Partition>(other.parts.size());
            for (Partition partition : other.parts) {
                __this__parts.add(new Partition(partition));
            }
            this.parts = __this__parts;
        }
        this.ifNotExists = other.ifNotExists;
        this.needResult = other.needResult;
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
        if (other.isSetValidWriteIdList()) {
            this.validWriteIdList = other.validWriteIdList;
        }
        this.skipColumnSchemaForPartition = other.skipColumnSchemaForPartition;
        if (other.isSetPartitionColSchema()) {
            ArrayList<FieldSchema> __this__partitionColSchema = new ArrayList<FieldSchema>(other.partitionColSchema.size());
            for (FieldSchema fieldSchema : other.partitionColSchema) {
                __this__partitionColSchema.add(new FieldSchema(fieldSchema));
            }
            this.partitionColSchema = __this__partitionColSchema;
        }
    }

    public AddPartitionsRequest deepCopy() {
        return new AddPartitionsRequest(this);
    }

    public void clear() {
        this.dbName = null;
        this.tblName = null;
        this.parts = null;
        this.setIfNotExistsIsSet(false);
        this.ifNotExists = false;
        this.needResult = true;
        this.catName = null;
        this.validWriteIdList = null;
        this.setSkipColumnSchemaForPartitionIsSet(false);
        this.skipColumnSchemaForPartition = false;
        this.partitionColSchema = null;
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(@Nullable String tblName) {
        this.tblName = tblName;
    }

    public void unsetTblName() {
        this.tblName = null;
    }

    public boolean isSetTblName() {
        return this.tblName != null;
    }

    public void setTblNameIsSet(boolean value) {
        if (!value) {
            this.tblName = null;
        }
    }

    public int getPartsSize() {
        return this.parts == null ? 0 : this.parts.size();
    }

    @Nullable
    public Iterator<Partition> getPartsIterator() {
        return this.parts == null ? null : this.parts.iterator();
    }

    public void addToParts(Partition elem) {
        if (this.parts == null) {
            this.parts = new ArrayList<Partition>();
        }
        this.parts.add(elem);
    }

    @Nullable
    public List<Partition> getParts() {
        return this.parts;
    }

    public void setParts(@Nullable List<Partition> parts) {
        this.parts = parts;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean value) {
        if (!value) {
            this.parts = null;
        }
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        this.setIfNotExistsIsSet(true);
    }

    public void unsetIfNotExists() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetIfNotExists() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIfNotExistsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public boolean isNeedResult() {
        return this.needResult;
    }

    public void setNeedResult(boolean needResult) {
        this.needResult = needResult;
        this.setNeedResultIsSet(true);
    }

    public void unsetNeedResult() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetNeedResult() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setNeedResultIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    @Nullable
    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public void setValidWriteIdList(@Nullable String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
    }

    public void unsetValidWriteIdList() {
        this.validWriteIdList = null;
    }

    public boolean isSetValidWriteIdList() {
        return this.validWriteIdList != null;
    }

    public void setValidWriteIdListIsSet(boolean value) {
        if (!value) {
            this.validWriteIdList = null;
        }
    }

    public boolean isSkipColumnSchemaForPartition() {
        return this.skipColumnSchemaForPartition;
    }

    public void setSkipColumnSchemaForPartition(boolean skipColumnSchemaForPartition) {
        this.skipColumnSchemaForPartition = skipColumnSchemaForPartition;
        this.setSkipColumnSchemaForPartitionIsSet(true);
    }

    public void unsetSkipColumnSchemaForPartition() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetSkipColumnSchemaForPartition() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setSkipColumnSchemaForPartitionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getPartitionColSchemaSize() {
        return this.partitionColSchema == null ? 0 : this.partitionColSchema.size();
    }

    @Nullable
    public Iterator<FieldSchema> getPartitionColSchemaIterator() {
        return this.partitionColSchema == null ? null : this.partitionColSchema.iterator();
    }

    public void addToPartitionColSchema(FieldSchema elem) {
        if (this.partitionColSchema == null) {
            this.partitionColSchema = new ArrayList<FieldSchema>();
        }
        this.partitionColSchema.add(elem);
    }

    @Nullable
    public List<FieldSchema> getPartitionColSchema() {
        return this.partitionColSchema;
    }

    public void setPartitionColSchema(@Nullable List<FieldSchema> partitionColSchema) {
        this.partitionColSchema = partitionColSchema;
    }

    public void unsetPartitionColSchema() {
        this.partitionColSchema = null;
    }

    public boolean isSetPartitionColSchema() {
        return this.partitionColSchema != null;
    }

    public void setPartitionColSchemaIsSet(boolean value) {
        if (!value) {
            this.partitionColSchema = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TBL_NAME: {
                if (value == null) {
                    this.unsetTblName();
                    break;
                }
                this.setTblName((String)value);
                break;
            }
            case PARTS: {
                if (value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((List)value);
                break;
            }
            case IF_NOT_EXISTS: {
                if (value == null) {
                    this.unsetIfNotExists();
                    break;
                }
                this.setIfNotExists((Boolean)value);
                break;
            }
            case NEED_RESULT: {
                if (value == null) {
                    this.unsetNeedResult();
                    break;
                }
                this.setNeedResult((Boolean)value);
                break;
            }
            case CAT_NAME: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case VALID_WRITE_ID_LIST: {
                if (value == null) {
                    this.unsetValidWriteIdList();
                    break;
                }
                this.setValidWriteIdList((String)value);
                break;
            }
            case SKIP_COLUMN_SCHEMA_FOR_PARTITION: {
                if (value == null) {
                    this.unsetSkipColumnSchemaForPartition();
                    break;
                }
                this.setSkipColumnSchemaForPartition((Boolean)value);
                break;
            }
            case PARTITION_COL_SCHEMA: {
                if (value == null) {
                    this.unsetPartitionColSchema();
                    break;
                }
                this.setPartitionColSchema((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DB_NAME: {
                return this.getDbName();
            }
            case TBL_NAME: {
                return this.getTblName();
            }
            case PARTS: {
                return this.getParts();
            }
            case IF_NOT_EXISTS: {
                return this.isIfNotExists();
            }
            case NEED_RESULT: {
                return this.isNeedResult();
            }
            case CAT_NAME: {
                return this.getCatName();
            }
            case VALID_WRITE_ID_LIST: {
                return this.getValidWriteIdList();
            }
            case SKIP_COLUMN_SCHEMA_FOR_PARTITION: {
                return this.isSkipColumnSchemaForPartition();
            }
            case PARTITION_COL_SCHEMA: {
                return this.getPartitionColSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TBL_NAME: {
                return this.isSetTblName();
            }
            case PARTS: {
                return this.isSetParts();
            }
            case IF_NOT_EXISTS: {
                return this.isSetIfNotExists();
            }
            case NEED_RESULT: {
                return this.isSetNeedResult();
            }
            case CAT_NAME: {
                return this.isSetCatName();
            }
            case VALID_WRITE_ID_LIST: {
                return this.isSetValidWriteIdList();
            }
            case SKIP_COLUMN_SCHEMA_FOR_PARTITION: {
                return this.isSetSkipColumnSchemaForPartition();
            }
            case PARTITION_COL_SCHEMA: {
                return this.isSetPartitionColSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof AddPartitionsRequest) {
            return this.equals((AddPartitionsRequest)that);
        }
        return false;
    }

    public boolean equals(AddPartitionsRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tblName = this.isSetTblName();
        boolean that_present_tblName = that.isSetTblName();
        if (this_present_tblName || that_present_tblName) {
            if (!this_present_tblName || !that_present_tblName) {
                return false;
            }
            if (!this.tblName.equals(that.tblName)) {
                return false;
            }
        }
        boolean this_present_parts = this.isSetParts();
        boolean that_present_parts = that.isSetParts();
        if (this_present_parts || that_present_parts) {
            if (!this_present_parts || !that_present_parts) {
                return false;
            }
            if (!this.parts.equals(that.parts)) {
                return false;
            }
        }
        boolean this_present_ifNotExists = true;
        boolean that_present_ifNotExists = true;
        if (this_present_ifNotExists || that_present_ifNotExists) {
            if (!this_present_ifNotExists || !that_present_ifNotExists) {
                return false;
            }
            if (this.ifNotExists != that.ifNotExists) {
                return false;
            }
        }
        boolean this_present_needResult = this.isSetNeedResult();
        boolean that_present_needResult = that.isSetNeedResult();
        if (this_present_needResult || that_present_needResult) {
            if (!this_present_needResult || !that_present_needResult) {
                return false;
            }
            if (this.needResult != that.needResult) {
                return false;
            }
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_validWriteIdList = this.isSetValidWriteIdList();
        boolean that_present_validWriteIdList = that.isSetValidWriteIdList();
        if (this_present_validWriteIdList || that_present_validWriteIdList) {
            if (!this_present_validWriteIdList || !that_present_validWriteIdList) {
                return false;
            }
            if (!this.validWriteIdList.equals(that.validWriteIdList)) {
                return false;
            }
        }
        boolean this_present_skipColumnSchemaForPartition = this.isSetSkipColumnSchemaForPartition();
        boolean that_present_skipColumnSchemaForPartition = that.isSetSkipColumnSchemaForPartition();
        if (this_present_skipColumnSchemaForPartition || that_present_skipColumnSchemaForPartition) {
            if (!this_present_skipColumnSchemaForPartition || !that_present_skipColumnSchemaForPartition) {
                return false;
            }
            if (this.skipColumnSchemaForPartition != that.skipColumnSchemaForPartition) {
                return false;
            }
        }
        boolean this_present_partitionColSchema = this.isSetPartitionColSchema();
        boolean that_present_partitionColSchema = that.isSetPartitionColSchema();
        if (this_present_partitionColSchema || that_present_partitionColSchema) {
            if (!this_present_partitionColSchema || !that_present_partitionColSchema) {
                return false;
            }
            if (!this.partitionColSchema.equals(that.partitionColSchema)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTblName() ? 131071 : 524287);
        if (this.isSetTblName()) {
            hashCode = hashCode * 8191 + this.tblName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParts() ? 131071 : 524287);
        if (this.isSetParts()) {
            hashCode = hashCode * 8191 + this.parts.hashCode();
        }
        hashCode = hashCode * 8191 + (this.ifNotExists ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetNeedResult() ? 131071 : 524287);
        if (this.isSetNeedResult()) {
            hashCode = hashCode * 8191 + (this.needResult ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetValidWriteIdList() ? 131071 : 524287);
        if (this.isSetValidWriteIdList()) {
            hashCode = hashCode * 8191 + this.validWriteIdList.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSkipColumnSchemaForPartition() ? 131071 : 524287);
        if (this.isSetSkipColumnSchemaForPartition()) {
            hashCode = hashCode * 8191 + (this.skipColumnSchemaForPartition ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionColSchema() ? 131071 : 524287);
        if (this.isSetPartitionColSchema()) {
            hashCode = hashCode * 8191 + this.partitionColSchema.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(AddPartitionsRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTblName(), other.isSetTblName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTblName() && (lastComparison = TBaseHelper.compareTo((String)this.tblName, (String)other.tblName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParts(), other.isSetParts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParts() && (lastComparison = TBaseHelper.compareTo(this.parts, other.parts)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIfNotExists(), other.isSetIfNotExists());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIfNotExists() && (lastComparison = TBaseHelper.compareTo((boolean)this.ifNotExists, (boolean)other.ifNotExists)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNeedResult(), other.isSetNeedResult());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNeedResult() && (lastComparison = TBaseHelper.compareTo((boolean)this.needResult, (boolean)other.needResult)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo((String)this.catName, (String)other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetValidWriteIdList(), other.isSetValidWriteIdList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValidWriteIdList() && (lastComparison = TBaseHelper.compareTo((String)this.validWriteIdList, (String)other.validWriteIdList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSkipColumnSchemaForPartition(), other.isSetSkipColumnSchemaForPartition());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSkipColumnSchemaForPartition() && (lastComparison = TBaseHelper.compareTo((boolean)this.skipColumnSchemaForPartition, (boolean)other.skipColumnSchemaForPartition)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionColSchema(), other.isSetPartitionColSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionColSchema() && (lastComparison = TBaseHelper.compareTo(this.partitionColSchema, other.partitionColSchema)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        AddPartitionsRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        AddPartitionsRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AddPartitionsRequest(");
        boolean first = true;
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tblName:");
        if (this.tblName == null) {
            sb.append("null");
        } else {
            sb.append(this.tblName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parts:");
        if (this.parts == null) {
            sb.append("null");
        } else {
            sb.append(this.parts);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ifNotExists:");
        sb.append(this.ifNotExists);
        first = false;
        if (this.isSetNeedResult()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("needResult:");
            sb.append(this.needResult);
            first = false;
        }
        if (this.isSetCatName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (this.isSetValidWriteIdList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("validWriteIdList:");
            if (this.validWriteIdList == null) {
                sb.append("null");
            } else {
                sb.append(this.validWriteIdList);
            }
            first = false;
        }
        if (this.isSetSkipColumnSchemaForPartition()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("skipColumnSchemaForPartition:");
            sb.append(this.skipColumnSchemaForPartition);
            first = false;
        }
        if (this.isSetPartitionColSchema()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partitionColSchema:");
            if (this.partitionColSchema == null) {
                sb.append("null");
            } else {
                sb.append(this.partitionColSchema);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbName()) {
            throw new TProtocolException("Required field 'dbName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTblName()) {
            throw new TProtocolException("Required field 'tblName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetParts()) {
            throw new TProtocolException("Required field 'parts' is unset! Struct:" + this.toString());
        }
        if (!this.isSetIfNotExists()) {
            throw new TProtocolException("Required field 'ifNotExists' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL_NAME, new FieldMetaData("tblName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARTS, new FieldMetaData("parts", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Partition.class))));
        tmpMap.put(_Fields.IF_NOT_EXISTS, new FieldMetaData("ifNotExists", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.NEED_RESULT, new FieldMetaData("needResult", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VALID_WRITE_ID_LIST, new FieldMetaData("validWriteIdList", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SKIP_COLUMN_SCHEMA_FOR_PARTITION, new FieldMetaData("skipColumnSchemaForPartition", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.PARTITION_COL_SCHEMA, new FieldMetaData("partitionColSchema", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(AddPartitionsRequest.class, metaDataMap);
    }

    private static class AddPartitionsRequestTupleScheme
    extends TupleScheme<AddPartitionsRequest> {
        private AddPartitionsRequestTupleScheme() {
        }

        public void write(TProtocol prot, AddPartitionsRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbName);
            oprot.writeString(struct.tblName);
            oprot.writeI32(struct.parts.size());
            for (Partition _iter612 : struct.parts) {
                _iter612.write((TProtocol)oprot);
            }
            oprot.writeBool(struct.ifNotExists);
            BitSet optionals = new BitSet();
            if (struct.isSetNeedResult()) {
                optionals.set(0);
            }
            if (struct.isSetCatName()) {
                optionals.set(1);
            }
            if (struct.isSetValidWriteIdList()) {
                optionals.set(2);
            }
            if (struct.isSetSkipColumnSchemaForPartition()) {
                optionals.set(3);
            }
            if (struct.isSetPartitionColSchema()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetNeedResult()) {
                oprot.writeBool(struct.needResult);
            }
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetValidWriteIdList()) {
                oprot.writeString(struct.validWriteIdList);
            }
            if (struct.isSetSkipColumnSchemaForPartition()) {
                oprot.writeBool(struct.skipColumnSchemaForPartition);
            }
            if (struct.isSetPartitionColSchema()) {
                oprot.writeI32(struct.partitionColSchema.size());
                for (FieldSchema _iter613 : struct.partitionColSchema) {
                    _iter613.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, AddPartitionsRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbName = iprot.readString();
            struct.setDbNameIsSet(true);
            struct.tblName = iprot.readString();
            struct.setTblNameIsSet(true);
            TList _list614 = iprot.readListBegin((byte)12);
            struct.parts = new ArrayList(_list614.size);
            for (int _i616 = 0; _i616 < _list614.size; ++_i616) {
                Partition _elem615 = new Partition();
                _elem615.read((TProtocol)iprot);
                struct.parts.add(_elem615);
            }
            struct.setPartsIsSet(true);
            struct.ifNotExists = iprot.readBool();
            struct.setIfNotExistsIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.needResult = iprot.readBool();
                struct.setNeedResultIsSet(true);
            }
            if (incoming.get(1)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.validWriteIdList = iprot.readString();
                struct.setValidWriteIdListIsSet(true);
            }
            if (incoming.get(3)) {
                struct.skipColumnSchemaForPartition = iprot.readBool();
                struct.setSkipColumnSchemaForPartitionIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list617 = iprot.readListBegin((byte)12);
                struct.partitionColSchema = new ArrayList(_list617.size);
                for (int _i619 = 0; _i619 < _list617.size; ++_i619) {
                    FieldSchema _elem618 = new FieldSchema();
                    _elem618.read((TProtocol)iprot);
                    struct.partitionColSchema.add(_elem618);
                }
                struct.setPartitionColSchemaIsSet(true);
            }
        }
    }

    private static class AddPartitionsRequestTupleSchemeFactory
    implements SchemeFactory {
        private AddPartitionsRequestTupleSchemeFactory() {
        }

        public AddPartitionsRequestTupleScheme getScheme() {
            return new AddPartitionsRequestTupleScheme();
        }
    }

    private static class AddPartitionsRequestStandardScheme
    extends StandardScheme<AddPartitionsRequest> {
        private AddPartitionsRequestStandardScheme() {
        }

        public void read(TProtocol iprot, AddPartitionsRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tblName = iprot.readString();
                            struct.setTblNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list604 = iprot.readListBegin();
                            struct.parts = new ArrayList(_list604.size);
                            for (int _i606 = 0; _i606 < _list604.size; ++_i606) {
                                Partition _elem605 = new Partition();
                                _elem605.read(iprot);
                                struct.parts.add(_elem605);
                            }
                            iprot.readListEnd();
                            struct.setPartsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 2) {
                            struct.ifNotExists = iprot.readBool();
                            struct.setIfNotExistsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.needResult = iprot.readBool();
                            struct.setNeedResultIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.validWriteIdList = iprot.readString();
                            struct.setValidWriteIdListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 2) {
                            struct.skipColumnSchemaForPartition = iprot.readBool();
                            struct.setSkipColumnSchemaForPartitionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list607 = iprot.readListBegin();
                            struct.partitionColSchema = new ArrayList(_list607.size);
                            for (int _i609 = 0; _i609 < _list607.size; ++_i609) {
                                FieldSchema _elem608 = new FieldSchema();
                                _elem608.read(iprot);
                                struct.partitionColSchema.add(_elem608);
                            }
                            iprot.readListEnd();
                            struct.setPartitionColSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, AddPartitionsRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tblName != null) {
                oprot.writeFieldBegin(TBL_NAME_FIELD_DESC);
                oprot.writeString(struct.tblName);
                oprot.writeFieldEnd();
            }
            if (struct.parts != null) {
                oprot.writeFieldBegin(PARTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.parts.size()));
                for (Partition _iter610 : struct.parts) {
                    _iter610.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(IF_NOT_EXISTS_FIELD_DESC);
            oprot.writeBool(struct.ifNotExists);
            oprot.writeFieldEnd();
            if (struct.isSetNeedResult()) {
                oprot.writeFieldBegin(NEED_RESULT_FIELD_DESC);
                oprot.writeBool(struct.needResult);
                oprot.writeFieldEnd();
            }
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.validWriteIdList != null && struct.isSetValidWriteIdList()) {
                oprot.writeFieldBegin(VALID_WRITE_ID_LIST_FIELD_DESC);
                oprot.writeString(struct.validWriteIdList);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSkipColumnSchemaForPartition()) {
                oprot.writeFieldBegin(SKIP_COLUMN_SCHEMA_FOR_PARTITION_FIELD_DESC);
                oprot.writeBool(struct.skipColumnSchemaForPartition);
                oprot.writeFieldEnd();
            }
            if (struct.partitionColSchema != null && struct.isSetPartitionColSchema()) {
                oprot.writeFieldBegin(PARTITION_COL_SCHEMA_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitionColSchema.size()));
                for (FieldSchema _iter611 : struct.partitionColSchema) {
                    _iter611.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class AddPartitionsRequestStandardSchemeFactory
    implements SchemeFactory {
        private AddPartitionsRequestStandardSchemeFactory() {
        }

        public AddPartitionsRequestStandardScheme getScheme() {
            return new AddPartitionsRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DB_NAME(1, "dbName"),
        TBL_NAME(2, "tblName"),
        PARTS(3, "parts"),
        IF_NOT_EXISTS(4, "ifNotExists"),
        NEED_RESULT(5, "needResult"),
        CAT_NAME(6, "catName"),
        VALID_WRITE_ID_LIST(7, "validWriteIdList"),
        SKIP_COLUMN_SCHEMA_FOR_PARTITION(8, "skipColumnSchemaForPartition"),
        PARTITION_COL_SCHEMA(9, "partitionColSchema");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DB_NAME;
                }
                case 2: {
                    return TBL_NAME;
                }
                case 3: {
                    return PARTS;
                }
                case 4: {
                    return IF_NOT_EXISTS;
                }
                case 5: {
                    return NEED_RESULT;
                }
                case 6: {
                    return CAT_NAME;
                }
                case 7: {
                    return VALID_WRITE_ID_LIST;
                }
                case 8: {
                    return SKIP_COLUMN_SCHEMA_FOR_PARTITION;
                }
                case 9: {
                    return PARTITION_COL_SCHEMA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

