/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.HiveStrictManagedUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionalValidationListener
extends MetaStorePreEventListener {
    public static final Logger LOG = LoggerFactory.getLogger(TransactionalValidationListener.class);
    public static final String DEFAULT_TRANSACTIONAL_PROPERTY = "default";
    public static final String INSERTONLY_TRANSACTIONAL_PROPERTY = "insert_only";
    private final Set<String> supportedCatalogs = new HashSet<String>();
    private final Pattern ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
    private static final Pattern ORIGINAL_PATTERN_COPY = Pattern.compile("[0-9]+_[0-9]+_copy_[0-9]+");

    TransactionalValidationListener(Configuration conf) {
        super(conf);
        this.supportedCatalogs.add("hive");
    }

    @Override
    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.handle((PreCreateTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.handle((PreAlterTableEvent)context);
                break;
            }
        }
    }

    private void handle(PreAlterTableEvent context) throws MetaException {
        if (this.supportedCatalogs.contains(this.getTableCatalog(context.getNewTable()))) {
            this.handleAlterTableTransactionalProp(context);
            HiveStrictManagedUtils.validateStrictManagedTableWithThrow(this.getConf(), context.getNewTable());
        }
    }

    private void handle(PreCreateTableEvent context) throws MetaException {
        if (this.supportedCatalogs.contains(this.getTableCatalog(context.getTable()))) {
            this.handleCreateTableTransactionalProp(context);
            HiveStrictManagedUtils.validateStrictManagedTableWithThrow(this.getConf(), context.getTable());
        }
    }

    private String getTableCatalog(Table table) {
        String catName = table.isSetCatName() ? table.getCatName() : MetaStoreUtils.getDefaultCatalog(this.getConf());
        return catName.toLowerCase();
    }

    private void handleAlterTableTransactionalProp(PreAlterTableEvent context) throws MetaException {
        Table newTable = context.getNewTable();
        Map<String, String> parameters = newTable.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        HashSet<String> keys = new HashSet<String>(parameters.keySet());
        String transactionalValue = null;
        boolean transactionalValuePresent = false;
        boolean isTransactionalPropertiesPresent = false;
        String transactionalPropertiesValue = null;
        boolean hasValidTransactionalValue = false;
        for (String key : keys) {
            if ("transactional".equalsIgnoreCase(key)) {
                transactionalValuePresent = true;
                transactionalValue = parameters.get(key);
                parameters.remove(key);
            }
            if (!"transactional_properties".equalsIgnoreCase(key)) continue;
            isTransactionalPropertiesPresent = true;
            transactionalPropertiesValue = parameters.get(key);
        }
        Table oldTable = context.getOldTable();
        String oldTransactionalValue = null;
        String oldTransactionalPropertiesValue = null;
        for (String key : oldTable.getParameters().keySet()) {
            if ("transactional".equalsIgnoreCase(key)) {
                oldTransactionalValue = oldTable.getParameters().get(key);
            }
            if (!"transactional_properties".equalsIgnoreCase(key)) continue;
            oldTransactionalPropertiesValue = oldTable.getParameters().get(key);
        }
        if (transactionalValuePresent && "false".equalsIgnoreCase(transactionalValue)) {
            transactionalValuePresent = false;
            transactionalValue = null;
        }
        if (transactionalValuePresent) {
            if (oldTable.getTableType().equals(TableType.MANAGED_TABLE.toString()) && newTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                throw new MetaException(Warehouse.getQualifiedName(newTable) + " cannot be converted to external table as it is transactional table.");
            }
            parameters.put("transactional", transactionalValue);
        }
        if ("true".equalsIgnoreCase(transactionalValue) && !"true".equalsIgnoreCase(oldTransactionalValue)) {
            boolean isFullAcid;
            if (!isTransactionalPropertiesPresent) {
                this.normalizeTransactionalPropertyDefault(newTable);
                isTransactionalPropertiesPresent = true;
                transactionalPropertiesValue = DEFAULT_TRANSACTIONAL_PROPERTY;
            }
            boolean bl = isFullAcid = transactionalPropertiesValue == null || !INSERTONLY_TRANSACTIONAL_PROPERTY.equalsIgnoreCase(transactionalPropertiesValue);
            if (isFullAcid && !TransactionalValidationListener.conformToAcid(newTable)) {
                throw new MetaException("The table must be stored using an ACID compliant format (such as ORC): " + Warehouse.getQualifiedName(newTable));
            }
            if (newTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                throw new MetaException(Warehouse.getQualifiedName(newTable) + " cannot be declared transactional because it's an external table");
            }
            if (isFullAcid) {
                this.validateTableStructure(context.getHandler(), newTable);
            }
            hasValidTransactionalValue = true;
        }
        if (oldTransactionalValue == null ? transactionalValue == null : oldTransactionalValue.equalsIgnoreCase(transactionalValue)) {
            hasValidTransactionalValue = true;
        }
        if (!hasValidTransactionalValue && !MetaStoreUtils.isInsertOnlyTableParam(oldTable.getParameters())) {
            throw new MetaException("TBLPROPERTIES with 'transactional'='true' cannot be unset: " + Warehouse.getQualifiedName(newTable));
        }
        if (isTransactionalPropertiesPresent) {
            if (oldTransactionalValue == null) {
                this.initializeTransactionalProperties(newTable);
            } else if (!(oldTransactionalPropertiesValue != null && oldTransactionalPropertiesValue.equalsIgnoreCase(transactionalPropertiesValue) || MetaStoreUtils.isInsertOnlyTableParam(oldTable.getParameters()))) {
                throw new MetaException("TBLPROPERTIES with 'transactional_properties' cannot be altered after the table is created");
            }
        }
        this.checkSorted(newTable);
        if (TxnUtils.isAcidTable(newTable) && !TxnUtils.isTransactionalTable(oldTable)) {
            TxnStore t = TxnUtils.getTxnStore(this.getConf());
            t.seedWriteId(new SeedTableWriteIdsRequest(newTable.getDbName(), newTable.getTableName(), 10000000L));
        }
    }

    private void checkSorted(Table newTable) throws MetaException {
        if (!TxnUtils.isAcidTable(newTable)) {
            return;
        }
        StorageDescriptor sd = newTable.getSd();
        if (sd.getSortCols() != null && sd.getSortCols().size() > 0) {
            throw new MetaException("Table " + Warehouse.getQualifiedName(newTable) + " cannot support full ACID functionality since it is sorted.");
        }
    }

    private void makeAcid(Table newTable) throws MetaException {
        boolean makeAcid;
        if (newTable.getParameters() != null && newTable.getParameters().containsKey("transactional")) {
            LOG.info("Could not make " + Warehouse.getQualifiedName(newTable) + " acid: already has " + "transactional" + "=" + newTable.getParameters().get("transactional"));
            return;
        }
        Configuration conf = this.getConf();
        boolean bl = makeAcid = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID) && MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY) && "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager".equals(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.HIVE_TXN_MANAGER));
        if (makeAcid) {
            if (!TransactionalValidationListener.conformToAcid(newTable)) {
                LOG.info("Could not make " + Warehouse.getQualifiedName(newTable) + " acid: wrong IO format");
                return;
            }
            if (!TableType.MANAGED_TABLE.toString().equalsIgnoreCase(newTable.getTableType())) {
                LOG.info("Could not make " + Warehouse.getQualifiedName(newTable) + " acid: it's " + newTable.getTableType());
                return;
            }
            if (newTable.getSd().getSortColsSize() > 0) {
                LOG.info("Could not make " + Warehouse.getQualifiedName(newTable) + " acid: it's sorted");
                return;
            }
            Map<String, String> parameters = newTable.getParameters();
            if (parameters == null || parameters.isEmpty()) {
                parameters = new HashMap<String, String>();
            }
            parameters.put("transactional", "true");
            newTable.setParameters(parameters);
            LOG.info("Automatically chose to make " + Warehouse.getQualifiedName(newTable) + " acid.");
        }
    }

    private void handleCreateTableTransactionalProp(PreCreateTableEvent context) throws MetaException {
        Table newTable = context.getTable();
        Map<String, String> parameters = newTable.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            this.makeAcid(newTable);
            return;
        }
        String transactional = null;
        String transactionalProperties = null;
        HashSet<String> keys = new HashSet<String>(parameters.keySet());
        for (String key : keys) {
            if ("transactional".equalsIgnoreCase(key)) {
                transactional = parameters.get(key);
                parameters.remove(key);
            }
            if (!"transactional_properties".equalsIgnoreCase(key)) continue;
            transactionalProperties = parameters.get(key);
        }
        if (transactional == null) {
            this.makeAcid(newTable);
            return;
        }
        if ("false".equalsIgnoreCase(transactional)) {
            LOG.info("'transactional'='false' is no longer a valid property and will be ignored: " + Warehouse.getQualifiedName(newTable));
            return;
        }
        if ("true".equalsIgnoreCase(transactional)) {
            if (!(TransactionalValidationListener.conformToAcid(newTable) || transactionalProperties != null && INSERTONLY_TRANSACTIONAL_PROPERTY.equalsIgnoreCase(transactionalProperties))) {
                throw new MetaException("The table must be stored using an ACID compliant format (such as ORC): " + Warehouse.getQualifiedName(newTable));
            }
            if (MetaStoreUtils.isExternalTable(newTable)) {
                throw new MetaException(Warehouse.getQualifiedName(newTable) + " cannot be declared transactional because it's an external table");
            }
            parameters.put("transactional", Boolean.TRUE.toString());
            if (transactionalProperties == null) {
                this.normalizeTransactionalPropertyDefault(newTable);
            }
            this.initializeTransactionalProperties(newTable);
            this.checkSorted(newTable);
            return;
        }
        throw new MetaException("'transactional' property of TBLPROPERTIES may only have value 'true': " + Warehouse.getQualifiedName(newTable));
    }

    private void normalizeTransactionalPropertyDefault(Table table) {
        table.getParameters().put("transactional_properties", DEFAULT_TRANSACTIONAL_PROPERTY);
    }

    public static boolean conformToAcid(Table table) throws MetaException {
        StorageDescriptor sd = table.getSd();
        try {
            Class<?> outputFormatClass;
            Class<?> inputFormatClass = sd.getInputFormat() == null ? null : Class.forName(sd.getInputFormat());
            Class<?> clazz = outputFormatClass = sd.getOutputFormat() == null ? null : Class.forName(sd.getOutputFormat());
            if (inputFormatClass == null || outputFormatClass == null || !Class.forName("org.apache.hadoop.hive.ql.io.AcidInputFormat").isAssignableFrom(inputFormatClass) || !Class.forName("org.apache.hadoop.hive.ql.io.AcidOutputFormat").isAssignableFrom(outputFormatClass)) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Could not verify InputFormat=" + sd.getInputFormat() + " or OutputFormat=" + sd.getOutputFormat() + "  for " + Warehouse.getQualifiedName(table));
            return false;
        }
        return true;
    }

    private void initializeTransactionalProperties(Table table) throws MetaException {
        String tableTransactionalProperties = null;
        Map<String, String> parameters = table.getParameters();
        if (parameters != null) {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                if (!"transactional_properties".equalsIgnoreCase(key)) continue;
                tableTransactionalProperties = parameters.get(key).toLowerCase();
                parameters.remove(key);
                String validationError = this.validateTransactionalProperties(tableTransactionalProperties);
                if (validationError == null) break;
                throw new MetaException("Invalid transactional properties specified for " + Warehouse.getQualifiedName(table) + " with the error " + validationError);
            }
        }
        if (tableTransactionalProperties != null) {
            parameters.put("transactional_properties", tableTransactionalProperties);
        }
    }

    private String validateTransactionalProperties(String transactionalProperties) {
        boolean isValid = false;
        switch (transactionalProperties) {
            case "default": 
            case "insert_only": {
                isValid = true;
                break;
            }
            default: {
                isValid = false;
            }
        }
        if (!isValid) {
            return "unknown value " + transactionalProperties + " for transactional_properties";
        }
        return null;
    }

    private void validateTableStructure(IHMSHandler hmsHandler, Table table) throws MetaException {
        Warehouse wh = hmsHandler.getWh();
        if (TransactionalValidationListener.isPartitionedTable(table)) {
            List<Partition> partitions = this.getTablePartitions(hmsHandler, table);
            for (Partition partition : partitions) {
                Path partPath = wh.getDnsPath(new Path(partition.getSd().getLocation()));
                this.validateTableStructureForPath(hmsHandler, wh, table, partPath);
            }
        } else {
            Path tablePath = this.getTablePath(hmsHandler, wh, table);
            this.validateTableStructureForPath(hmsHandler, wh, table, tablePath);
        }
    }

    private List<Partition> getTablePartitions(IHMSHandler hmsHandler, Table table) throws MetaException {
        try {
            RawStore rawStore = hmsHandler.getMS();
            String catName = this.getTableCatalog(table);
            List<Partition> partitions = rawStore.getPartitions(catName, table.getDbName(), table.getTableName(), -1);
            return partitions;
        }
        catch (Exception err) {
            String msg = "Error getting partitions for " + Warehouse.getQualifiedName(table);
            LOG.error(msg, (Throwable)err);
            MetaException e1 = new MetaException(msg);
            e1.initCause(err);
            throw e1;
        }
    }

    private Path getTablePath(IHMSHandler hmsHandler, Warehouse wh, Table table) throws MetaException {
        Path tablePath = null;
        try {
            if (table.getSd().getLocation() == null || table.getSd().getLocation().isEmpty()) {
                String catName = this.getTableCatalog(table);
                tablePath = wh.getDefaultTablePath(hmsHandler.getMS().getDatabase(catName, table.getDbName()), table);
            } else {
                tablePath = wh.getDnsPath(new Path(table.getSd().getLocation()));
            }
        }
        catch (Exception err) {
            MetaException e1 = new MetaException("Error getting table path for " + Warehouse.getQualifiedName(table));
            e1.initCause(err);
        }
        return tablePath;
    }

    private static boolean isPartitionedTable(Table tableObj) {
        List<FieldSchema> partKeys = tableObj.getPartitionKeys();
        return partKeys != null && partKeys.size() > 0;
    }

    private void validateTableStructureForPath(IHMSHandler hmsHandler, Warehouse wh, Table table, Path tablePath) throws MetaException {
        try {
            FileSystem fs = wh.getFs(tablePath);
            FileUtils.RemoteIteratorWithFilter iterator = new FileUtils.RemoteIteratorWithFilter((RemoteIterator<LocatedFileStatus>)fs.listFiles(tablePath, true), FileUtils.RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER);
            while (iterator.hasNext()) {
                boolean validFile;
                LocatedFileStatus fileStatus = iterator.next();
                if (!fileStatus.isFile() || (validFile = this.ORIGINAL_PATTERN.matcher(fileStatus.getPath().getName()).matches() || ORIGINAL_PATTERN_COPY.matcher(fileStatus.getPath().getName()).matches())) continue;
                throw new IllegalStateException("Unexpected data file name format.  Cannot convert " + Warehouse.getQualifiedName(table) + " to transactional table.  File: " + fileStatus.getPath());
            }
        }
        catch (IOException e) {
            String msg = "Unable to list files for " + Warehouse.getQualifiedName(table);
            LOG.error(msg, (Throwable)e);
            MetaException e1 = new MetaException(msg);
            e1.initCause(e);
            throw e1;
        }
    }
}

