/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ServletSecurity;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.PropertyException;
import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyServlet
extends HttpServlet {
    private static final String PTYERROR = "Property-maps servlet error ";
    public static final Logger LOGGER = LoggerFactory.getLogger(PropertyServlet.class);
    private final Configuration configuration;
    private final ServletSecurity security;

    PropertyServlet(Configuration configuration) {
        String auth = MetastoreConf.getVar(configuration, MetastoreConf.ConfVars.PROPERTIES_SERVLET_AUTH);
        boolean jwt = auth != null && "jwt".equals(auth.toLowerCase());
        this.security = new ServletSecurity(configuration, jwt);
        this.configuration = configuration;
    }

    private String strError(String msg, Object ... args) {
        return String.format(PTYERROR + msg, args);
    }

    private void sendError(HttpServletResponse response, Exception any, String msg) {
        int code = 500;
        if (any instanceof PropertyException || any instanceof NoSuchObjectException) {
            code = 400;
        }
        this.sendError(response, code, msg);
    }

    private void sendError(HttpServletResponse response, int code, String msg) {
        try {
            response.sendError(code, msg);
        }
        catch (IOException ioeXception) {
            LOGGER.error(this.strError("sending error", new Object[0]), (Throwable)ioeXception);
            response.setStatus(code);
        }
    }

    private String getNamespace(String ruri) {
        int index = ruri.lastIndexOf("/");
        if (index > 1) {
            return ruri.substring(index + 1);
        }
        return "";
    }

    private RawStore getMS() throws ServletException {
        try {
            return HiveMetaStore.HMSHandler.newRawStoreForConf(this.configuration);
        }
        catch (MetaException exception) {
            throw new ServletException((Throwable)((Object)exception));
        }
    }

    private PropertyManager getPropertyManager(RawStore store, String ns) throws ServletException {
        try {
            PropertyStore propertyStore = store.getPropertyStore();
            return PropertyManager.create(ns, propertyStore);
        }
        catch (MetaException | NoSuchObjectException exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readJson(HttpServletRequest request) throws ServletException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));){
            Object object = new Gson().fromJson((Reader)reader, Object.class);
            return object;
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            throw new ServletException(e);
        }
    }

    private void writeJson(HttpServletResponse response, Object value) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        response.setStatus(200);
        PrintWriter writer = new PrintWriter((OutputStream)outputStream);
        writer.write(new Gson().toJson(value));
        writer.flush();
    }

    public void init() throws ServletException {
        super.init();
        this.security.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.security.execute(request, response, this::runPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        RawStore ms = this.getMS();
        String ns = this.getNamespace(request.getRequestURI());
        try {
            PropertyManager mgr = this.getPropertyManager(ms, ns);
            Object json = this.readJson(request);
            List<Object> actions = json instanceof List ? (List<Object>)json : Collections.singletonList(json);
            ArrayList<Object> reactions = new ArrayList<Object>();
            String method = null;
            try {
                block17: for (Object t : actions) {
                    if (!(t instanceof Map)) continue;
                    Map call = (Map)t;
                    method = (String)call.get("method");
                    if (method == null) {
                        method = "selectProperties";
                    }
                    switch (method) {
                        case "fetchProperties": {
                            Object jsonKeys = call.get("keys");
                            if (jsonKeys == null) {
                                throw new IllegalArgumentException("null keys");
                            }
                            List keys = jsonKeys instanceof List ? (List)jsonKeys : Collections.singletonList(jsonKeys);
                            TreeMap<String, String> properties = new TreeMap<String, String>();
                            for (Object okey : keys) {
                                String key = okey.toString();
                                String value = mgr.exportPropertyValue(key);
                                if (value == null) continue;
                                properties.put(key, value);
                            }
                            reactions.add(properties);
                            continue block17;
                        }
                        case "selectProperties": {
                            String prefix = (String)call.get("prefix");
                            if (prefix == null) {
                                throw new IllegalArgumentException("null prefix");
                            }
                            String predicate = (String)call.get("predicate");
                            Object selection = call.get("selection");
                            List<String> project = selection == null ? null : (selection instanceof List ? (List<String>)selection : Collections.singletonList(selection.toString()));
                            Map<String, PropertyMap> selected = mgr.selectProperties(prefix, predicate, project);
                            TreeMap returned = new TreeMap();
                            selected.forEach((k, v) -> returned.put(k, v.export(project == null)));
                            reactions.add(returned);
                            continue block17;
                        }
                        case "script": {
                            String src = (String)call.get("source");
                            reactions.add(mgr.runScript(src));
                            continue block17;
                        }
                        case "echo": {
                            reactions.add(t);
                            continue block17;
                        }
                    }
                    throw new IllegalArgumentException("bad argument type " + t.getClass());
                }
                mgr.commit();
                this.writeJson(response, reactions.size() > 1 ? reactions : reactions.get(0));
                response.setStatus(200);
            }
            catch (Exception any) {
                String string = this.strError("fetching values with %s, (%s) %s", method != null ? method : "?", any.getClass().getSimpleName(), any.getMessage());
                LOGGER.error(string, (Throwable)any);
                this.sendError(response, any, string);
                mgr.rollback();
            }
        }
        finally {
            ms.shutdown();
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.security.execute(request, response, this::runPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPut(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String ns = this.getNamespace(request.getRequestURI());
        RawStore ms = this.getMS();
        try {
            PropertyManager mgr = this.getPropertyManager(ms, ns);
            Object json = this.readJson(request);
            if (json instanceof Map) {
                try {
                    Map cast = (Map)json;
                    mgr.setProperties(cast);
                    mgr.commit();
                    response.setStatus(200);
                }
                catch (Exception any) {
                    String error = this.strError("setting values (%s) %s", any.getClass().getSimpleName(), any.getMessage());
                    LOGGER.error(error, (Throwable)any);
                    this.sendError(response, any, error);
                    mgr.rollback();
                }
            } else {
                String error = this.strError("setting values, bad argument type %s", json.getClass());
                LOGGER.error(error);
                this.sendError(response, 400, error);
            }
        }
        finally {
            ms.shutdown();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.security.execute(request, response, this::runGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String ns = this.getNamespace(request.getRequestURI());
        RawStore ms = this.getMS();
        try {
            PropertyManager mgr = this.getPropertyManager(ms, ns);
            try {
                String[] keys = request.getParameterValues("key");
                if (keys == null) {
                    throw new IllegalArgumentException("null key");
                }
                TreeMap<String, String> properties = new TreeMap<String, String>();
                for (String action : keys) {
                    String key = action.toString();
                    String value = mgr.exportPropertyValue(key);
                    if (value == null) continue;
                    properties.put(key, value);
                }
                mgr.commit();
                this.writeJson(response, properties);
                response.setStatus(200);
            }
            catch (Exception any) {
                mgr.rollback();
                String error = this.strError("getting values (%s) %s", any.getClass().getSimpleName(), any.getMessage());
                LOGGER.error(error, (Throwable)any);
                this.sendError(response, any, error);
            }
        }
        finally {
            ms.shutdown();
        }
    }

    public static Server startServer(Configuration conf) throws Exception {
        int port = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.PROPERTIES_SERVLET_PORT);
        if (port < 0) {
            return null;
        }
        String cli = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.PROPERTIES_SERVLET_PATH);
        Server server = new Server();
        server.setStopAtShutdown(true);
        SslContextFactory sslContextFactory = ServletSecurity.createSslContextFactory(conf);
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        connector.setPort(port);
        connector.setReuseAddress(true);
        server.addConnector((Connector)connector);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        ServletHolder holder = handler.newServletHolder(Source.EMBEDDED);
        holder.setServlet((Servlet)new PropertyServlet(conf));
        handler.addServletWithMapping(holder, "/" + cli + "/*");
        server.start();
        if (!server.isStarted()) {
            LOGGER.error("unable to start property-maps servlet server, path {}, port {}", (Object)cli, (Object)port);
        } else {
            LOGGER.info("started property-maps servlet server on {}", (Object)server.getURI());
        }
        return server;
    }
}

