/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.model.MMetastoreDBProperties;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;

public class JdoPropertyStore
extends PropertyStore {
    private final ObjectStore objectStore;

    public JdoPropertyStore(ObjectStore store) {
        this.objectStore = store;
    }

    @Override
    public PropertyMap fetchProperties(String mapKey, Function<String, PropertySchema> getSchema) {
        return this.objectStore.fetchProperties(mapKey, this.getPropertyMapFunction(null, getSchema));
    }

    @Override
    public Map<String, PropertyMap> selectProperties(String keyPrefix, Predicate<String> keyFilter, Function<String, PropertySchema> getSchema) {
        return this.objectStore.selectProperties(keyPrefix, this.getPropertyMapFunction(keyFilter, getSchema));
    }

    @Override
    public UUID fetchDigest(String mapKey) {
        return this.objectStore.fetchProperties(mapKey, (MMetastoreDBProperties mm) -> UUID.fromString(mm.getPropertyValue()));
    }

    @Override
    public Map<String, UUID> selectDigest(String keyPrefix, Predicate<String> keyFilter) {
        return this.objectStore.selectProperties(keyPrefix, mm -> {
            if (keyFilter == null || keyFilter.test(mm.getPropertykey())) {
                return UUID.fromString(mm.getPropertyValue());
            }
            return null;
        });
    }

    @Override
    public void saveProperties(Iterator<Map.Entry<String, PropertyMap>> save) {
        this.objectStore.runInTransaction(() -> super.saveProperties(save));
    }

    @Override
    protected void saveProperties(String mapKey, PropertyMap map) {
        if (map.isDropped()) {
            this.objectStore.dropProperties(mapKey);
        } else {
            this.objectStore.putProperties(mapKey, map.getDigest().toString(), null, this.serialize(map));
        }
    }

    @Override
    public boolean dropProperties(String mapKey) {
        return this.objectStore.dropProperties(mapKey);
    }

    @Override
    public boolean renameProperties(String mapKey, String newKey) {
        return this.objectStore.renameProperties(mapKey, newKey);
    }

    Function<MMetastoreDBProperties, PropertyMap> getPropertyMapFunction(Predicate<String> keyFilter, Function<String, PropertySchema> getSchema) {
        return mm -> {
            byte[] bytes;
            String key = mm.getPropertykey();
            if ((keyFilter == null || keyFilter.test(key)) && (bytes = mm.getPropertyContent()) != null) {
                PropertySchema schema = (PropertySchema)getSchema.apply(key);
                PropertyMap map = this.deserialize(bytes, s -> schema);
                if (map.isDirty()) {
                    this.saveProperties(key, map);
                }
                return map;
            }
            return null;
        };
    }
}

