/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartitionIterable;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreChecker {
    public static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreChecker.class);
    private final IMetaStoreClient msc;
    private final Configuration conf;
    private final long partitionExpirySeconds;
    private final Interner<Path> pathInterner = Interners.newStrongInterner();
    public static final PathFilter HIDDEN_FILES_PATH_FILTER = p -> !p.getName().startsWith("_") && !p.getName().startsWith(".");

    public HiveMetaStoreChecker(IMetaStoreClient msc, Configuration conf) {
        this(msc, conf, -1L);
    }

    public HiveMetaStoreChecker(IMetaStoreClient msc, Configuration conf, long partitionExpirySeconds) {
        this.msc = msc;
        this.conf = conf;
        this.partitionExpirySeconds = partitionExpirySeconds;
    }

    public IMetaStoreClient getMsc() {
        return this.msc;
    }

    public CheckResult checkMetastore(String catName, String dbName, String tableName, byte[] filterExp) throws MetastoreException, IOException {
        CheckResult result = new CheckResult();
        if (dbName == null || "".equalsIgnoreCase(dbName)) {
            dbName = "default";
        }
        try {
            if (tableName == null || "".equals(tableName)) {
                ArrayList<String> tables = new ArrayList();
                try {
                    tables = this.getMsc().getTables(catName, dbName, ".*");
                }
                catch (UnknownDBException unknownDBException) {
                    // empty catch block
                }
                for (String currentTableName : tables) {
                    this.checkTable(catName, dbName, currentTableName, null, result);
                }
                this.findUnknownTables(catName, dbName, tables, result);
            } else if (filterExp != null) {
                this.checkTable(catName, dbName, tableName, filterExp, result);
            } else {
                this.checkTable(catName, dbName, tableName, null, result);
            }
            LOG.info("Number of partitionsNotInMs=" + result.getPartitionsNotInMs() + ", partitionsNotOnFs=" + result.getPartitionsNotOnFs() + ", tablesNotInMs=" + result.getTablesNotInMs() + ", tablesNotOnFs=" + result.getTablesNotOnFs() + ", expiredPartitions=" + result.getExpiredPartitions());
        }
        catch (TException e) {
            throw new MetastoreException(e);
        }
        return result;
    }

    void findUnknownTables(String catName, String dbName, List<String> tables, CheckResult result) throws IOException, MetaException, TException {
        HashSet<Path> dbPaths = new HashSet<Path>();
        HashSet<String> tableNames = new HashSet<String>(tables);
        for (String tableName : tables) {
            Path tablePath;
            Table table = this.getMsc().getTable(catName, dbName, tableName);
            String isExternal = table.getParameters().get("EXTERNAL");
            if ("TRUE".equalsIgnoreCase(isExternal) || (tablePath = MetaStoreUtils.getPath(table)) == null) continue;
            dbPaths.add(tablePath.getParent());
        }
        for (Path dbPath : dbPaths) {
            FileStatus[] statuses;
            FileSystem fs = dbPath.getFileSystem(this.conf);
            for (FileStatus status : statuses = fs.listStatus(dbPath, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (!status.isDirectory() || tableNames.contains(status.getPath().getName())) continue;
                result.getTablesNotInMs().add(status.getPath().getName());
            }
        }
    }

    void checkTable(String catName, String dbName, String tableName, byte[] filterExp, CheckResult result) throws MetaException, IOException, MetastoreException {
        PartitionIterable parts;
        Table table;
        try {
            table = this.getMsc().getTable(catName, dbName, tableName);
        }
        catch (TException e) {
            result.getTablesNotInMs().add(tableName);
            return;
        }
        if (MetaStoreUtils.isPartitioned(table)) {
            if (filterExp != null) {
                ArrayList<Partition> results = new ArrayList<Partition>();
                MetaStoreUtils.getPartitionListByFilterExp(this.getMsc(), table, filterExp, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.DEFAULTPARTITIONNAME), results);
                parts = new PartitionIterable(results);
            } else {
                GetPartitionsRequest request = new GetPartitionsRequest(table.getDbName(), table.getTableName(), null, null);
                request.setProjectionSpec(new HiveMetaStoreClient.GetPartitionProjectionsSpecBuilder().addProjectField("sd.location").addProjectField("createTime").addProjectField("tableName").addProjectField("values").build());
                request.setCatName(table.getCatName());
                int batchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                parts = batchSize > 0 ? new PartitionIterable(this.getMsc(), table, batchSize).withProjectSpec(request) : new PartitionIterable(MetaStoreUtils.getPartitionsByProjectSpec(this.msc, request));
            }
        } else {
            parts = new PartitionIterable(Collections.emptyList());
        }
        this.checkTable(table, parts, filterExp, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void checkTable(final Table table, PartitionIterable parts, byte[] filterExp, final CheckResult result) throws IOException, MetastoreException, MetaException {
        tablePath = MetaStoreUtils.getPath(table);
        if (tablePath == null) {
            return;
        }
        fs = tablePath.getFileSystem(this.conf);
        if (!fs.exists(tablePath)) {
            result.getTablesNotOnFs().add(table.getTableName());
            return;
        }
        partPaths = new HashSet<Path>();
        threadCount = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.METASTORE_MSCK_FS_HANDLER_THREADS_COUNT);
        Preconditions.checkArgument((boolean)(threadCount >= 1), (Object)"METASTORE_MSCK_FS_HANDLER_THREADS_COUNT cannot be less than 1");
        Preconditions.checkArgument((boolean)(threadCount <= 30), (Object)"METASTORE_MSCK_FS_HANDLER_THREADS_COUNT cannot be more than 30");
        HiveMetaStoreChecker.LOG.debug("Running with threads {}", (Object)threadCount);
        pool = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(threadCount), new ThreadPoolExecutor.CallerRunsPolicy());
        processedPartitions = new ArrayList<E>();
        try {
            futures = new LinkedList<Future<T>>();
            for (final Partition partition : parts) {
                if (partition == null || (partPath = MetaStoreUtils.getDataLocation(table, partition)) == null) continue;
                futures.add(pool.submit(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() throws Exception {
                        long createdTime;
                        long currentEpochSecs;
                        long partitionAgeSeconds;
                        Path tempPartPath = partPath;
                        FileSystem tempFs = tempPartPath.getFileSystem(HiveMetaStoreChecker.this.conf);
                        CheckResult.PartitionResult prFromMetastore = new CheckResult.PartitionResult();
                        String partName = MetaStoreUtils.getPartitionName(table, partition);
                        prFromMetastore.setPartitionName(partName);
                        prFromMetastore.setTableName(partition.getTableName());
                        CheckResult checkResult = result;
                        synchronized (checkResult) {
                            if (!tempFs.exists(tempPartPath)) {
                                result.getPartitionsNotOnFs().add(prFromMetastore);
                            } else {
                                result.getCorrectPartitions().add(prFromMetastore);
                            }
                        }
                        if (HiveMetaStoreChecker.this.partitionExpirySeconds > 0L && (partitionAgeSeconds = (currentEpochSecs = Instant.now().getEpochSecond()) - (createdTime = (long)partition.getCreateTime())) > HiveMetaStoreChecker.this.partitionExpirySeconds) {
                            CheckResult.PartitionResult pr = new CheckResult.PartitionResult();
                            pr.setPartitionName(MetaStoreUtils.getPartitionName(table, partition));
                            pr.setTableName(partition.getTableName());
                            CheckResult checkResult2 = result;
                            synchronized (checkResult2) {
                                result.getExpiredPartitions().add(pr);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{}.{}.{}.{} expired. createdAt: {} current: {} age: {}s expiry: {}s", new Object[]{table.getCatName(), table.getDbName(), partition.getTableName(), pr.getPartitionName(), createdTime, currentEpochSecs, partitionAgeSeconds, HiveMetaStoreChecker.this.partitionExpirySeconds});
                            }
                        }
                        Set set = partPaths;
                        synchronized (set) {
                            for (int i = 0; i < MetaStoreUtils.getPartitionSpec(table, partition).size(); ++i) {
                                Path qualifiedPath = tempPartPath.makeQualified(tempFs);
                                HiveMetaStoreChecker.this.pathInterner.intern((Object)qualifiedPath);
                                partPaths.add(qualifiedPath);
                                tempPartPath = tempPartPath.getParent();
                            }
                        }
                        return processedPartitions.add(MetaStoreUtils.getPartitionName(table, partition));
                    }
                }));
            }
            while (!futures.isEmpty()) {
                ((Future)futures.poll()).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            try {
                HiveMetaStoreChecker.LOG.error("Exception occurred while processing partitions {}", (Throwable)e);
            }
            catch (Throwable var15_16) {
                HiveMetaStoreChecker.LOG.debug("Partition exists check complete for table {}.{}.{} partitions {}", new Object[]{table.getCatName(), table.getDbName(), table.getTableName(), processedPartitions});
                if (pool != null) {
                    pool.shutdownNow();
                }
                throw var15_16;
            }
            HiveMetaStoreChecker.LOG.debug("Partition exists check complete for table {}.{}.{} partitions {}", new Object[]{table.getCatName(), table.getDbName(), table.getTableName(), processedPartitions});
            if (pool != null) {
                pool.shutdownNow();
            } else {
                ** GOTO lbl46
            }
        }
        HiveMetaStoreChecker.LOG.debug("Partition exists check complete for table {}.{}.{} partitions {}", new Object[]{table.getCatName(), table.getDbName(), table.getTableName(), processedPartitions});
        if (pool != null) {
            pool.shutdownNow();
        }
        this.findUnknownPartitions(table, partPaths, filterExp, result);
        if (!MetaStoreUtils.isPartitioned(table) && TxnUtils.isTransactionalTable(table)) {
            tableResult = new CheckResult.PartitionResult();
            this.setMaxTxnAndWriteIdFromPartition(tablePath, tableResult);
            result.setMaxWriteId(tableResult.getMaxWriteId());
            result.setMaxTxnId(tableResult.getMaxTxnId());
        }
    }

    void findUnknownPartitions(Table table, Set<Path> partPaths, byte[] filterExp, CheckResult result) throws IOException, MetastoreException, MetaException {
        Path tablePath = MetaStoreUtils.getPath(table);
        if (tablePath == null) {
            return;
        }
        boolean transactionalTable = TxnUtils.isTransactionalTable(table);
        HashSet<Path> allPartDirs = new HashSet<Path>();
        List<FieldSchema> partColumns = table.getPartitionKeys();
        this.checkPartitionDirs(tablePath, allPartDirs, Collections.unmodifiableList(MetaStoreUtils.getPartColNames(table)));
        if (filterExp != null) {
            PartitionExpressionProxy expressionProxy = PartFilterExprUtil.createExpressionProxy(this.conf);
            ArrayList<String> paritions = new ArrayList<String>();
            HashSet<Path> partDirs = new HashSet<Path>();
            String tablePathStr = tablePath.toString();
            for (Path path : allPartDirs) {
                if (tablePathStr.endsWith("/")) {
                    paritions.add(path.toString().substring(tablePathStr.length()));
                    continue;
                }
                paritions.add(path.toString().substring(tablePathStr.length() + 1));
            }
            expressionProxy.filterPartitionsByExpr(partColumns, filterExp, this.conf.get(MetastoreConf.ConfVars.DEFAULTPARTITIONNAME.getVarname()), paritions);
            for (String string : paritions) {
                partDirs.add(new Path(tablePath, string));
            }
            allPartDirs = partDirs;
        }
        allPartDirs.remove(tablePath);
        allPartDirs.removeAll(partPaths);
        HashSet partColNames = Sets.newHashSet();
        for (FieldSchema fSchema : MetaStoreUtils.getPartCols(table)) {
            partColNames.add(fSchema.getName());
        }
        for (Path partPath : allPartDirs) {
            FileSystem fs = partPath.getFileSystem(this.conf);
            String partitionName = MetaStoreUtils.getPartitionName(fs.makeQualified(tablePath), partPath, partColNames);
            LOG.debug("PartitionName: " + partitionName);
            if (partitionName == null) continue;
            CheckResult.PartitionResult partitionResult = new CheckResult.PartitionResult();
            partitionResult.setPartitionName(partitionName);
            partitionResult.setTableName(table.getTableName());
            if (transactionalTable) {
                this.setMaxTxnAndWriteIdFromPartition(partPath, partitionResult);
            }
            partitionResult.setPath(partPath);
            if (result.getCorrectPartitions().contains(partitionResult)) {
                String msg = "The partition '" + partitionResult.toString() + "' already exists for table" + table.getTableName();
                throw new MetastoreException(msg);
            }
            if (result.getPartitionsNotInMs().contains(partitionResult)) {
                String msg = "Found two paths for same partition '" + partitionResult.toString() + "' for table " + table.getTableName();
                throw new MetastoreException(msg);
            }
            result.getPartitionsNotInMs().add(partitionResult);
            if (!result.getPartitionsNotOnFs().contains(partitionResult)) continue;
            result.getPartitionsNotOnFs().remove(partitionResult);
        }
        LOG.debug("Number of partitions not in metastore : " + result.getPartitionsNotInMs().size());
    }

    private void setMaxTxnAndWriteIdFromPartition(Path partPath, CheckResult.PartitionResult res) throws IOException {
        FileSystem fs = partPath.getFileSystem(this.conf);
        FileStatus[] deltaOrBaseFiles = fs.listStatus(partPath, HIDDEN_FILES_PATH_FILTER);
        long maxWriteId = 0L;
        long maxVisibilityId = 0L;
        for (FileStatus fileStatus : deltaOrBaseFiles) {
            if (!fileStatus.isDirectory()) continue;
            long writeId = 0L;
            long visibilityId = 0L;
            String folder = fileStatus.getPath().getName();
            String[] visParts = folder.split("_v");
            if (visParts.length > 1) {
                visibilityId = Long.parseLong(visParts[1]);
                folder = visParts[0];
            }
            if (folder.startsWith("base_")) {
                writeId = Long.parseLong(folder.substring("base_".length()));
            } else if (folder.startsWith("delta_") || folder.startsWith("delete_delta_")) {
                boolean isDeleteDelta = folder.startsWith("delete_delta_");
                String rest = folder.substring((isDeleteDelta ? "delete_delta_" : "delta_").length());
                String[] nameParts = rest.split("_");
                writeId = Long.parseLong(nameParts.length > 1 ? nameParts[1] : nameParts[0]);
            }
            if (writeId > maxWriteId) {
                maxWriteId = writeId;
            }
            if (visibilityId <= maxVisibilityId) continue;
            maxVisibilityId = visibilityId;
        }
        LOG.debug("Max writeId {}, max txnId {} found in partition {}", new Object[]{maxWriteId, maxVisibilityId, partPath.toUri().toString()});
        res.setMaxWriteId(maxWriteId);
        res.setMaxTxnId(maxVisibilityId);
    }

    private void checkPartitionDirs(Path basePath, Set<Path> allDirs, List<String> partColNames) throws IOException, MetastoreException {
        Object executor;
        int poolSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT);
        if (poolSize <= 1) {
            LOG.debug("Using single-threaded version of MSCK-GetPaths");
            executor = MoreExecutors.newDirectExecutorService();
        } else {
            LOG.debug("Using multi-threaded version of MSCK-GetPaths with number of threads " + poolSize);
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MSCK-GetPaths-%d").build();
            executor = Executors.newFixedThreadPool(poolSize, threadFactory);
        }
        this.checkPartitionDirs((ExecutorService)executor, basePath, allDirs, basePath.getFileSystem(this.conf), partColNames);
        executor.shutdown();
    }

    private void checkPartitionDirs(ExecutorService executor, Path basePath, Set<Path> result, FileSystem fs, List<String> partColNames) throws MetastoreException {
        try {
            LinkedList<Future<Path>> futures = new LinkedList<Future<Path>>();
            ConcurrentLinkedQueue<PathDepthInfo> nextLevel = new ConcurrentLinkedQueue<PathDepthInfo>();
            nextLevel.add(new PathDepthInfo(basePath, 0));
            while (!nextLevel.isEmpty()) {
                ConcurrentLinkedQueue tempQueue = new ConcurrentLinkedQueue();
                while (!nextLevel.isEmpty()) {
                    futures.add(executor.submit(new PathDepthInfoCallable((PathDepthInfo)nextLevel.poll(), partColNames, fs, tempQueue)));
                }
                while (!futures.isEmpty()) {
                    Path p = (Path)((Future)futures.poll()).get();
                    if (p == null) continue;
                    result.add(p);
                }
                nextLevel = tempQueue;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage());
            executor.shutdownNow();
            throw new MetastoreException(e.getCause());
        }
    }

    private static class PathDepthInfo {
        private final Path p;
        private final int depth;

        PathDepthInfo(Path p, int depth) {
            this.p = p;
            this.depth = depth;
        }
    }

    private final class PathDepthInfoCallable
    implements Callable<Path> {
        private final List<String> partColNames;
        private final FileSystem fs;
        private final ConcurrentLinkedQueue<PathDepthInfo> pendingPaths;
        private final boolean throwException;
        private final PathDepthInfo pd;

        private PathDepthInfoCallable(PathDepthInfo pd, List<String> partColNames, FileSystem fs, ConcurrentLinkedQueue<PathDepthInfo> basePaths) {
            this.partColNames = partColNames;
            this.pd = pd;
            this.fs = fs;
            this.pendingPaths = basePaths;
            this.throwException = "throw".equals(MetastoreConf.getVar(HiveMetaStoreChecker.this.conf, MetastoreConf.ConfVars.MSCK_PATH_VALIDATION));
        }

        @Override
        public Path call() throws Exception {
            return this.processPathDepthInfo(this.pd);
        }

        private Path processPathDepthInfo(PathDepthInfo pd) throws IOException, MetastoreException {
            Path currentPath = pd.p;
            int currentDepth = pd.depth;
            FileStatus[] fileStatuses = this.fs.listStatus(currentPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
            if (fileStatuses.length == 0 && currentDepth > 0 && currentDepth < this.partColNames.size()) {
                this.logOrThrowExceptionWithMsg("MSCK is missing partition columns under " + currentPath.toString());
            } else {
                for (FileStatus fileStatus : fileStatuses) {
                    if (!fileStatus.isDirectory() && currentDepth < this.partColNames.size()) {
                        this.logOrThrowExceptionWithMsg("MSCK finds a file rather than a directory when it searches for " + fileStatus.getPath().toString());
                        continue;
                    }
                    if (!fileStatus.isDirectory() || currentDepth >= this.partColNames.size()) continue;
                    Path nextPath = fileStatus.getPath();
                    String[] parts = nextPath.getName().split("=");
                    if (parts.length != 2) {
                        this.logOrThrowExceptionWithMsg("Invalid partition name " + nextPath);
                        continue;
                    }
                    if (!parts[0].equalsIgnoreCase(this.partColNames.get(currentDepth))) {
                        this.logOrThrowExceptionWithMsg("Unexpected partition key " + parts[0] + " found at " + nextPath);
                        continue;
                    }
                    this.pendingPaths.add(new PathDepthInfo(nextPath, currentDepth + 1));
                }
                if (currentDepth == this.partColNames.size()) {
                    return currentPath;
                }
            }
            return null;
        }

        private void logOrThrowExceptionWithMsg(String msg) throws MetastoreException {
            if (this.throwException) {
                throw new MetastoreException(msg);
            }
            LOG.warn(msg);
        }
    }
}

