/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface HiveMetaHook {
    public static final String ALTER_TABLE_OPERATION_TYPE = "alterTableOpType";
    public static final List<String> allowedAlterTypes = ImmutableList.of((Object)"ADDPROPS", (Object)"DROPPROPS");
    public static final String ALTERLOCATION = "ALTERLOCATION";
    public static final String ALLOW_PARTITION_KEY_CHANGE = "allow_partition_key_change";
    public static final String SET_PROPERTIES = "set_properties";
    public static final String UNSET_PROPERTIES = "unset_properties";
    public static final String TRANSLATED_TO_EXTERNAL = "TRANSLATED_TO_EXTERNAL";
    public static final String TABLE_TYPE = "table_type";
    public static final String EXTERNAL = "EXTERNAL";
    public static final String ICEBERG = "ICEBERG";
    public static final String PROPERTIES_SEPARATOR = "'";
    public static final String MIGRATE_HIVE_TO_ICEBERG = "migrate_hive_to_iceberg";
    public static final String INITIALIZE_ROLLBACK_MIGRATION = "initialize_rollback_migration";
    public static final String SKIP_METASTORE_ALTER = "skip_metastore_alter";
    public static final String OLD_TABLE_NAME = "old_table_name";
    public static final String OLD_DB_NAME = "old_db_name";

    public void preCreateTable(Table var1) throws MetaException;

    public void rollbackCreateTable(Table var1) throws MetaException;

    public void commitCreateTable(Table var1) throws MetaException;

    public void preDropTable(Table var1) throws MetaException;

    default public void preDropTable(Table table, boolean deleteData) throws MetaException {
        this.preDropTable(table);
    }

    public void rollbackDropTable(Table var1) throws MetaException;

    public void commitDropTable(Table var1, boolean var2) throws MetaException;

    default public void preAlterTable(Table table, EnvironmentContext context) throws MetaException {
        String alterOpType;
        String string = alterOpType = context == null || context.getProperties() == null ? null : context.getProperties().get(ALTER_TABLE_OPERATION_TYPE);
        if (alterOpType != null && !allowedAlterTypes.contains(alterOpType)) {
            throw new MetaException("ALTER TABLE can not be used for " + alterOpType + " to a non-native table ");
        }
    }

    default public void commitAlterTable(Table table, EnvironmentContext context) throws MetaException {
    }

    default public void rollbackAlterTable(Table table, EnvironmentContext context) throws MetaException {
    }

    default public void preTruncateTable(Table table, EnvironmentContext context) throws MetaException {
    }

    default public boolean createHMSTableInHook() {
        return false;
    }

    default public void postGetTable(Table table) {
    }
}

