/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;

public enum DatabaseProduct {
    DERBY,
    MYSQL,
    POSTGRES,
    ORACLE,
    SQLSERVER,
    OTHER;


    public static DatabaseProduct determineDatabaseProduct(String productName) throws SQLException {
        if (productName == null) {
            return OTHER;
        }
        if ((productName = productName.toLowerCase()).contains("derby")) {
            return DERBY;
        }
        if (productName.contains("microsoft sql server")) {
            return SQLSERVER;
        }
        if (productName.contains("mysql")) {
            return MYSQL;
        }
        if (productName.contains("oracle")) {
            return ORACLE;
        }
        if (productName.contains("postgresql")) {
            return POSTGRES;
        }
        return OTHER;
    }

    public static boolean isDeadlock(DatabaseProduct dbProduct, SQLException e) {
        return e instanceof SQLTransactionRollbackException || (dbProduct == MYSQL || dbProduct == POSTGRES || dbProduct == SQLSERVER) && "40001".equals(e.getSQLState()) || dbProduct == POSTGRES && "40P01".equals(e.getSQLState()) || dbProduct == ORACLE && e.getMessage() != null && (e.getMessage().contains("deadlock detected") || e.getMessage().contains("can't serialize access for this transaction"));
    }

    public static boolean isTableNotExistsError(DatabaseProduct dbProduct, SQLException e) {
        return dbProduct == POSTGRES && "42P01".equalsIgnoreCase(e.getSQLState()) || dbProduct == MYSQL && "42S02".equalsIgnoreCase(e.getSQLState()) || dbProduct == ORACLE && "42000".equalsIgnoreCase(e.getSQLState()) && e.getMessage().contains("ORA-00942") || dbProduct == SQLSERVER && "S0002".equalsIgnoreCase(e.getSQLState()) && e.getMessage().contains("Invalid object") || dbProduct == DERBY && "42X05".equalsIgnoreCase(e.getSQLState());
    }

    public static String toVarChar(DatabaseProduct dbType, String column) {
        switch (dbType) {
            case DERBY: {
                return String.format("CAST(%s AS VARCHAR(4000))", column);
            }
            case ORACLE: {
                return String.format("to_char(%s)", column);
            }
        }
        return column;
    }

    public static boolean needsInBatching(DatabaseProduct dbType) {
        return dbType == ORACLE || dbType == SQLSERVER;
    }

    public static boolean hasJoinOperationOrderBug(DatabaseProduct dbType) {
        return dbType == DERBY || dbType == ORACLE || dbType == POSTGRES;
    }

    public static boolean isDERBY(DatabaseProduct dbType) {
        return dbType == DERBY;
    }

    public static boolean isMYSQL(DatabaseProduct dbType) {
        return dbType == MYSQL;
    }

    public final boolean isSQLSERVER(DatabaseProduct dbType) {
        return dbType == SQLSERVER;
    }

    public static boolean isDuplicateKeyError(DatabaseProduct dbType, SQLException ex) {
        switch (dbType) {
            case DERBY: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            case MYSQL: {
                if (ex.getErrorCode() != 1022 && ex.getErrorCode() != 1062 && ex.getErrorCode() != 1586 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case SQLSERVER: {
                if (ex.getErrorCode() != 2627 && ex.getErrorCode() != 2601 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case ORACLE: {
                if (ex.getErrorCode() != 1 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case POSTGRES: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unexpected DB type: " + (Object)((Object)dbType) + "; " + ex.getMessage() + " (SQLState=" + ex.getSQLState() + ", ErrorCode=" + ex.getErrorCode() + ")");
            }
        }
        return false;
    }

    protected static String toDate(String tableValue, DatabaseProduct dbType) {
        if (ORACLE == dbType) {
            return "TO_DATE(" + tableValue + ", 'YYYY-MM-DD')";
        }
        return "cast(" + tableValue + " as date)";
    }

    protected static String toTimestamp(String tableValue, DatabaseProduct dbType) {
        if (ORACLE == dbType) {
            return "TO_TIMESTAMP(" + tableValue + ", 'YYYY-MM-DD HH24:mi:ss')";
        }
        if (SQLSERVER == dbType) {
            return "CONVERT(DATETIME, " + tableValue + ")";
        }
        return "cast(" + tableValue + " as TIMESTAMP)";
    }

    public Object getBoolean(DatabaseProduct dbType, boolean val) {
        if (DatabaseProduct.isDERBY(dbType)) {
            return val ? "Y" : "N";
        }
        return val;
    }

    public int getMaxRows(int batch, int paramSize, DatabaseProduct dbType) {
        if (this.isSQLSERVER(dbType)) {
            int maxAllowedRows = (2100 - paramSize) / paramSize;
            return Math.min(batch, maxAllowedRows);
        }
        return batch;
    }
}

