/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class CheckResult {
    private Set<String> tablesNotOnFs = new TreeSet<String>();
    private Set<String> tablesNotInMs = new TreeSet<String>();
    private Set<PartitionResult> partitionsNotOnFs = new TreeSet<PartitionResult>();
    private Set<PartitionResult> partitionsNotInMs = new TreeSet<PartitionResult>();
    private Set<PartitionResult> expiredPartitions = new TreeSet<PartitionResult>();
    private long maxWriteId;
    private long maxTxnId;
    private Set<PartitionResult> correctPartitions = new TreeSet<PartitionResult>();

    public Set<String> getTablesNotOnFs() {
        return this.tablesNotOnFs;
    }

    public void setTablesNotOnFs(Set<String> tablesNotOnFs) {
        this.tablesNotOnFs = tablesNotOnFs;
    }

    public Set<String> getTablesNotInMs() {
        return this.tablesNotInMs;
    }

    public void setTablesNotInMs(Set<String> tablesNotInMs) {
        this.tablesNotInMs = tablesNotInMs;
    }

    public Set<PartitionResult> getPartitionsNotOnFs() {
        return this.partitionsNotOnFs;
    }

    public void setPartitionsNotOnFs(Set<PartitionResult> partitionsNotOnFs) {
        this.partitionsNotOnFs = partitionsNotOnFs;
    }

    public Set<PartitionResult> getPartitionsNotInMs() {
        return this.partitionsNotInMs;
    }

    public void setPartitionsNotInMs(Set<PartitionResult> partitionsNotInMs) {
        this.partitionsNotInMs = partitionsNotInMs;
    }

    public Set<PartitionResult> getExpiredPartitions() {
        return this.expiredPartitions;
    }

    public void setExpiredPartitions(Set<PartitionResult> expiredPartitions) {
        this.expiredPartitions = expiredPartitions;
    }

    public long getMaxWriteId() {
        return this.maxWriteId;
    }

    public void setMaxWriteId(long maxWriteId) {
        this.maxWriteId = maxWriteId;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public void setMaxTxnId(long maxTxnId) {
        this.maxTxnId = maxTxnId;
    }

    public Set<PartitionResult> getCorrectPartitions() {
        return this.correctPartitions;
    }

    public void setCorrectPartitions(Set<PartitionResult> correctPartitions) {
        this.correctPartitions = correctPartitions;
    }

    public static class PartitionResult
    implements Comparable<PartitionResult> {
        private String partitionName;
        private String tableName;
        private long maxWriteId;
        private long maxTxnId;
        private Path path;

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public long getMaxWriteId() {
            return this.maxWriteId;
        }

        public void setMaxWriteId(long maxWriteId) {
            this.maxWriteId = maxWriteId;
        }

        public long getMaxTxnId() {
            return this.maxTxnId;
        }

        public void setMaxTxnId(long maxTxnId) {
            this.maxTxnId = maxTxnId;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public Path getLocation(Path tablePath, Map<String, String> partSpec) throws MetaException {
            if (this.path == null) {
                return new Path(tablePath, Warehouse.makePartPath(partSpec));
            }
            return this.path;
        }

        public String toString() {
            return this.tableName + ":" + this.partitionName;
        }

        public boolean equals(Object other) {
            return other instanceof PartitionResult && 0 == this.compareTo((PartitionResult)other);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public int compareTo(PartitionResult o) {
            int ret = this.tableName.compareTo(o.tableName);
            return ret != 0 ? ret : this.partitionName.compareTo(o.partitionName);
        }
    }
}

