/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;

public class CDHMetaStoreSchemaInfo
extends MetaStoreSchemaInfo {
    private static String CDH_VERSION_UPGRADE_LIST = "cdh.upgrade.order";
    private static final Log LOG = LogFactory.getLog((String)CDHMetaStoreSchemaInfo.class.getName());

    @VisibleForTesting
    Collection<CDHVersion> getCDHVersionsWithSchemaChanges() throws HiveMetaException {
        String[] cdhUpgradeScriptNames = this.loadAllCDHUpgradeScripts(this.dbType);
        TreeSet<CDHVersion> cdhVersionsWithSchemaChanges = new TreeSet<CDHVersion>();
        for (String cdhUpgradeScriptName : cdhUpgradeScriptNames) {
            String toVersionFromUpgradePath = cdhUpgradeScriptName.split("-to-")[1];
            LOG.debug((Object)("Adding " + toVersionFromUpgradePath + " to cdh versions with schema changes"));
            cdhVersionsWithSchemaChanges.add(new CDHVersion(toVersionFromUpgradePath));
        }
        return cdhVersionsWithSchemaChanges;
    }

    public CDHMetaStoreSchemaInfo(String hiveHome, String dbType) throws HiveMetaException {
        super(hiveHome, dbType);
    }

    @VisibleForTesting
    String[] loadAllCDHUpgradeScripts(String dbType) throws HiveMetaException {
        ArrayList<String> cdhUpgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + CDH_VERSION_UPGRADE_LIST + "." + dbType;
        if (new File(upgradeListFile).exists()) {
            try (BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));){
                String line;
                while ((line = bfReader.readLine()) != null) {
                    cdhUpgradeOrderList.add(line.trim());
                }
            }
            catch (IOException e) {
                throw new HiveMetaException("Error reading " + upgradeListFile, e);
            }
        }
        return cdhUpgradeOrderList.toArray(new String[cdhUpgradeOrderList.size()]);
    }

    @Override
    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        ArrayList<String> upgradeScriptList = new ArrayList();
        try {
            upgradeScriptList = super.getUpgradeScripts(fromVersion);
        }
        catch (HiveMetaException hiveMetaException) {
            // empty catch block
        }
        List<String> cdhScriptList = this.getCDHSchemaUpgrades(fromVersion);
        if (cdhScriptList.size() > 0) {
            this.removeRedundantScripts(fromVersion, upgradeScriptList, cdhScriptList);
            upgradeScriptList.addAll(cdhScriptList);
        }
        return upgradeScriptList;
    }

    private void removeRedundantScripts(String fromVersion, List<String> upgradeScriptList, List<String> cdhScriptList) {
        if (cdhScriptList == null || cdhScriptList.isEmpty()) {
            return;
        }
        String first = this.getUpgradePathFromUpgradeFileName(cdhScriptList.get(0));
        String last = this.getUpgradePathFromUpgradeFileName(cdhScriptList.get(cdhScriptList.size() - 1));
        String firstHiveVersion = this.getFirstThreeHiveVersion(first.split("-to-")[0]);
        String lastHiveVersion = this.getFirstThreeHiveVersion(last.split("-to-")[1]);
        Iterator<String> it = upgradeScriptList.iterator();
        while (it.hasNext()) {
            String upgradePathFromScript = this.getUpgradePathFromUpgradeFileName(it.next());
            String fromHiveVersion = upgradePathFromScript.split("-to-")[0];
            String toHiveVersion = upgradePathFromScript.split("-to-")[1];
            if (CDHVersion.compareVersionStrings(fromHiveVersion, firstHiveVersion) < 0 || CDHVersion.compareVersionStrings(toHiveVersion, lastHiveVersion) > 0) continue;
            it.remove();
        }
    }

    @Override
    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = this.getHiveSchemaVersion();
        }
        toVersion = this.getMajorVersion(toVersion);
        return super.generateInitFileName(toVersion);
    }

    private String generateUpgradeFileName(String fileVersion) {
        return "upgrade-" + fileVersion + "." + this.dbType + ".sql";
    }

    private String getUpgradePathFromUpgradeFileName(String upgradeFileName) {
        upgradeFileName = upgradeFileName.replaceAll("upgrade-", "");
        upgradeFileName = upgradeFileName.substring(0, upgradeFileName.lastIndexOf(46));
        upgradeFileName = upgradeFileName.substring(0, upgradeFileName.lastIndexOf(46));
        return upgradeFileName;
    }

    private String getMajorVersion(String fullVersion) {
        return this.getFirstThreeHiveVersion(fullVersion);
    }

    @Override
    public String getHiveSchemaVersion() {
        return MetastoreVersionInfo.getVersion().replaceAll("-SNAPSHOT", "");
    }

    private boolean validateVersion(String version) {
        String v = this.getFirstThreeHiveVersion(version);
        String schemaFileName = this.getMetaStoreScriptDir() + File.separator + "hive-schema-" + v + "." + this.dbType + ".sql";
        File schemaFile = new File(schemaFileName);
        return schemaFile.exists() && schemaFile.isFile();
    }

    private List<String> getCDHSchemaUpgrades(String from) throws HiveMetaException {
        if (!this.validateVersion(from)) {
            throw new HiveMetaException("Unknown schema version " + from + " specified, failing upgrade");
        }
        ArrayList<String> minorUpgradeList = new ArrayList<String>();
        String cdhVersion = this.getHiveSchemaVersion();
        if (cdhVersion.equals(from)) {
            return minorUpgradeList;
        }
        CDHVersion currentCdhVersion = new CDHVersion(cdhVersion);
        String[] cdhSchemaVersions = this.loadAllCDHUpgradeScripts(this.dbType);
        CDHVersion fromCdhVersion = null;
        if (StringUtils.countMatches((CharSequence)CDHVersion.convertToUnifiedVersionString(from), (CharSequence)".") >= 6) {
            fromCdhVersion = new CDHVersion(from);
        }
        for (int i = 0; i < cdhSchemaVersions.length; ++i) {
            CDHVersion toVersionFromUpgradePath = new CDHVersion(cdhSchemaVersions[i].split("-to-")[1]);
            if (fromCdhVersion != null && fromCdhVersion.compareTo(toVersionFromUpgradePath) >= 0) {
                LOG.info((Object)("Current version is higher than or equal to " + toVersionFromUpgradePath + " Skipping file " + cdhSchemaVersions[i]));
                continue;
            }
            String scriptFile = this.generateUpgradeFileName(cdhSchemaVersions[i]);
            minorUpgradeList.add(scriptFile);
            LOG.info((Object)("Adding " + scriptFile + " to the list of upgrades to be applied"));
        }
        return minorUpgradeList;
    }

    @Override
    public boolean isVersionCompatible(String cdhHiveVersion, String dbVersion) {
        boolean isCompatible = super.isVersionCompatible(this.getMajorVersion(cdhHiveVersion), this.getMajorVersion(dbVersion));
        if (!isCompatible) {
            return isCompatible;
        }
        LOG.debug((Object)"Upstream versions are compatible, comparing downstream");
        return this.isCDHVersionCompatible(new CDHVersion(cdhHiveVersion), new CDHVersion(dbVersion));
    }

    private boolean isCDHVersionCompatible(CDHVersion cdhVersion, CDHVersion dbVersion) {
        Collection<CDHVersion> cdhVersionsWithSchemaChanges;
        if (cdhVersion.equals(dbVersion)) {
            return true;
        }
        CDHVersion minRequiredSchemaVersion = null;
        try {
            cdhVersionsWithSchemaChanges = this.getCDHVersionsWithSchemaChanges();
        }
        catch (HiveMetaException e) {
            LOG.error((Object)"Unable to load the cdh versions with schema changes ", (Throwable)e);
            throw new RuntimeException(e);
        }
        for (CDHVersion currentCheckPoint : cdhVersionsWithSchemaChanges) {
            if (currentCheckPoint.compareTo(cdhVersion) > 0) continue;
            minRequiredSchemaVersion = currentCheckPoint;
        }
        if (minRequiredSchemaVersion != null) {
            return dbVersion.compareTo(minRequiredSchemaVersion) >= 0;
        }
        return true;
    }

    @Override
    public String getMetaStoreSchemaVersion(HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo) throws HiveMetaException {
        boolean needsQuotedIdentifier = HiveSchemaHelper.getDbCommandParser(connectionInfo.getDbType(), connectionInfo.getMetaDbType(), false).needsQuotedIdentifier();
        Connection metastoreDbConnection = null;
        try {
            String schema = "hive".equals(connectionInfo.getDbType()) ? "SYS" : null;
            metastoreDbConnection = HiveSchemaHelper.getConnectionToMetastore(connectionInfo, schema);
            return this.getSchemaVersionInternal(metastoreDbConnection, "CDH_VERSION", needsQuotedIdentifier);
        }
        catch (SQLException ex) {
            try {
                return this.getSchemaVersionInternal(metastoreDbConnection, "VERSION", needsQuotedIdentifier);
            }
            catch (SQLException e) {
                throw new HiveMetaException("Failed to get schema version, Cause:" + e.getMessage());
            }
        }
    }

    private String getSchemaVersionInternal(Connection metastoreDbConnection, String table, boolean quoted) throws SQLException, HiveMetaException {
        String versionQuery = quoted ? "select * from \"" + table + "\" t" : "select * from " + table + " t";
        Statement stmt = metastoreDbConnection.createStatement();
        ResultSet res = stmt.executeQuery(versionQuery);
        if (!res.next()) {
            throw new SQLException("Could not find version info in metastore " + table + " table.");
        }
        String version = this.getSchemaVersion(res);
        if (res.next()) {
            throw new HiveMetaException("Multiple versions were found in metastore.");
        }
        return version;
    }

    private String getSchemaVersion(ResultSet res) throws SQLException {
        return this.getColumnValue(res, "SCHEMA_VERSION");
    }

    protected String getColumnValue(ResultSet res, String columnName) throws SQLException {
        if (res.getMetaData() == null) {
            throw new IllegalArgumentException("ResultSet metadata cannot be null");
        }
        int numCols = res.getMetaData().getColumnCount();
        for (int i = 1; i <= numCols; ++i) {
            String db_col_name;
            String[] colNameArr = res.getMetaData().getColumnName(i).split("\\.");
            String string = db_col_name = colNameArr.length == 2 ? colNameArr[1] : colNameArr[0];
            if (!columnName.equalsIgnoreCase(db_col_name)) continue;
            return res.getString(i);
        }
        return null;
    }

    protected String getFirstThreeHiveVersion(String version) {
        String[] strArray = version.split("\\.", 4);
        StringBuilder sb = new StringBuilder();
        String seperator = "";
        try {
            for (int i = 0; i < 3; ++i) {
                sb.append(seperator + strArray[i]);
                seperator = ".";
            }
        }
        catch (RuntimeException e) {
            String error_string = version + " should at least consists of 3 numbers";
            LOG.error((Object)error_string);
            throw new RuntimeException(e + error_string);
        }
        return sb.toString();
    }

    @VisibleForTesting
    static class CDHVersion
    implements Comparable<CDHVersion> {
        private final String version;

        String getCdhVersionString() {
            String unifiedVer = CDHVersion.convertToUnifiedVersionString(this.version);
            LOG.info((Object)("the version is " + unifiedVer));
            if (StringUtils.countMatches((CharSequence)unifiedVer, (CharSequence)".") < 6) {
                throw new IllegalArgumentException("Invalid format of cdh version string " + this.version);
            }
            String[] array = unifiedVer.split("\\.", 4);
            return array[array.length - 1].split("-", 2)[0];
        }

        public String toString() {
            return this.version;
        }

        public CDHVersion(String versionStr) {
            if (versionStr == null) {
                throw new IllegalArgumentException("Version cannot be null");
            }
            this.version = versionStr.toLowerCase();
        }

        @Override
        public int compareTo(CDHVersion other) {
            LOG.debug((Object)("Comparing " + this + " with " + other));
            String cdhVersion1 = this.getCdhVersionString();
            String cdhVersion2 = other.getCdhVersionString();
            String[] aVersionParts = cdhVersion1.split("\\.");
            String[] bVersionParts = cdhVersion2.split("\\.");
            return CDHVersion.compareVersionStrings(aVersionParts, bVersionParts);
        }

        public static String convertToUnifiedVersionString(String cdpVersion) {
            String hfVersion = ".*\\d{4}(\\.\\d+){2}-h\\d+(-b\\d+)?";
            String normalVersion = ".*\\d{4}(\\.\\d+){2}-b\\d+";
            String schemaVersion = ".*\\d{4}(\\.\\d+){4}-update\\d+";
            if (Pattern.matches(hfVersion, cdpVersion)) {
                return cdpVersion.replaceAll("-h", ".");
            }
            if (Pattern.matches(normalVersion, cdpVersion)) {
                return cdpVersion.replace("-b", ".0-b");
            }
            if (Pattern.matches(schemaVersion, cdpVersion)) {
                return cdpVersion.replace("-", "");
            }
            if (StringUtils.countMatches((CharSequence)cdpVersion, (CharSequence)".") == 5) {
                return cdpVersion + ".0";
            }
            return cdpVersion;
        }

        private static int compareVersionStrings(String aVersion, String bVersion) {
            String aUnifiedVer = CDHVersion.convertToUnifiedVersionString(aVersion);
            String bUnifiedVer = CDHVersion.convertToUnifiedVersionString(bVersion);
            return CDHVersion.compareVersionStrings(aUnifiedVer.split("\\."), bUnifiedVer.split("\\."));
        }

        private static int compareVersionStrings(String[] aVersionParts, String[] bVersionParts) {
            if (aVersionParts.length != bVersionParts.length) {
                throw new IllegalArgumentException("Cannot compare Version strings " + Arrays.toString(aVersionParts) + " and " + Arrays.toString(bVersionParts) + " since follow different format");
            }
            for (int i = 0; i < aVersionParts.length; ++i) {
                if (i == aVersionParts.length - 1) {
                    return aVersionParts[i].compareToIgnoreCase(bVersionParts[i]);
                }
                Integer aVersionPart = Integer.valueOf(aVersionParts[i]);
                Integer bVersionPart = Integer.valueOf(bVersionParts[i]);
                if (aVersionPart > bVersionPart) {
                    LOG.debug((Object)("Version " + aVersionPart + " is higher than " + bVersionPart));
                    return 1;
                }
                if (aVersionPart >= bVersionPart) continue;
                LOG.debug((Object)("Version " + aVersionPart + " is lower than " + bVersionPart));
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CDHVersion other = (CDHVersion)obj;
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

