/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hive.common.util.BloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateStatsCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)AggregateStatsCache.class.getName());
    private static AggregateStatsCache self = null;
    private final ConcurrentHashMap<Key, AggrColStatsList> cacheStore;
    private final int maxCacheNodes;
    private final AtomicInteger currentNodes = new AtomicInteger(0);
    private final double maxFull;
    private final double cleanUntil;
    private final long timeToLiveMs;
    private final long maxWriterWaitTime;
    private final long maxReaderWaitTime;
    private final int maxPartsPerCacheNode;
    private final double falsePositiveProbability;
    private final double maxVariance;
    private boolean isCleaning = false;
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    int numRemovedTTL = 0;
    int numRemovedLRU = 0;

    private AggregateStatsCache(int maxCacheNodes, int maxPartsPerCacheNode, long timeToLiveMs, double falsePositiveProbability, double maxVariance, long maxWriterWaitTime, long maxReaderWaitTime, double maxFull, double cleanUntil) {
        this.maxCacheNodes = maxCacheNodes;
        this.maxPartsPerCacheNode = maxPartsPerCacheNode;
        this.timeToLiveMs = timeToLiveMs;
        this.falsePositiveProbability = falsePositiveProbability;
        this.maxVariance = maxVariance;
        this.maxWriterWaitTime = maxWriterWaitTime;
        this.maxReaderWaitTime = maxReaderWaitTime;
        this.maxFull = maxFull;
        this.cleanUntil = cleanUntil;
        this.cacheStore = new ConcurrentHashMap();
    }

    public static synchronized AggregateStatsCache getInstance(Configuration conf) {
        if (self == null) {
            int maxCacheNodes = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_SIZE);
            int maxPartitionsPerCacheNode = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_PARTITIONS);
            long timeToLiveMs = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_TTL, TimeUnit.SECONDS) * 1000L;
            double falsePositiveProbability = MetastoreConf.getDoubleVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_FPP);
            double maxVariance = MetastoreConf.getDoubleVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_VARIANCE);
            long maxWriterWaitTime = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_WRITER_WAIT, TimeUnit.MILLISECONDS);
            long maxReaderWaitTime = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_READER_WAIT, TimeUnit.MILLISECONDS);
            double maxFull = MetastoreConf.getDoubleVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_FULL);
            double cleanUntil = MetastoreConf.getDoubleVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_CLEAN_UNTIL);
            self = new AggregateStatsCache(maxCacheNodes, maxPartitionsPerCacheNode, timeToLiveMs, falsePositiveProbability, maxVariance, maxWriterWaitTime, maxReaderWaitTime, maxFull, cleanUntil);
        }
        return self;
    }

    public int getMaxCacheNodes() {
        return this.maxCacheNodes;
    }

    public int getCurrentNodes() {
        return this.currentNodes.intValue();
    }

    public float getFullPercent() {
        return (float)this.currentNodes.intValue() / (float)this.maxCacheNodes * 100.0f;
    }

    public int getMaxPartsPerCacheNode() {
        return this.maxPartsPerCacheNode;
    }

    public double getFalsePositiveProbability() {
        return this.falsePositiveProbability;
    }

    public Float getHitRatio() {
        if (this.cacheHits.longValue() + this.cacheMisses.longValue() > 0L) {
            return Float.valueOf((float)this.cacheHits.longValue() / (float)(this.cacheHits.longValue() + this.cacheMisses.longValue()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggrColStats get(String catName, String dbName, String tblName, String colName, List<String> partNames) {
        Key key = new Key(catName, dbName, tblName, colName);
        AggrColStatsList candidateList = this.cacheStore.get(key);
        if (candidateList == null || candidateList.nodes.size() == 0) {
            LOG.debug("No aggregate stats cached for " + key.toString());
            return null;
        }
        AggrColStats match = null;
        boolean isLocked = false;
        try {
            isLocked = candidateList.readLock.tryLock(this.maxReaderWaitTime, TimeUnit.MILLISECONDS);
            if (isLocked) {
                match = this.findBestMatch(partNames, candidateList.nodes);
            }
            if (match != null) {
                candidateList.updateLastAccessTime();
                this.cacheHits.incrementAndGet();
                LOG.info("Returning aggregate stats from the cache; total hits: " + this.cacheHits.longValue() + ", total misses: " + this.cacheMisses.longValue() + ", hit ratio: " + this.getHitRatio());
            } else {
                this.cacheMisses.incrementAndGet();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted Exception ignored ", (Throwable)e);
        }
        finally {
            if (isLocked) {
                candidateList.readLock.unlock();
            }
        }
        return match;
    }

    private AggrColStats findBestMatch(List<String> partNames, List<AggrColStats> candidates) {
        HashMap<AggrColStats, MatchStats> candidateMatchStats = new HashMap<AggrColStats, MatchStats>();
        AggrColStats bestMatch = null;
        int bestMatchHits = 0;
        int numPartsRequested = partNames.size();
        for (AggrColStats candidate : candidates) {
            if ((double)Math.abs((candidate.getNumPartsCached() - (long)numPartsRequested) / (long)numPartsRequested) > this.maxVariance || this.isExpired(candidate)) continue;
            candidateMatchStats.put(candidate, new MatchStats(0, 0));
        }
        int maxMisses = (int)this.maxVariance * numPartsRequested;
        for (String partName : partNames) {
            Iterator iterator = candidateMatchStats.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                AggrColStats candidate = (AggrColStats)entry.getKey();
                MatchStats matchStats = (MatchStats)entry.getValue();
                if (candidate.getBloomFilter().test(partName.getBytes())) {
                    ++matchStats.hits;
                } else {
                    ++matchStats.misses;
                }
                if (matchStats.misses > maxMisses) {
                    iterator.remove();
                    continue;
                }
                if (matchStats.hits <= bestMatchHits) continue;
                bestMatch = candidate;
                bestMatchHits = matchStats.hits;
            }
        }
        if (bestMatch != null) {
            bestMatch.updateLastAccessTime();
        }
        return bestMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String catName, String dbName, String tblName, String colName, long numPartsCached, ColumnStatisticsObj colStats, BloomFilter bloomFilter) {
        if ((double)(this.getCurrentNodes() / this.maxCacheNodes) > this.maxFull) {
            this.spawnCleaner();
        }
        Key key = new Key(catName, dbName, tblName, colName);
        AggrColStats node = new AggrColStats(numPartsCached, bloomFilter, colStats);
        AggrColStatsList newNodeList = new AggrColStatsList();
        newNodeList.nodes = new ArrayList();
        AggrColStatsList nodeList = this.cacheStore.putIfAbsent(key, newNodeList);
        if (nodeList == null) {
            nodeList = newNodeList;
        }
        boolean isLocked = false;
        try {
            isLocked = nodeList.writeLock.tryLock(this.maxWriterWaitTime, TimeUnit.MILLISECONDS);
            if (isLocked) {
                nodeList.nodes.add(node);
                node.updateLastAccessTime();
                nodeList.updateLastAccessTime();
                this.currentNodes.getAndIncrement();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted Exception ignored ", (Throwable)e);
        }
        finally {
            if (isLocked) {
                nodeList.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnCleaner() {
        AggregateStatsCache aggregateStatsCache = this;
        synchronized (aggregateStatsCache) {
            if (this.isCleaning) {
                return;
            }
            this.isCleaning = true;
        }
        Thread cleaner = new Thread("AggregateStatsCache-CleanerThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AggregateStatsCache.this.numRemovedTTL = 0;
                AggregateStatsCache.this.numRemovedLRU = 0;
                long cleanerStartTime = System.currentTimeMillis();
                LOG.info("AggregateStatsCache is " + AggregateStatsCache.this.getFullPercent() + "% full, with " + AggregateStatsCache.this.getCurrentNodes() + " nodes; starting cleaner thread");
                try {
                    Iterator mapIterator = AggregateStatsCache.this.cacheStore.entrySet().iterator();
                    while (mapIterator.hasNext()) {
                        Map.Entry pair = mapIterator.next();
                        AggrColStatsList candidateList = (AggrColStatsList)pair.getValue();
                        List nodes = candidateList.nodes;
                        if (nodes.size() == 0) {
                            mapIterator.remove();
                            continue;
                        }
                        boolean isLocked = false;
                        try {
                            isLocked = candidateList.writeLock.tryLock(AggregateStatsCache.this.maxWriterWaitTime, TimeUnit.MILLISECONDS);
                            if (isLocked) {
                                Iterator listIterator = nodes.iterator();
                                while (listIterator.hasNext()) {
                                    AggrColStats node = (AggrColStats)listIterator.next();
                                    if (!AggregateStatsCache.this.isExpired(node)) continue;
                                    listIterator.remove();
                                    ++AggregateStatsCache.this.numRemovedTTL;
                                    AggregateStatsCache.this.currentNodes.getAndDecrement();
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.debug("Interrupted Exception ignored ", (Throwable)e);
                        }
                        finally {
                            if (isLocked) {
                                candidateList.writeLock.unlock();
                            }
                        }
                        Thread.yield();
                    }
                    while ((double)(AggregateStatsCache.this.getCurrentNodes() / AggregateStatsCache.this.maxCacheNodes) > AggregateStatsCache.this.cleanUntil) {
                        AggregateStatsCache.this.evictOneNode();
                    }
                }
                finally {
                    AggregateStatsCache.this.isCleaning = false;
                    LOG.info("Stopping cleaner thread; AggregateStatsCache is now " + AggregateStatsCache.this.getFullPercent() + "% full, with " + AggregateStatsCache.this.getCurrentNodes() + " nodes");
                    LOG.info("Number of expired nodes removed: " + AggregateStatsCache.this.numRemovedTTL);
                    LOG.info("Number of LRU nodes removed: " + AggregateStatsCache.this.numRemovedLRU);
                    LOG.info("Cleaner ran for: " + (System.currentTimeMillis() - cleanerStartTime) + "ms");
                }
            }
        };
        cleaner.setPriority(1);
        cleaner.setDaemon(true);
        cleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictOneNode() {
        Key lruKey = null;
        AggrColStatsList lruValue = null;
        for (Map.Entry<Key, AggrColStatsList> entry : this.cacheStore.entrySet()) {
            Key key = entry.getKey();
            AggrColStatsList value = entry.getValue();
            if (lruKey == null) {
                lruKey = key;
                lruValue = value;
                continue;
            }
            if (value.lastAccessTime >= lruValue.lastAccessTime || value.nodes.isEmpty()) continue;
            lruKey = key;
            lruValue = value;
        }
        AggrColStatsList candidateList = this.cacheStore.get(lruKey);
        boolean isLocked = false;
        try {
            isLocked = candidateList.writeLock.tryLock(this.maxWriterWaitTime, TimeUnit.MILLISECONDS);
            if (isLocked) {
                AggrColStats lruNode = null;
                int currentIndex = 0;
                int deleteIndex = 0;
                Iterator iterator = candidateList.nodes.iterator();
                while (iterator.hasNext()) {
                    AggrColStats candidate = (AggrColStats)iterator.next();
                    if (this.isExpired(candidate)) {
                        iterator.remove();
                        this.currentNodes.getAndDecrement();
                        ++this.numRemovedTTL;
                        return;
                    }
                    if (lruNode == null) {
                        lruNode = candidate;
                        ++currentIndex;
                        continue;
                    }
                    if (lruNode == null || candidate.lastAccessTime >= lruNode.lastAccessTime) continue;
                    lruNode = candidate;
                    deleteIndex = currentIndex;
                }
                candidateList.nodes.remove(deleteIndex);
                this.currentNodes.getAndDecrement();
                ++this.numRemovedLRU;
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted Exception ignored ", (Throwable)e);
        }
        finally {
            if (isLocked) {
                candidateList.writeLock.unlock();
            }
        }
    }

    private boolean isExpired(AggrColStats aggrColStats) {
        return System.currentTimeMillis() - aggrColStats.lastAccessTime > this.timeToLiveMs;
    }

    private static class MatchStats {
        private int hits = 0;
        private int misses = 0;

        MatchStats(int hits, int misses) {
            this.hits = hits;
            this.misses = misses;
        }
    }

    public static class AggrColStats {
        private final long numPartsCached;
        private final BloomFilter bloomFilter;
        private final ColumnStatisticsObj colStats;
        private volatile long lastAccessTime;

        public AggrColStats(long numPartsCached, BloomFilter bloomFilter, ColumnStatisticsObj colStats) {
            this.numPartsCached = numPartsCached;
            this.bloomFilter = bloomFilter;
            this.colStats = colStats;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public long getNumPartsCached() {
            return this.numPartsCached;
        }

        public ColumnStatisticsObj getColStats() {
            return this.colStats;
        }

        public BloomFilter getBloomFilter() {
            return this.bloomFilter;
        }

        void updateLastAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    static class AggrColStatsList {
        private List<AggrColStats> nodes = new ArrayList<AggrColStats>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();
        private volatile long lastAccessTime = 0L;

        AggrColStatsList() {
        }

        List<AggrColStats> getNodes() {
            return this.nodes;
        }

        void updateLastAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    static class Key {
        private final String catName;
        private final String dbName;
        private final String tblName;
        private final String colName;

        Key(String cat, String db, String table, String col) {
            if (cat == null || db == null || table == null || col == null) {
                throw new IllegalArgumentException("catName, dbName, tblName, colName can't be null");
            }
            this.catName = cat;
            this.dbName = db;
            this.tblName = table;
            this.colName = col;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Key)) {
                return false;
            }
            Key that = (Key)other;
            return this.catName.equals(that.catName) && this.dbName.equals(that.dbName) && this.tblName.equals(that.tblName) && this.colName.equals(that.colName);
        }

        public int hashCode() {
            return this.catName.hashCode() * 31 + this.dbName.hashCode() * 31 + this.tblName.hashCode() * 31 + this.colName.hashCode();
        }

        public String toString() {
            return "catalog: " + this.catName + ", database:" + this.dbName + ", table:" + this.tblName + ", column:" + this.colName;
        }
    }
}

