/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class AcidEventListener
extends TransactionalMetaStoreEventListener {
    private TxnStore txnHandler;
    private Configuration conf;

    public AcidEventListener(Configuration configuration) {
        super(configuration);
        this.conf = configuration;
    }

    @Override
    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        this.txnHandler = this.getTxnHandler();
        long currentTxn = this.getTxnId(dbEvent.getEnvironmentContext());
        this.txnHandler.cleanupRecords(HiveObjectType.DATABASE, dbEvent.getDatabase(), null, null, currentTxn);
    }

    @Override
    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Table table = tableEvent.getTable();
        if (TxnUtils.isTransactionalTable(table)) {
            long currentTxn;
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.TABLE, null, table, null, !tableEvent.getDeleteData());
            if (!tableEvent.getDeleteData() && (currentTxn = this.getTxnId(tableEvent.getEnvironmentContext())) > 0L) {
                try {
                    CompactionRequest rqst = new CompactionRequest(table.getDbName(), table.getTableName(), CompactionType.MAJOR);
                    rqst.setRunas(TxnUtils.findUserToRunAs(table.getSd().getLocation(), table, this.conf));
                    rqst.putToProperties("location", table.getSd().getLocation());
                    rqst.putToProperties("ifPurge", Boolean.toString(HiveMetaStore.HMSHandler.isMustPurge(tableEvent.getEnvironmentContext(), table)));
                    this.txnHandler.submitForCleanup(rqst, table.getWriteId(), currentTxn);
                }
                catch (IOException | InterruptedException e) {
                    MetaStoreUtils.throwMetaException(e);
                }
            }
        }
    }

    @Override
    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Table table = partitionEvent.getTable();
        EnvironmentContext context = partitionEvent.getEnvironmentContext();
        if (TxnUtils.isTransactionalTable(table)) {
            long currentTxn;
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.PARTITION, null, table, partitionEvent.getPartitionIterator());
            if (!partitionEvent.getDeleteData() && (currentTxn = this.getTxnId(context)) > 0L) {
                long writeId = HiveMetaStore.HMSHandler.getWriteId(context);
                try {
                    CompactionRequest rqst = new CompactionRequest(table.getDbName(), table.getTableName(), CompactionType.MAJOR);
                    rqst.setRunas(TxnUtils.findUserToRunAs(table.getSd().getLocation(), table, this.conf));
                    rqst.putToProperties("ifPurge", Boolean.toString(HiveMetaStore.HMSHandler.isMustPurge(context, table)));
                    Iterator<Partition> partitionIterator = partitionEvent.getPartitionIterator();
                    while (partitionIterator.hasNext()) {
                        Partition p = partitionIterator.next();
                        List<FieldSchema> partCols = partitionEvent.getTable().getPartitionKeys();
                        List<String> partVals = p.getValues();
                        rqst.setPartitionname(Warehouse.makePartName(partCols, partVals));
                        rqst.putToProperties("location", p.getSd().getLocation());
                        this.txnHandler.submitForCleanup(rqst, writeId, currentTxn);
                    }
                }
                catch (IOException | InterruptedException e) {
                    MetaStoreUtils.throwMetaException(e);
                }
            }
        }
    }

    @Override
    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        if (!TxnUtils.isTransactionalTable(tableEvent.getNewTable())) {
            return;
        }
        Table oldTable = tableEvent.getOldTable();
        Table newTable = tableEvent.getNewTable();
        if (!(oldTable.getCatName().equalsIgnoreCase(newTable.getCatName()) && oldTable.getDbName().equalsIgnoreCase(newTable.getDbName()) && oldTable.getTableName().equalsIgnoreCase(newTable.getTableName()))) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(oldTable.getCatName(), oldTable.getDbName(), oldTable.getTableName(), null, newTable.getCatName(), newTable.getDbName(), newTable.getTableName(), null);
        }
    }

    @Override
    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        String newPartName;
        if (!TxnUtils.isTransactionalTable(partitionEvent.getTable())) {
            return;
        }
        Partition oldPart = partitionEvent.getOldPartition();
        Partition newPart = partitionEvent.getNewPartition();
        Table t = partitionEvent.getTable();
        String oldPartName = Warehouse.makePartName(t.getPartitionKeys(), oldPart.getValues());
        if (!oldPartName.equals(newPartName = Warehouse.makePartName(t.getPartitionKeys(), newPart.getValues()))) {
            long currentTxn;
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(t.getCatName(), t.getDbName(), t.getTableName(), oldPartName, t.getCatName(), t.getDbName(), t.getTableName(), newPartName);
            EnvironmentContext context = partitionEvent.getEnvironmentContext();
            Table table = partitionEvent.getTable();
            boolean clonePart = Optional.ofNullable(context).map(EnvironmentContext::getProperties).map(prop -> (String)prop.get("renamePartitionMakeCopy")).map(Boolean::parseBoolean).orElse(false);
            if (clonePart && (currentTxn = this.getTxnId(context)) > 0L) {
                try {
                    CompactionRequest rqst = new CompactionRequest(table.getDbName(), table.getTableName(), CompactionType.MAJOR);
                    rqst.setRunas(TxnUtils.findUserToRunAs(table.getSd().getLocation(), table, this.conf));
                    rqst.setPartitionname(oldPartName);
                    rqst.putToProperties("location", oldPart.getSd().getLocation());
                    rqst.putToProperties("ifPurge", Boolean.toString(HiveMetaStore.HMSHandler.isMustPurge(context, table)));
                    this.txnHandler.submitForCleanup(rqst, partitionEvent.getWriteId(), currentTxn);
                }
                catch (IOException | InterruptedException e) {
                    MetaStoreUtils.throwMetaException(e);
                }
            }
        }
    }

    @Override
    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        if (!oldDb.getCatalogName().equalsIgnoreCase(newDb.getCatalogName()) || !oldDb.getName().equalsIgnoreCase(newDb.getName())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(oldDb.getCatalogName(), oldDb.getName(), null, null, newDb.getCatalogName(), newDb.getName(), null, null);
        }
    }

    private TxnStore getTxnHandler() {
        boolean hackOn = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST);
        String origTxnMgr = null;
        boolean origConcurrency = false;
        if (hackOn) {
            origTxnMgr = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.HIVE_TXN_MANAGER);
            origConcurrency = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        }
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
        if (hackOn) {
            MetastoreConf.setVar(this.conf, MetastoreConf.ConfVars.HIVE_TXN_MANAGER, origTxnMgr);
            MetastoreConf.setBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, origConcurrency);
        }
        return this.txnHandler;
    }

    private long getTxnId(EnvironmentContext context) {
        return Optional.ofNullable(context).map(EnvironmentContext::getProperties).map(prop -> (String)prop.get("txnId")).map(Long::parseLong).orElse(0L);
    }
}

