/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.histogram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.common.histogram.kll.KllUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

public class KllHistogramEstimator {
    private final KllFloatsSketch kll;

    KllHistogramEstimator() {
        this.kll = new KllFloatsSketch();
    }

    KllHistogramEstimator(int k) {
        this.kll = new KllFloatsSketch(k);
    }

    KllHistogramEstimator(KllFloatsSketch kll) {
        this.kll = kll;
    }

    public byte[] serialize() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            KllUtils.serializeKll(bos, this.kll);
            byte[] result = bos.toByteArray();
            bos.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToEstimator(long v) {
        this.kll.update((float)v);
    }

    public void addToEstimator(double d) {
        this.kll.update((float)d);
    }

    public void addToEstimator(HiveDecimal decimal) {
        this.kll.update(decimal.floatValue());
    }

    public void mergeEstimators(KllHistogramEstimator o) {
        this.kll.merge(o.kll);
    }

    public int lengthFor(JavaDataModel model) {
        return KllUtils.lengthFor(model, this.kll);
    }

    public boolean canMerge(KllHistogramEstimator o) {
        return o != null && this.kll.getK() == o.kll.getK();
    }

    public int getK() {
        return this.kll.getK();
    }

    public KllFloatsSketch getSketch() {
        return this.kll;
    }
}

