/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import java.sql.ResultSet;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbySQLConnectorProvider
extends AbstractJDBCConnectorProvider {
    private static Logger LOG = LoggerFactory.getLogger(DerbySQLConnectorProvider.class);
    private static final String DRIVER_CLASS = "org.apache.derby.jdbc.AutoloadedDriver".intern();

    public DerbySQLConnectorProvider(String dbName, DataConnector connector) {
        super(dbName, connector, DRIVER_CLASS);
    }

    @Override
    public ResultSet fetchTableMetadata(String tableName) throws MetaException {
        return null;
    }

    @Override
    protected String getCatalogName() {
        return this.scoped_db;
    }

    @Override
    protected String getDatabaseName() {
        return null;
    }

    @Override
    protected String getDataType(String dbDataType, int size) {
        String mappedType = super.getDataType(dbDataType, size);
        if (!mappedType.equalsIgnoreCase("void")) {
            return mappedType;
        }
        switch (dbDataType.toLowerCase()) {
            case "integer": {
                mappedType = "int";
                break;
            }
            case "long varchar": {
                mappedType = "string";
                break;
            }
            default: {
                mappedType = "void";
            }
        }
        return mappedType;
    }
}

