/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestTxnDbUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestTxnDbUtil.class.getName());
    private static final String TXN_MANAGER = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
    private static int deadlockCnt = 0;

    private TestTxnDbUtil() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static void setConfValues(Configuration conf) {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_TXN_MANAGER, (String)TXN_MANAGER);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void prepDb(Configuration conf) throws Exception {
        DatabaseProduct dbProduct;
        Statement stmt;
        Connection conn;
        block14: {
            LOG.info("Creating transactional tables");
            conn = null;
            stmt = null;
            conn = TestTxnDbUtil.getConnection(conf);
            String s = conn.getMetaData().getDatabaseProductName();
            dbProduct = DatabaseProduct.determineDatabaseProduct((String)s, (Configuration)conf);
            stmt = conn.createStatement();
            if (!TestTxnDbUtil.checkDbPrepared(stmt)) break block14;
            deadlockCnt = 0;
            TestTxnDbUtil.closeResources(conn, stmt, null);
            return;
        }
        try {
            String schemaRootPath = TestTxnDbUtil.getSchemaRootPath();
            IMetaStoreSchemaInfo metaStoreSchemaInfo = MetaStoreSchemaInfoFactory.get((Configuration)conf, (String)schemaRootPath, (String)dbProduct.getHiveSchemaPostfix());
            String initFile = metaStoreSchemaInfo.generateInitFileName(null);
            try (FileInputStream is = new FileInputStream(metaStoreSchemaInfo.getMetaStoreScriptDir() + File.separator + initFile);){
                LOG.info("Reinitializing the metastore db with {} on the database {}", (Object)initFile, (Object)MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY));
                TestTxnDbUtil.importSQL(stmt, is);
            }
            deadlockCnt = 0;
        }
        catch (SQLException e) {
            try {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (SQLException re) {
                    LOG.error("Error rolling back: " + re.getMessage());
                }
                if (!(e instanceof SQLTransactionRollbackException) || deadlockCnt++ >= 5) {
                    throw e;
                }
                LOG.warn("Caught deadlock, retrying db creation");
                TestTxnDbUtil.prepDb(conf);
                deadlockCnt = 0;
            }
            catch (Throwable throwable) {
                deadlockCnt = 0;
                TestTxnDbUtil.closeResources(conn, stmt, null);
                throw throwable;
            }
            TestTxnDbUtil.closeResources(conn, stmt, null);
        }
        TestTxnDbUtil.closeResources(conn, stmt, null);
    }

    private static boolean checkDbPrepared(Statement stmt) {
        try {
            stmt.execute("SELECT * FROM \"TXNS\"");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private static void importSQL(Statement stmt, InputStream in) throws SQLException {
        Set<String> knownErrors = TestTxnDbUtil.getAlreadyExistsErrorCodes();
        Scanner s = new Scanner(in, "UTF-8");
        s.useDelimiter("(;(\r)?\n)|(--.*\n)");
        while (s.hasNext()) {
            String line = s.next();
            if (line.trim().length() <= 0) continue;
            try {
                stmt.execute(line);
            }
            catch (SQLException e) {
                if (knownErrors.contains(e.getSQLState())) {
                    LOG.debug("Ignoring sql error {}", (Object)e.getMessage());
                    continue;
                }
                throw e;
            }
        }
    }

    private static Set<String> getAlreadyExistsErrorCodes() {
        HashSet<String> knownErrors = new HashSet<String>();
        knownErrors.addAll(Arrays.asList("X0Y68", "X0Y32", "X0Y44", "42Z93", "23505"));
        knownErrors.addAll(Arrays.asList("42P07", "42P16", "42710"));
        knownErrors.addAll(Arrays.asList("S0000", "S0001", "23000"));
        knownErrors.addAll(Arrays.asList("42S01", "HY000"));
        knownErrors.addAll(Arrays.asList("42000"));
        return knownErrors;
    }

    private static Set<String> getTableNotExistsErrorCodes() {
        HashSet<String> knownErrors = new HashSet<String>();
        knownErrors.addAll(Arrays.asList("42X05", "42P01", "42S02", "S0002", "42000"));
        return knownErrors;
    }

    private static String getSchemaRootPath() {
        String hiveRoot = System.getProperty("hive.root");
        if (StringUtils.isNotEmpty((CharSequence)hiveRoot)) {
            return TestTxnDbUtil.ensurePathEndsInSlash(hiveRoot) + "standalone-metastore/metastore-server/target/tmp/";
        }
        return TestTxnDbUtil.ensurePathEndsInSlash(System.getProperty("test.tmp.dir", "target/tmp"));
    }

    private static String ensurePathEndsInSlash(String path) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null");
        }
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanDb(Configuration conf) throws Exception {
        LOG.info("Cleaning transactional tables");
        boolean success = true;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = TestTxnDbUtil.getConnection(conf);
            stmt = conn.createStatement();
            if (!TestTxnDbUtil.checkDbPrepared(stmt)) {
                return;
            }
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "TXN_COMPONENTS");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "COMPLETED_TXN_COMPONENTS");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "MIN_HISTORY_WRITE_ID");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "TXNS");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "TXN_TO_WRITE_ID");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "NEXT_WRITE_ID");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "HIVE_LOCKS");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "NEXT_LOCK_ID");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "COMPACTION_QUEUE");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "NEXT_COMPACTION_QUEUE_ID");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "COMPLETED_COMPACTIONS");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "AUX_TABLE");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "WRITE_SET");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "REPL_TXN_MAP");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "MATERIALIZATION_REBUILD_LOCKS");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "MIN_HISTORY_LEVEL");
            success &= TestTxnDbUtil.truncateTable(conn, conf, stmt, "COMPACTION_METRICS_CACHE");
            try {
                String dbProduct = conn.getMetaData().getDatabaseProductName();
                DatabaseProduct databaseProduct = DatabaseProduct.determineDatabaseProduct((String)dbProduct, (Configuration)conf);
                try {
                    TestTxnDbUtil.resetTxnSequence(databaseProduct, stmt);
                    stmt.executeUpdate("INSERT INTO \"NEXT_LOCK_ID\" VALUES(1)");
                    stmt.executeUpdate("INSERT INTO \"NEXT_COMPACTION_QUEUE_ID\" VALUES(1)");
                }
                catch (SQLException e) {
                    if (!databaseProduct.isTableNotExistsError((Throwable)e)) {
                        LOG.error("Error initializing sequence values", (Throwable)e);
                        throw e;
                    }
                }
            }
            catch (SQLException e) {
                LOG.error("Unable determine database product ", (Throwable)e);
                throw e;
            }
        }
        finally {
            TestTxnDbUtil.closeResources(conn, stmt, null);
        }
        if (success) {
            return;
        }
        throw new RuntimeException("Failed to clean up txn tables");
    }

    private static void resetTxnSequence(DatabaseProduct databaseProduct, Statement stmt) throws SQLException {
        for (String s : databaseProduct.getResetTxnSequenceStmts()) {
            stmt.execute(s);
        }
    }

    private static boolean truncateTable(Connection conn, Configuration conf, Statement stmt, String name) throws SQLException {
        String dbProduct = conn.getMetaData().getDatabaseProductName();
        DatabaseProduct databaseProduct = DatabaseProduct.determineDatabaseProduct((String)dbProduct, (Configuration)conf);
        try {
            String s = databaseProduct.getTruncateStatement(name);
            stmt.execute(s);
            LOG.debug("Successfully truncated table " + name);
            return true;
        }
        catch (SQLException e) {
            if (databaseProduct.isTableNotExistsError((Throwable)e)) {
                LOG.debug("Not truncating " + name + " because it doesn't exist");
                return true;
            }
            LOG.error("Unable to truncate table " + name, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLockComponents(Configuration conf, long lockId) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = TestTxnDbUtil.getConnection(conf);
                stmt = conn.prepareStatement("SELECT count(*) FROM hive_locks WHERE hl_lock_ext_id = ?");
                stmt.setLong(1, lockId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                TestTxnDbUtil.closeResources(conn, stmt, rs);
                throw throwable;
            }
            TestTxnDbUtil.closeResources(conn, stmt, rs);
            return n;
        }
        int n = rs.getInt(1);
        TestTxnDbUtil.closeResources(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countQueryAgent(Configuration conf, String countQuery) throws Exception {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = TestTxnDbUtil.getConnection(conf);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(countQuery);
                if (rs.next()) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                TestTxnDbUtil.closeResources(conn, stmt, rs);
                throw throwable;
            }
            TestTxnDbUtil.closeResources(conn, stmt, rs);
            return n;
        }
        int n = rs.getInt(1);
        TestTxnDbUtil.closeResources(conn, stmt, rs);
        return n;
    }

    public static String queryToString(Configuration conf, String query) throws Exception {
        return TestTxnDbUtil.queryToString(conf, query, true);
    }

    public static String queryToString(Configuration conf, String query, boolean includeHeader) throws Exception {
        return TestTxnDbUtil.queryToString(conf, query, includeHeader, "   ");
    }

    public static String queryToCsv(Configuration conf, String query) throws Exception {
        return TestTxnDbUtil.queryToString(conf, query, true, ",");
    }

    public static String queryToCsv(Configuration conf, String query, boolean includeHeader) throws Exception {
        return TestTxnDbUtil.queryToString(conf, query, includeHeader, ",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryToString(Configuration conf, String query, boolean includeHeader, String columnSeparator) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder();
        try {
            int colPos;
            conn = TestTxnDbUtil.getConnection(conf);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            if (includeHeader) {
                for (colPos = 1; colPos <= rsmd.getColumnCount(); ++colPos) {
                    sb.append(rsmd.getColumnName(colPos)).append(columnSeparator);
                }
                sb.append('\n');
            }
            while (rs.next()) {
                for (colPos = 1; colPos <= rsmd.getColumnCount(); ++colPos) {
                    sb.append(rs.getObject(colPos)).append(columnSeparator);
                }
                sb.append('\n');
            }
        }
        catch (Throwable throwable) {
            TestTxnDbUtil.closeResources(conn, stmt, rs);
            throw throwable;
        }
        TestTxnDbUtil.closeResources(conn, stmt, rs);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdate(Configuration conf, String query) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = TestTxnDbUtil.getConnection(conf);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        finally {
            TestTxnDbUtil.closeResources(conn, stmt, null);
        }
    }

    public static Connection getConnection(Configuration conf) throws Exception {
        String jdbcDriver = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER);
        Driver driver = (Driver)Class.forName(jdbcDriver).newInstance();
        Properties prop = new Properties();
        String driverUrl = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        String user = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME);
        String passwd = MetastoreConf.getPassword((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD);
        prop.setProperty("user", user);
        prop.setProperty("password", passwd);
        Connection conn = driver.connect(driverUrl, prop);
        conn.setAutoCommit(true);
        DatabaseProduct dbProduct = DatabaseProduct.determineDatabaseProduct((String)conn.getMetaData().getDatabaseProductName(), (Configuration)conf);
        String initSql = dbProduct.getPrepareTxnStmt();
        if (initSql != null) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(initSql);
            }
        }
        return conn;
    }

    public static void closeResources(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.error("Error closing ResultSet: " + e.getMessage());
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing Statement: " + e.getMessage());
            }
        }
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                System.err.println("Error rolling back: " + e.getMessage());
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing Connection: " + e.getMessage());
            }
        }
    }

    public static ShowLocksResponseElement checkLock(LockType expectedType, LockState expectedState, String expectedDb, String expectedTable, String expectedPartition, List<ShowLocksResponseElement> actuals) {
        return TestTxnDbUtil.checkLock(expectedType, expectedState, expectedDb, expectedTable, expectedPartition, actuals, false);
    }

    public static ShowLocksResponseElement checkLock(LockType expectedType, LockState expectedState, String expectedDb, String expectedTable, String expectedPartition, List<ShowLocksResponseElement> actuals, boolean skipFirst) {
        boolean skip = skipFirst;
        for (ShowLocksResponseElement actual : actuals) {
            if (expectedType != actual.getType() || expectedState != actual.getState() || !StringUtils.equals((CharSequence)TestTxnDbUtil.normalizeCase(expectedDb), (CharSequence)TestTxnDbUtil.normalizeCase(actual.getDbname())) || !StringUtils.equals((CharSequence)TestTxnDbUtil.normalizeCase(expectedTable), (CharSequence)TestTxnDbUtil.normalizeCase(actual.getTablename())) || !StringUtils.equals((CharSequence)TestTxnDbUtil.normalizeCase(expectedPartition), (CharSequence)TestTxnDbUtil.normalizeCase(actual.getPartname()))) continue;
            if (!skip) {
                return actual;
            }
            skip = false;
        }
        Assert.fail((String)("Could't find {" + expectedType + ", " + expectedState + ", " + expectedDb + ", " + expectedTable + ", " + expectedPartition + "} in " + actuals));
        throw new IllegalStateException("How did it get here?!");
    }

    private static String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }
}

