/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestStringableMap {
    @Test
    public void stringableMap() throws Exception {
        StringableMap m = new StringableMap(new HashMap());
        String s = m.toString();
        Assert.assertEquals((Object)"0:", (Object)s);
        m = new StringableMap(s);
        Assert.assertEquals((long)0L, (long)m.size());
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("mary", "poppins");
        base.put("bert", null);
        base.put(null, "banks");
        m = new StringableMap(base);
        s = m.toString();
        m = new StringableMap(s);
        Assert.assertEquals((long)3L, (long)m.size());
        HashMap<String, Boolean> saw = new HashMap<String, Boolean>(3);
        saw.put("mary", false);
        saw.put("bert", false);
        saw.put(null, false);
        for (Map.Entry e : m.entrySet()) {
            saw.put((String)e.getKey(), true);
            if ("mary".equals(e.getKey())) {
                Assert.assertEquals((Object)"poppins", e.getValue());
                continue;
            }
            if ("bert".equals(e.getKey())) {
                Assert.assertNull(e.getValue());
                continue;
            }
            if (null == e.getKey()) {
                Assert.assertEquals((Object)"banks", e.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected value " + (String)e.getKey()));
        }
        Assert.assertEquals((long)3L, (long)saw.size());
        Assert.assertTrue((boolean)((Boolean)saw.get("mary")));
        Assert.assertTrue((boolean)((Boolean)saw.get("bert")));
        Assert.assertTrue((boolean)((Boolean)saw.get(null)));
    }
}

