/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.retry;

import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestSqlRetryHandler {
    @Test
    public void testRetryableRegex() {
        HiveConf conf = new HiveConf();
        SQLException sqlException = new SQLException("ORA-08177: can't serialize access for this transaction", "72000");
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_RETRYABLE_SQLEX_REGEX, "^Deadlock detected, roll back,.*08177.*,.*08178.*");
        boolean result = SqlRetryHandler.isRetryable((Configuration)conf, (Exception)sqlException);
        Assert.assertTrue((String)"regex should be retryable", (boolean)result);
        sqlException = new SQLException("This error message, has comma in it");
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_RETRYABLE_SQLEX_REGEX, ".*comma.*");
        result = SqlRetryHandler.isRetryable((Configuration)conf, (Exception)sqlException);
        Assert.assertTrue((String)"regex should be retryable", (boolean)result);
    }
}

