/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOpenTxn {
    private Configuration conf = MetastoreConf.newMetastoreConf();
    private TxnStore txnHandler;

    @Before
    public void setUp() throws Exception {
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
        TestTxnDbUtil.prepDb(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb(this.conf);
    }

    @Test
    public void testSingleOpen() throws MetaException {
        OpenTxnRequest openTxnRequest = new OpenTxnRequest(1, "me", "localhost");
        long txnId = (Long)this.txnHandler.openTxns(openTxnRequest).getTxn_ids().get(0);
        Assert.assertEquals((long)1L, (long)txnId);
    }

    @Test
    public void testGap() throws Exception {
        OpenTxnRequest openTxnRequest = new OpenTxnRequest(1, "me", "localhost");
        this.txnHandler.openTxns(openTxnRequest);
        long second = (Long)this.txnHandler.openTxns(openTxnRequest).getTxn_ids().get(0);
        this.deleteTransaction(second);
        this.txnHandler.openTxns(openTxnRequest);
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)3L, (long)openTxns.getOpen_txnsSize());
    }

    @Test
    public void testGapWithOldOpen() throws Exception {
        OpenTxnRequest openTxnRequest = new OpenTxnRequest(1, "me", "localhost");
        this.txnHandler.openTxns(openTxnRequest);
        Thread.sleep(1000L);
        long second = (Long)this.txnHandler.openTxns(openTxnRequest).getTxn_ids().get(0);
        this.deleteTransaction(second);
        this.txnHandler.openTxns(openTxnRequest);
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)3L, (long)openTxns.getOpen_txnsSize());
    }

    @Test
    public void testGapWithOldCommit() throws Exception {
        OpenTxnRequest openTxnRequest = new OpenTxnRequest(1, "me", "localhost");
        long first = (Long)this.txnHandler.openTxns(openTxnRequest).getTxn_ids().get(0);
        this.txnHandler.commitTxn(new CommitTxnRequest(first));
        long second = (Long)this.txnHandler.openTxns(openTxnRequest).getTxn_ids().get(0);
        this.deleteTransaction(second);
        this.txnHandler.openTxns(openTxnRequest);
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)2L, (long)openTxns.getOpen_txnsSize());
    }

    @Test
    public void testMultiGapWithOldCommit() throws Exception {
        OpenTxnRequest openTxnRequest = new OpenTxnRequest(1, "me", "localhost");
        long first = (Long)this.txnHandler.openTxns(openTxnRequest).getTxn_ids().get(0);
        this.txnHandler.commitTxn(new CommitTxnRequest(first));
        long second = (Long)this.txnHandler.openTxns(new OpenTxnRequest(10, "me", "localhost")).getTxn_ids().get(0);
        this.deleteTransaction(second, second + 9L);
        this.txnHandler.openTxns(openTxnRequest);
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)11L, (long)openTxns.getOpen_txnsSize());
    }

    private void deleteTransaction(long txnId) throws SQLException {
        this.deleteTransaction(txnId, txnId);
    }

    private void deleteTransaction(long minTxnId, long maxTxnId) throws SQLException {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        DataSource ds = dsp.create(this.conf);
        Connection dbConn = ds.getConnection();
        Statement stmt = dbConn.createStatement();
        stmt.executeUpdate("DELETE FROM TXNS WHERE TXN_ID >=" + minTxnId + " AND TXN_ID <=" + maxTxnId);
        dbConn.commit();
        stmt.close();
        dbConn.close();
    }
}

