/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Derby;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Mariadb;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Mssql;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Mysql;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Oracle;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Postgres;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskInit;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskUpgrade;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskValidate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MetastoreCheckinTest.class})
@RunWith(value=Parameterized.class)
public class TestSchemaToolForMetastore {
    private static final Pattern IDENTIFIER = Pattern.compile("[A-Z_]+");
    private MetastoreSchemaTool schemaTool;
    private Connection conn;
    private Configuration conf;
    private final DatabaseRule dbms;
    private PrintStream errStream;
    private PrintStream outStream;
    private SchemaToolTaskValidate validator;

    public TestSchemaToolForMetastore(DatabaseRule dbms) {
        this.dbms = dbms;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> databases() {
        ArrayList<Object[]> dbs = new ArrayList<Object[]>();
        dbs.add(new Object[]{new Derby(true)});
        dbs.add(new Object[]{new Mysql()});
        dbs.add(new Object[]{new Oracle()});
        dbs.add(new Object[]{new Postgres()});
        dbs.add(new Object[]{new Mariadb()});
        dbs.add(new Object[]{new Mssql()});
        return dbs;
    }

    @Before
    public void setUp() throws Exception {
        this.dbms.before();
        this.dbms.createUser();
        this.conf = MetastoreConf.newMetastoreConf();
        this.schemaTool = new MetastoreSchemaTool();
        this.schemaTool.init(System.getProperty("test.tmp.dir", "target/tmp"), new String[]{"-dbType", this.dbms.getDbType(), "--info"}, null, this.conf);
        this.schemaTool.setUserName(this.dbms.getHiveUser());
        this.schemaTool.setPassWord(this.dbms.getHivePassword());
        this.schemaTool.setUrl(this.dbms.getJdbcUrl());
        this.schemaTool.setDriver(this.dbms.getJdbcDriver());
        System.setProperty("beeLine.system.exit", "true");
        this.errStream = System.err;
        this.outStream = System.out;
        this.conn = this.schemaTool.getConnectionToMetastore(false);
        this.validator = new SchemaToolTaskValidate();
        this.validator.setHiveSchemaTool(this.schemaTool);
    }

    @After
    public void tearDown() throws IOException, SQLException {
        System.setOut(this.outStream);
        System.setErr(this.errStream);
        if (this.conn != null) {
            this.conn.close();
        }
        this.dbms.after();
    }

    @Test
    public void testValidateSequences() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchema");
        boolean isValid = this.validator.validateSequences(this.conn);
        Assert.assertTrue((boolean)isValid);
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String[] scripts = new String[]{"insert into CTLGS values(99, 'test_cat_1', 'description', 'hdfs://myhost.com:8020/user/hive/warehouse/mydb', " + time + ");", "insert into SEQUENCE_TABLE values('org.apache.hadoop.hive.metastore.model.MDatabase', 100);", "insert into DBS values(99, 'test db1', 'hdfs:///tmp/ext', 'db1', 'test', 'test', 'test_cat_1', " + time + ", 'hdfs:///tmp/mgd', 'NATIVE', '', '');"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSequences(this.conn);
        Assert.assertTrue((boolean)isValid);
        scripts = new String[]{"delete from SEQUENCE_TABLE;", "delete from DBS;", "insert into SEQUENCE_TABLE values('org.apache.hadoop.hive.metastore.model.MDatabase', 100);", "insert into DBS values(102, 'test db1', 'hdfs:///tmp/ext', 'db1', 'test', 'test', 'test_cat_1', " + time + ", 'hdfs:///tmp/mgd', 'NATIVE', '', '');"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSequences(this.conn);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testValidateSchemaTables() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 1.2.0");
        boolean isValid = this.validator.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        this.execute((SchemaToolTask)new SchemaToolTaskUpgrade(), "-upgradeSchemaFrom 1.2.0");
        isValid = this.validator.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        HashMap<String, String> tblRenames = new HashMap<String, String>();
        tblRenames.put("SEQUENCE_TABLE", "SEQUENCE_TABLE_RENAMED");
        if (!this.dbms.getDbType().equals("mssql")) {
            tblRenames.put("NUCLEUS_TABLES", "NUCLEUS_TABLES_RENAMED");
        }
        String[] deleteScripts = new String[tblRenames.size()];
        String[] restoreScripts = new String[tblRenames.size()];
        int i = 0;
        for (Map.Entry namePair : tblRenames.entrySet()) {
            deleteScripts[i] = this.renameTableStmt((String)namePair.getKey(), (String)namePair.getValue());
            restoreScripts[i] = this.renameTableStmt((String)namePair.getValue(), (String)namePair.getKey());
            ++i;
        }
        File scriptFile = this.generateTestScript(deleteScripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSchemaTables(this.conn);
        Assert.assertFalse((boolean)isValid);
        scriptFile = this.generateTestScript(restoreScripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        try {
            BadMetaDataConnection bad = new BadMetaDataConnection(this.conn);
            this.validator.validateSchemaTables((Connection)((Object)bad));
            Assert.fail((String)"did not get expected exception");
        }
        catch (HiveMetaException hme) {
            String message = hme.getMessage();
            Assert.assertTrue((String)("Bad HiveMetaException message :" + message), (boolean)message.contains("Failed to retrieve schema tables from Hive Metastore DB"));
            Throwable cause = hme.getCause();
            Assert.assertNotNull((String)"HiveMetaException did not contain a cause", (Object)cause);
            String causeMessage = cause.getMessage();
            Assert.assertTrue((String)("Bad SQLException message: " + causeMessage), (boolean)causeMessage.contains("fault injected"));
        }
    }

    @Test
    public void testValidateNullValues() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchema");
        boolean isValid = this.validator.validateColumnNullValues(this.conn);
        Assert.assertTrue((boolean)isValid);
        this.createTestHiveTableSchemas();
        isValid = this.validator.validateColumnNullValues(this.conn);
        String[] scripts = new String[]{"update TBLS set SD_ID=null"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateColumnNullValues(this.conn);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testSchemaInitDryRun() throws Exception {
        this.schemaTool.setDryRun(true);
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 1.2.0");
        this.schemaTool.setDryRun(false);
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            return;
        }
        Assert.fail((String)"Dry run shouldn't create actual metastore");
    }

    @Test
    public void testSchemaUpgradeDryRun() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 1.2.0");
        this.schemaTool.setDryRun(true);
        this.execute((SchemaToolTask)new SchemaToolTaskUpgrade(), "-upgradeSchemaFrom 1.2.0");
        this.schemaTool.setDryRun(false);
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            return;
        }
        Assert.fail((String)"Dry run shouldn't upgrade metastore schema");
    }

    @Test
    public void testSchemaInit() throws Exception {
        IMetaStoreSchemaInfo metastoreSchemaInfo = MetaStoreSchemaInfoFactory.get((Configuration)this.conf, (String)System.getProperty("test.tmp.dir", "target/tmp"), (String)this.dbms.getDbType());
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo " + metastoreSchemaInfo.getHiveSchemaVersion());
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testSchemaInitOrUgrade1() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initOrUpgradeSchema");
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testSchemaInitOrUgrade2() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 1.2.0");
        this.schemaTool.setDryRun(true);
        this.execute((SchemaToolTask)new SchemaToolTaskUpgrade(), "-initOrUpgradeSchema");
        this.schemaTool.setDryRun(false);
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            return;
        }
        Assert.fail((String)"Dry run shouldn't upgrade metastore schema");
    }

    @Test
    public void testValidateSchemaVersions() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchema");
        boolean isValid = this.validator.validateSchemaVersions();
        String[] scripts = new String[]{"insert into VERSION values(100, '2.2.0', 'Hive release version 2.2.0')"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSchemaVersions();
        Assert.assertFalse((boolean)isValid);
        scripts = new String[]{"delete from VERSION where VER_ID = 100"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSchemaVersions();
        Assert.assertTrue((boolean)isValid);
        scripts = new String[]{"delete from VERSION"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateSchemaVersions();
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testSchemaUpgrade() throws Exception {
        boolean foundException = false;
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 1.2.0");
        try {
            this.schemaTool.verifySchemaVersion();
        }
        catch (HiveMetaException e) {
            foundException = true;
        }
        if (!foundException) {
            throw new Exception("Hive operations shouldn't pass with older version schema");
        }
        String db = this.dbms.getDbType();
        String invalidPreUpgradeScript = this.writeDummyPreUpgradeScript(0, "upgrade-2.3.0-to-3.0.0." + db + ".sql", "foo bar;");
        String validPreUpgradeScript0 = this.writeDummyPreUpgradeScript(1, "upgrade-2.3.0-to-3.0.0." + db + ".sql", "CREATE TABLE schema_test0 (id integer);");
        String validPreUpgradeScript1 = this.writeDummyPreUpgradeScript(2, "upgrade-2.3.0-to-3.0.0." + db + ".sql", "CREATE TABLE schema_test1 (id integer);");
        this.schemaTool.setVerbose(true);
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        PrintStream errPrintStream = new PrintStream(stderr);
        System.setErr(errPrintStream);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        PrintStream outPrintStream = new PrintStream(stdout);
        System.setOut(outPrintStream);
        this.execute((SchemaToolTask)new SchemaToolTaskUpgrade(), "-upgradeSchemaFrom 1.2.0");
        Assert.assertTrue((boolean)((Object)stderr).toString().contains(invalidPreUpgradeScript));
        Assert.assertTrue((boolean)((Object)stderr).toString().contains("foo"));
        Assert.assertFalse((boolean)((Object)stderr).toString().contains(validPreUpgradeScript0));
        Assert.assertFalse((boolean)((Object)stderr).toString().contains(validPreUpgradeScript1));
        Assert.assertTrue((boolean)((Object)stdout).toString().contains(validPreUpgradeScript0));
        Assert.assertTrue((boolean)((Object)stdout).toString().contains(validPreUpgradeScript1));
        this.schemaTool.verifySchemaVersion();
    }

    @Test
    public void testValidateLocations() throws Exception {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchema");
        URI defaultRoot = new URI("hdfs://myhost.com:8020");
        URI defaultRoot2 = new URI("s3://myhost2.com:8888");
        boolean isValid = this.validator.validateLocations(this.conn, null);
        Assert.assertTrue((boolean)isValid);
        isValid = this.validator.validateLocations(this.conn, new URI[]{defaultRoot, defaultRoot2});
        Assert.assertTrue((boolean)isValid);
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String[] scripts = new String[]{"insert into CTLGS values(3, 'test_cat_2', 'description', 'hdfs://myhost.com:8020/user/hive/warehouse/mydb', " + time + ");", "insert into DBS values(2, 'my db', 'hdfs://myhost.com:8020/user/hive/warehouse/mydb', 'mydb', 'public', 'role', 'test_cat_2', " + time + ", '', 'NATIVE', '', '');", "insert into DBS values(7, 'db with bad port', 'hdfs://myhost.com:8020/', 'haDB', 'public', 'role', 'test_cat_2', " + time + ", '', 'NATIVE', '', '');", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (1,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (2,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/admin/2015_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (3,null,'org.apache.hadoop.mapred.TextInputFormat','N','N',null,-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (2 ,1435255431,2,0 ,'hive',0,1,'mytal','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (3 ,1435255431,2,0 ,'hive',0,3,'myView','VIRTUAL_VIEW','select a.col1,a.col2 from foo','select * from foo','n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4012 ,1435255431,7,0 ,'hive',0,4000,'mytal4012','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(1, 1441402388,0, 'd1=1/d2=1',2,2);", "insert into SKEWED_STRING_LIST values(1);", "insert into SKEWED_STRING_LIST values(2);", "insert into SKEWED_COL_VALUE_LOC_MAP values(1,1,'hdfs://myhost.com:8020/user/hive/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');", "insert into SKEWED_COL_VALUE_LOC_MAP values(2,2,'s3://myhost.com:8020/user/hive/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateLocations(this.conn, null);
        Assert.assertTrue((boolean)isValid);
        isValid = this.validator.validateLocations(this.conn, new URI[]{defaultRoot, defaultRoot2});
        Assert.assertTrue((boolean)isValid);
        scripts = new String[]{"delete from SKEWED_COL_VALUE_LOC_MAP;", "delete from SKEWED_STRING_LIST;", "delete from PARTITIONS;", "delete from TBLS;", "delete from SDS;", "delete from DBS;", "insert into DBS values(2, 'my db', '/user/hive/warehouse/mydb', 'mydb', 'public', 'role', 'test_cat_2', " + time + ", '', 'NATIVE', '', '');", "insert into DBS values(4, 'my db2', 'hdfs://myhost.com:8020', '', 'public', 'role', 'test_cat_2', " + time + ", '', 'NATIVE', '', '');", "insert into DBS values(6, 'db with bad port', 'hdfs://myhost.com:8020:', 'zDB', 'public', 'role', 'test_cat_2', " + time + ", '', 'NATIVE', '', '');", "insert into DBS values(7, 'db with bad port', 'hdfs://mynameservice.com/', 'haDB', 'public', 'role', 'test_cat_2', " + time + ", '', 'NATIVE', '', '');", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (1,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://yourhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (2,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','file:///user/admin/2015_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (2 ,1435255431,2,0 ,'hive',0,1,'mytal','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(1, 1441402388,0, 'd1=1/d2=1',2,2);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (3000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','yourhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4001,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4003,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4004,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (4002,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (5000,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','file:///user/admin/2016_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (3000 ,1435255431,2,0 ,'hive',0,3000,'mytal3000','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4011 ,1435255431,4,0 ,'hive',0,4001,'mytal4011','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4012 ,1435255431,4,0 ,'hive',0,4002,'','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4013 ,1435255431,4,0 ,'hive',0,4003,'mytal4013','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (4014 ,1435255431,2,0 ,'hive',0,4003,'','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4001, 1441402388,0, 'd1=1/d2=4001',4001,4011);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4002, 1441402388,0, 'd1=1/d2=4002',4002,4012);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4003, 1441402388,0, 'd1=1/d2=4003',4003,4013);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(4004, 1441402388,0, 'd1=1/d2=4004',4004,4014);", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(5000, 1441402388,0, 'd1=1/d2=5000',5000,2);", "insert into SKEWED_STRING_LIST values(1);", "insert into SKEWED_STRING_LIST values(2);", "insert into SKEWED_COL_VALUE_LOC_MAP values(1,1,'hdfs://yourhost.com:8020/user/hive/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');", "insert into SKEWED_COL_VALUE_LOC_MAP values(2,2,'file:///user/admin/warehouse/mytal/HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME/');"};
        scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
        isValid = this.validator.validateLocations(this.conn, null);
        Assert.assertFalse((boolean)isValid);
        isValid = this.validator.validateLocations(this.conn, new URI[]{defaultRoot, defaultRoot2});
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testHiveMetastoreDbPropertiesTable() throws HiveMetaException, IOException {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 3.0.0");
        this.validateMetastoreDbPropertiesTable();
    }

    @Test
    public void testMetastoreDbPropertiesAfterUpgrade() throws HiveMetaException, IOException {
        this.execute((SchemaToolTask)new SchemaToolTaskInit(), "-initSchemaTo 1.2.0");
        this.execute((SchemaToolTask)new SchemaToolTaskUpgrade(), "-upgradeSchema");
        this.validateMetastoreDbPropertiesTable();
    }

    private File generateTestScript(String[] stmts) throws IOException {
        File testScriptFile = File.createTempFile("schematest", ".sql");
        testScriptFile.deleteOnExit();
        FileWriter fstream = new FileWriter(testScriptFile.getPath());
        BufferedWriter out = new BufferedWriter(fstream);
        for (String line : stmts) {
            line = this.quoteIdentifiers(line);
            line = line.replaceAll("'[Nn]'", this.booleanFalse());
            out.write(line);
            out.newLine();
        }
        out.close();
        return testScriptFile;
    }

    private String quoteIdentifiers(String line) {
        if (!this.dbms.getDbType().equalsIgnoreCase("postgres")) {
            return line;
        }
        String idWithQuote = "\"$0\"";
        String[] part = line.split("values");
        if (part.length == 2) {
            return IDENTIFIER.matcher(part[0]).replaceAll(idWithQuote) + " values " + part[1];
        }
        return IDENTIFIER.matcher(line).replaceAll(idWithQuote);
    }

    private String booleanFalse() {
        switch (this.dbms.getDbType()) {
            case "derby": {
                return "'N'";
            }
            case "postgres": {
                return "'0'";
            }
        }
        return "0";
    }

    private String renameTableStmt(String oldName, String newName) {
        switch (this.dbms.getDbType()) {
            case "mssql": {
                return String.format("exec sp_rename '%s', '%s';", oldName, newName);
            }
            case "postgres": 
            case "oracle": {
                return String.format("alter table %s rename to %s;", oldName, newName);
            }
        }
        return String.format("rename table %s to %s;", oldName, newName);
    }

    private void validateMetastoreDbPropertiesTable() throws HiveMetaException, IOException {
        boolean isValid = this.validator.validateSchemaTables(this.conn);
        Assert.assertTrue((boolean)isValid);
        String[] scripts = new String[]{"insert into METASTORE_DB_PROPERTIES values ('guid', 'test-uuid-1', 'dummy uuid 1');", "insert into METASTORE_DB_PROPERTIES values ('guid', 'test-uuid-2', 'dummy uuid 2');"};
        File scriptFile = this.generateTestScript(scripts);
        Exception ex = null;
        try {
            this.schemaTool.execSql(scriptFile.getPath());
        }
        catch (Exception iox) {
            ex = iox;
        }
        Assert.assertTrue((ex != null && ex instanceof IOException ? 1 : 0) != 0);
    }

    private String writeDummyPreUpgradeScript(int index, String upgradeScriptName, String sql) throws Exception {
        String preUpgradeScript = "pre-" + index + "-" + upgradeScriptName;
        String dummyPreScriptPath = System.getProperty("test.tmp.dir", "target/tmp") + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbms.getDbType() + File.separatorChar + preUpgradeScript;
        FileWriter fstream = new FileWriter(dummyPreScriptPath);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write(sql + System.getProperty("line.separator"));
        out.close();
        return preUpgradeScript;
    }

    private void createTestHiveTableSchemas() throws IOException {
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String[] scripts = new String[]{"insert into CTLGS values (2, 'mycat', 'my description', 'hdfs://myhost.com:8020/user/hive/warehouse', " + time + ");", "insert into DBS values(2, 'my db', 'hdfs://myhost.com:8020/user/hive/warehouse/mydb', 'mydb', 'public', 'role', 'mycat', " + time + ", '', 'NATIVE', '', '');", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (1,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/hive/warehouse/mydb',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into SDS(SD_ID,CD_ID,INPUT_FORMAT,IS_COMPRESSED,IS_STOREDASSUBDIRECTORIES,LOCATION,NUM_BUCKETS,OUTPUT_FORMAT,SERDE_ID) values (2,null,'org.apache.hadoop.mapred.TextInputFormat','N','N','hdfs://myhost.com:8020/user/admin/2015_11_18',-1,'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat',null);", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (2 ,1435255431,2,0 ,'hive',0,1,'mytal','MANAGED_TABLE',NULL,NULL,'n');", "insert into TBLS(TBL_ID,CREATE_TIME,DB_ID,LAST_ACCESS_TIME,OWNER,RETENTION,SD_ID,TBL_NAME,TBL_TYPE,VIEW_EXPANDED_TEXT,VIEW_ORIGINAL_TEXT,IS_REWRITE_ENABLED) values (3 ,1435255431,2,0 ,'hive',0,2,'aTable','MANAGED_TABLE',NULL,NULL,'n');", "insert into PARTITIONS(PART_ID,CREATE_TIME,LAST_ACCESS_TIME, PART_NAME,SD_ID,TBL_ID) values(1, 1441402388,0, 'd1=1/d2=1',2,2);"};
        File scriptFile = this.generateTestScript(scripts);
        this.schemaTool.execSql(scriptFile.getPath());
    }

    private void execute(SchemaToolTask task, String taskArgs) throws HiveMetaException {
        String argsBase = String.format("-dbType %s -userName %s -passWord %s ", this.dbms.getDbType(), this.dbms.getHiveUser(), this.dbms.getHivePassword());
        try {
            StrTokenizer tokenizer = new StrTokenizer(argsBase + taskArgs, ' ', '\"');
            SchemaToolCommandLine cl = new SchemaToolCommandLine(tokenizer.getTokenArray(), null);
            task.setCommandLineArguments(cl);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not parse comman line \n" + argsBase + taskArgs, e);
        }
        task.setHiveSchemaTool(this.schemaTool);
        task.execute();
    }

    class BadMetaDataConnection
    extends DelegatingConnection {
        static final String FAILURE_TEXT = "fault injected";

        BadMetaDataConnection(Connection connection) {
            super(connection);
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            throw new SQLException(FAILURE_TEXT);
        }
    }
}

