/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.tools.MetaToolObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.HiveMetaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskListFSRoot;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MetastoreUnitTest.class})
public class TestMetaToolTaskListFSRoot {
    @Test
    public void testListFSRoot() throws Exception {
        String fsRoot1 = "hdfs://abc.de";
        String fsRoot2 = "hdfs://fgh.ji";
        MetaToolObjectStore mockObjectStore = (MetaToolObjectStore)Mockito.mock(MetaToolObjectStore.class);
        Mockito.when((Object)mockObjectStore.listFSRoots()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{fsRoot1, fsRoot2}));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        System.setOut(new PrintStream(os));
        MetaToolTaskListFSRoot t = new MetaToolTaskListFSRoot();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-listFSRoot"}));
        t.setObjectStore(mockObjectStore);
        t.execute();
        Assert.assertTrue((String)(((Object)os).toString() + " doesn't contain " + fsRoot1), (boolean)((Object)os).toString().contains(fsRoot1));
        Assert.assertTrue((String)(((Object)os).toString() + " doesn't contain " + fsRoot2), (boolean)((Object)os).toString().contains(fsRoot2));
    }
}

