/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskListExtTblLocs;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaToolTaskListExtTblLocs {
    @Test
    public void testGroupLocations() {
        TreeSet<String> inputLocations = new TreeSet<String>();
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaToolTaskListExtTblLocs.msConf = conf;
        MetaToolTaskListExtTblLocs task = new MetaToolTaskListExtTblLocs();
        inputLocations.add("/warehouse/customLocation/t1");
        inputLocations.add("/warehouse/customLocation/t2");
        inputLocations.add("/warehouse/customLocation/t3");
        Map output = task.runTest(inputLocations, null);
        Assert.assertEquals((long)1L, (long)output.size());
        String expectedOutput = "/warehouse/customLocation";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput));
        HashSet coveredLocs = (HashSet)output.get(expectedOutput);
        Assert.assertEquals((long)3L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/t1"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/t2"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/t3"));
        inputLocations.clear();
        inputLocations.add("/warehouse/customLocation/ext/b0");
        inputLocations.add("/warehouse/customLocation/ext/p=0");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/b3/p=1");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/b3/p=2");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/b3/p=3");
        output = task.runTest(inputLocations, null);
        Assert.assertEquals((long)3L, (long)output.size());
        String expectedOutput1 = "/warehouse/customLocation/ext/b0";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput1));
        coveredLocs = (HashSet)output.get(expectedOutput1);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0"));
        String expectedOutput2 = "/warehouse/customLocation/ext/p=0";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput2));
        coveredLocs = (HashSet)output.get(expectedOutput2);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/p=0"));
        String expectedOutput3 = "/warehouse/customLocation/ext/b1/b2/b3";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput3));
        coveredLocs = (HashSet)output.get(expectedOutput3);
        Assert.assertEquals((long)3L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/b3/p=1"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/b3/p=2"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/b3/p=3"));
        inputLocations.clear();
        inputLocations.add("/warehouse/customLocation/ext/p=0");
        inputLocations.add("/warehouse/customLocation/ext/p=1");
        inputLocations.add("/warehouse/customLocation/ext/p=2");
        inputLocations.add("/warehouse/customLocation/ext/p=3");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=4");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=5");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=6");
        output = task.runTest(inputLocations, null);
        Assert.assertEquals((long)1L, (long)output.size());
        expectedOutput = "/warehouse/customLocation/ext";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput));
        coveredLocs = (HashSet)output.get(expectedOutput);
        Assert.assertEquals((long)7L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.containsAll(inputLocations));
        inputLocations.clear();
        inputLocations.add("/warehouse/customLocation/ext/dir01/dir02/p=0");
        inputLocations.add("/warehouse/customLocation/ext/dir11/dir12/p=1");
        inputLocations.add("/warehouse/customLocation/ext/dir21/dir22/p=2");
        inputLocations.add("/warehouse/customLocation/ext/dir31/dir32/p=3");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=4");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=5");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=6");
        output = task.runTest(inputLocations, null);
        Assert.assertEquals((long)1L, (long)output.size());
        expectedOutput = "/warehouse/customLocation/ext";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput));
        coveredLocs = (HashSet)output.get(expectedOutput);
        Assert.assertEquals((long)7L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.containsAll(inputLocations));
        inputLocations.clear();
        inputLocations.add("/warehouse/customLocation/ext/b0/p=0");
        inputLocations.add("/warehouse/customLocation/ext/b0/p=1");
        inputLocations.add("/warehouse/customLocation/ext/b0/p=2");
        inputLocations.add("/warehouse/customLocation/ext/b0/p=3");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=4");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=5");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=6");
        inputLocations.add("/warehouse/customLocation/ext/p=7");
        output = task.runTest(inputLocations, null);
        Assert.assertEquals((long)3L, (long)output.size());
        expectedOutput1 = "/warehouse/customLocation/ext/b0";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput1));
        coveredLocs = (HashSet)output.get(expectedOutput1);
        Assert.assertEquals((long)4L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0/p=0"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0/p=1"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0/p=2"));
        expectedOutput2 = "/warehouse/customLocation/ext/b1";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput2));
        coveredLocs = (HashSet)output.get(expectedOutput2);
        Assert.assertEquals((long)3L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/p=4"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/p=5"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/p=6"));
        expectedOutput3 = "/warehouse/customLocation/ext/p=7";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput3));
        coveredLocs = (HashSet)output.get(expectedOutput3);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/p=7"));
        inputLocations.clear();
        inputLocations.add("/warehouse/customLocation/ext/b0/p=0");
        inputLocations.add("/warehouse/customLocation/ext/b0/p=1");
        inputLocations.add("/warehouse/customLocation/ext/b0/p=2");
        inputLocations.add("/warehouse/customLocation/ext/b0/p=3");
        inputLocations.add("/warehouse/customLocation/ext/b1");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/p=7");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/p=8");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/p=9");
        output = task.runTest(inputLocations, null);
        Assert.assertEquals((long)2L, (long)output.size());
        expectedOutput1 = "/warehouse/customLocation/ext/b0";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput1));
        coveredLocs = (HashSet)output.get(expectedOutput1);
        Assert.assertEquals((long)4L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0/p=0"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0/p=1"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0/p=2"));
        expectedOutput2 = "/warehouse/customLocation/ext/b1";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput2));
        coveredLocs = (HashSet)output.get(expectedOutput2);
        Assert.assertEquals((long)4L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/p=7"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/p=8"));
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/p=9"));
    }

    @Test
    public void testGroupLocationsDummyDataSizes() {
        TreeSet<String> inputLocations = new TreeSet<String>();
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaToolTaskListExtTblLocs.msConf = conf;
        MetaToolTaskListExtTblLocs task = new MetaToolTaskListExtTblLocs();
        inputLocations.add("/warehouse/customLocation/t1");
        inputLocations.add("/warehouse/customLocation/t2");
        inputLocations.add("/warehouse/customLocation/t3");
        HashMap<String, Long> dataSizes = new HashMap<String, Long>();
        dataSizes.put("/warehouse/customLocation", 100L);
        Map output = task.runTest(inputLocations, dataSizes);
        Assert.assertEquals((long)3L, (long)output.size());
        String expectedOutput1 = "/warehouse/customLocation/t1";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput1));
        HashSet coveredLocs = (HashSet)output.get(expectedOutput1);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/t1"));
        inputLocations.clear();
        dataSizes.clear();
        inputLocations.add("/warehouse/customLocation/ext/b0");
        inputLocations.add("/warehouse/customLocation/ext/p=0");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/b3/p=1");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/b3/p=2");
        inputLocations.add("/warehouse/customLocation/ext/b1/b2/b3/p=3");
        dataSizes.put("/warehouse/customLocation/ext/b1/b2/b3", 100L);
        output = task.runTest(inputLocations, dataSizes);
        Assert.assertEquals((long)5L, (long)output.size());
        expectedOutput1 = "/warehouse/customLocation/ext/b0";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput1));
        coveredLocs = (HashSet)output.get(expectedOutput1);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b0"));
        String expectedOutput2 = "/warehouse/customLocation/ext/p=0";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput2));
        coveredLocs = (HashSet)output.get(expectedOutput2);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/p=0"));
        String expectedOutput3 = "/warehouse/customLocation/ext/b1/b2/b3/p=1";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput3));
        coveredLocs = (HashSet)output.get(expectedOutput3);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/b3/p=1"));
        String expectedOutput4 = "/warehouse/customLocation/ext/b1/b2/b3/p=2";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput4));
        coveredLocs = (HashSet)output.get(expectedOutput4);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/b3/p=2"));
        String expectedOutput5 = "/warehouse/customLocation/ext/b1/b2/b3/p=3";
        Assert.assertTrue((boolean)output.containsKey(expectedOutput5));
        coveredLocs = (HashSet)output.get(expectedOutput5);
        Assert.assertEquals((long)1L, (long)coveredLocs.size());
        Assert.assertTrue((boolean)coveredLocs.contains("/warehouse/customLocation/ext/b1/b2/b3/p=3"));
        inputLocations.clear();
        dataSizes.clear();
        inputLocations.add("/warehouse/customLocation/ext/p=0");
        inputLocations.add("/warehouse/customLocation/ext/p=1");
        inputLocations.add("/warehouse/customLocation/ext/p=2");
        inputLocations.add("/warehouse/customLocation/ext/p=3");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=4");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=5");
        inputLocations.add("/warehouse/customLocation/ext/b1/p=6");
        dataSizes.put("/warehouse/customLocation/ext/b1", 100L);
        dataSizes.put("/warehouse/customLocation/ext", 100L);
        output = task.runTest(inputLocations, dataSizes);
        Assert.assertEquals((long)7L, (long)output.size());
        Assert.assertTrue((boolean)output.keySet().containsAll(inputLocations));
        for (String outLoc : output.keySet()) {
            Assert.assertTrue((boolean)((HashSet)output.get(outLoc)).contains(outLoc));
        }
    }
}

