/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.MemoryTokenStore;
import org.apache.hadoop.hive.metastore.security.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestTokenStoreDelegationTokenSecretManager {
    private final Configuration conf = MetastoreConf.newMetastoreConf();

    private TokenStoreDelegationTokenSecretManager createTokenMgr(DelegationTokenStore tokenStore, long renewSecs, long gcTime, long maxLifeTime) {
        long secretKeyInterval = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_KEY_UPDATE_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = maxLifeTime * 1000L;
        long tokenRenewInterval = renewSecs * 1000L;
        long tokenGcInterval = gcTime * 1000L;
        return new TokenStoreDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, tokenGcInterval, tokenStore);
    }

    private DelegationTokenIdentifier getID(String tokenStr) throws IOException {
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        Token token = new Token();
        token.decodeFromUrlString(tokenStr);
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));){
            id.readFields((DataInput)in);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenewal() throws IOException, InterruptedException {
        MemoryTokenStore tokenStore = new MemoryTokenStore();
        TokenStoreDelegationTokenSecretManager mgr = this.createTokenMgr((DelegationTokenStore)tokenStore, 3600L, MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_GC_INTERVAL, (TimeUnit)TimeUnit.SECONDS), MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_MAX_LIFETIME, (TimeUnit)TimeUnit.SECONDS));
        try {
            mgr.startThreads();
            String tokenStr = mgr.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName(), UserGroupInformation.getCurrentUser().getShortUserName());
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr));
            DelegationTokenIdentifier id = this.getID(tokenStr);
            long initialExpiry = tokenStore.getToken(id).getRenewDate();
            Thread.sleep(100L);
            Assert.assertTrue((System.currentTimeMillis() > id.getIssueDate() ? 1 : 0) != 0);
            Assert.assertEquals((long)tokenStore.getToken(id).getRenewDate(), (long)initialExpiry);
            mgr.renewDelegationToken(tokenStr);
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr));
            Assert.assertTrue((tokenStore.getToken(id).getRenewDate() > initialExpiry ? 1 : 0) != 0);
        }
        finally {
            mgr.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenRenewalWithDifferentUsers() throws IOException, InterruptedException {
        MemoryTokenStore tokenStore = new MemoryTokenStore();
        TokenStoreDelegationTokenSecretManager mgr = this.createTokenMgr((DelegationTokenStore)tokenStore, 1L, MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_GC_INTERVAL, (TimeUnit)TimeUnit.SECONDS), MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_MAX_LIFETIME, (TimeUnit)TimeUnit.SECONDS));
        try {
            mgr.startThreads();
            String tokenStr1 = mgr.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName(), UserGroupInformation.getCurrentUser().getShortUserName());
            String tokenStr2 = mgr.getDelegationToken("user1", "user1");
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr1));
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr2));
            DelegationTokenIdentifier id1 = this.getID(tokenStr1);
            DelegationTokenIdentifier id2 = this.getID(tokenStr2);
            long initialExpiry1 = tokenStore.getToken(id1).getRenewDate();
            long initialExpiry2 = tokenStore.getToken(id2).getRenewDate();
            Thread.sleep(3000L);
            Assert.assertTrue((System.currentTimeMillis() > id1.getIssueDate() ? 1 : 0) != 0);
            Assert.assertTrue((System.currentTimeMillis() > id2.getIssueDate() ? 1 : 0) != 0);
            Assert.assertEquals((long)tokenStore.getToken(id1).getRenewDate(), (long)initialExpiry1);
            Assert.assertEquals((long)tokenStore.getToken(id2).getRenewDate(), (long)initialExpiry2);
            mgr.renewIfRequired(id1, tokenStore.getToken(id1));
            mgr.renewIfRequired(id2, tokenStore.getToken(id2));
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr1));
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr2));
            Assert.assertTrue((tokenStore.getToken(id1).getRenewDate() > initialExpiry1 ? 1 : 0) != 0);
            Assert.assertTrue((tokenStore.getToken(id2).getRenewDate() > initialExpiry2 ? 1 : 0) != 0);
        }
        finally {
            mgr.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenRenewalAndRemoval() throws IOException, InterruptedException {
        MemoryTokenStore tokenStore = new MemoryTokenStore();
        TokenStoreDelegationTokenSecretManager mgr = this.createTokenMgr((DelegationTokenStore)tokenStore, 2L, 1L, 8L);
        try {
            mgr.startThreads();
            String tokenStr = mgr.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName(), UserGroupInformation.getCurrentUser().getShortUserName());
            DelegationTokenIdentifier id = this.getID(tokenStr);
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr));
            long initialExpiry = tokenStore.getToken(id).getRenewDate();
            Thread.sleep(5000L);
            Assert.assertTrue((tokenStore.getToken(id).getRenewDate() > initialExpiry ? 1 : 0) != 0);
            Thread.sleep(5000L);
            Assert.assertEquals((long)tokenStore.getAllDelegationTokenIdentifiers().size(), (long)0L);
        }
        finally {
            mgr.stopThreads();
        }
    }
}

