/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.HMSDirectTest;
import org.apache.hadoop.hive.metastore.properties.HMSPropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HMSTestBase {
    protected static final String baseDir = System.getProperty("basedir");
    private static final File jwtAuthorizedKeyFile = new File(baseDir, "src/test/resources/auth/jwt/jwt-authorized-key.json");
    protected static final File jwtUnauthorizedKeyFile = new File(baseDir, "src/test/resources/auth/jwt/jwt-unauthorized-key.json");
    protected static final File jwtVerificationJWKSFile = new File(baseDir, "src/test/resources/auth/jwt/jwt-verification-jwks.json");
    public static final String USER_1 = "USER_1";
    protected static final int MOCK_JWKS_SERVER_PORT = 8089;
    @ClassRule
    public static final WireMockRule MOCK_JWKS_SERVER = new WireMockRule(8089);
    protected Configuration conf = null;
    protected static final Logger LOG = LoggerFactory.getLogger(HMSTestBase.class);
    static Random RND = new Random(20230424L);
    protected String NS;
    protected PropertyClient client;
    protected int port = -1;

    @Before
    public void setUp() throws Exception {
        this.NS = "hms" + RND.nextInt(100);
        this.conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_CLEAN_MAX_EVENTS, (long)1L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_PORT, (long)0L);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_AUTH, (String)"JWT");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL, (String)"http://localhost:8089/jwks");
        MOCK_JWKS_SERVER.stubFor(WireMock.get((String)"/jwks").willReturn(WireMock.ok().withBody(Files.readAllBytes(jwtVerificationJWKSFile.toPath()))));
        this.port = this.createServer(this.conf);
        System.out.println("Starting MetaStore Server on port " + this.port);
        PropertyManager.declare((String)this.NS, HMSPropertyManager.class);
        this.client = this.createClient(this.conf, this.port);
        Assert.assertNotNull((String)"Unable to connect to the MetaStore server", (Object)this.client);
    }

    @After
    public synchronized void tearDown() throws Exception {
        try {
            if (this.port >= 0) {
                this.stopServer(this.port);
                this.port = -1;
            }
            System.clearProperty("javax.net.ssl.trustStore");
            System.clearProperty("javax.net.ssl.trustStorePassword");
            System.clearProperty("javax.net.ssl.trustStoreType");
        }
        finally {
            this.client = null;
            this.conf = null;
        }
    }

    protected String generateJWT() throws Exception {
        return this.generateJWT(jwtAuthorizedKeyFile.toPath());
    }

    protected String generateJWT(Path path) throws Exception {
        return HMSTestBase.generateJWT(USER_1, path, TimeUnit.MINUTES.toMillis(5L));
    }

    private static String generateJWT(String user, Path keyFile, long lifeTimeMillis) throws Exception {
        RSAKey rsaKeyPair = RSAKey.parse((String)new String(Files.readAllBytes(keyFile), StandardCharsets.UTF_8));
        RSASSASigner signer = new RSASSASigner(rsaKeyPair);
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaKeyPair.getKeyID()).build();
        Date now = new Date();
        Date expirationTime = new Date(now.getTime() + lifeTimeMillis);
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().jwtID(UUID.randomUUID().toString()).issueTime(now).issuer("auth-server").subject(user).expirationTime(expirationTime).claim("custom-claim-or-payload", (Object)"custom-claim-or-payload").build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT.serialize();
    }

    protected int createServer(Configuration conf) throws Exception {
        return 0;
    }

    protected void stopServer(int port) throws Exception {
    }

    protected abstract PropertyClient createClient(Configuration var1, int var2) throws Exception;

    void runOtherProperties0(PropertyClient client) throws Exception {
        Map<String, String> ptyMap = HMSTestBase.createProperties0();
        boolean commit = client.setProperties(ptyMap);
        Assert.assertTrue((boolean)commit);
        Map<String, Map<String, String>> maps = client.getProperties("db0.table", "policy.'Table-name' =^ 'table0'", new String[0]);
        Assert.assertNotNull(maps);
        Assert.assertEquals((long)8L, (long)maps.size());
        Map<String, Map<String, String>> project = client.getProperties("db0.tabl", "fillFactor > 92", "fillFactor", "{ 'policy' : { 'Compaction' : { 'target-size' : policy.Compaction.'target-size' } } }");
        Assert.assertNotNull(project);
        Assert.assertEquals((long)2L, (long)project.size());
    }

    static Map<String, String> createProperties0() {
        HMSPropertyManager.declareTableProperty((String)"fillFactor", (PropertyType)PropertyType.DOUBLE, (Object)0.75);
        HMSPropertyManager.declareTableProperty((String)"policy", (PropertyType)PropertyType.JSON, null);
        HMSPropertyManager.declareTableProperty((String)"maint_status", (PropertyType)HMSPropertyManager.MAINTENANCE_STATUS, null);
        HMSPropertyManager.declareTableProperty((String)"maint_operation", (PropertyType)HMSPropertyManager.MAINTENANCE_OPERATION, null);
        try {
            String json = IOUtils.toString((InputStream)HMSDirectTest.class.getResourceAsStream("payload.json"), (Charset)StandardCharsets.UTF_8);
            JxltEngine JXLT = PropertyManager.JEXL.createJxltEngine();
            JxltEngine.Template jsonjexl = JXLT.createTemplate(json, new String[]{"table", "delta", "g"});
            Assert.assertNotNull((Object)json);
            TreeMap<String, String> ptyMap = new TreeMap<String, String>();
            for (int i = 0; i < 16; ++i) {
                String tname = "table" + String.format("%1$02o", i);
                String tb = "db0." + tname + ".";
                ptyMap.put(tb + "fillFactor", Integer.toString(100 - 5 * i));
                StringWriter strw = new StringWriter();
                jsonjexl.evaluate(null, (Writer)strw, new Object[]{tname, i * i % 100, (i + 1) % 7});
                ptyMap.put(tb + "policy", strw.toString());
                HMSPropertyManager.MaintenanceOpStatus status = HMSPropertyManager.findOpStatus((int)(i % HMSPropertyManager.MaintenanceOpStatus.values().length));
                Assert.assertNotNull((Object)status);
                ptyMap.put(tb + "maint_status", status.toString());
                HMSPropertyManager.MaintenanceOpType type = HMSPropertyManager.findOpType((int)(i % HMSPropertyManager.MaintenanceOpType.values().length));
                Assert.assertNotNull((Object)type);
                ptyMap.put(tb + "maint_operation", type.toString());
            }
            return ptyMap;
        }
        catch (IOException xio) {
            return null;
        }
    }

    void runOtherProperties1(PropertyClient client) throws Exception {
        Map<String, String> ptyMap = HMSTestBase.createProperties1();
        boolean commit = client.setProperties(ptyMap);
        Assert.assertTrue((boolean)commit);
        Map<String, Map<String, String>> maps = client.getProperties("db1.table", "someb && fillFactor < 95", new String[0]);
        Assert.assertNotNull(maps);
        Assert.assertEquals((long)5L, (long)maps.size());
        if (client instanceof HttpPropertyClient) {
            HttpPropertyClient httpClient = (HttpPropertyClient)client;
            ArrayList<String> keys = new ArrayList<String>(maps.keySet());
            keys.replaceAll(s -> s + ".fillFactor");
            Map<String, String> values = httpClient.getProperties(keys);
            Assert.assertTrue((boolean)(values instanceof Map));
            Map<String, String> getm = values;
            for (Map.Entry<String, Map<String, String>> entry : maps.entrySet()) {
                Map<String, String> map0v = entry.getValue();
                Assert.assertEquals((Object)map0v.get("fillFactor"), (Object)getm.get(entry.getKey() + ".fillFactor"));
            }
        }
        maps = client.getProperties("db1.table", "fillFactor > 92", "fillFactor");
        Assert.assertNotNull(maps);
        Assert.assertEquals((long)8L, (long)maps.size());
    }

    static Map<String, String> createProperties1() {
        HMSPropertyManager.declareTableProperty((String)"id", (PropertyType)PropertyType.INTEGER, null);
        HMSPropertyManager.declareTableProperty((String)"name", (PropertyType)PropertyType.STRING, null);
        HMSPropertyManager.declareTableProperty((String)"uuid", (PropertyType)PropertyType.STRING, null);
        HMSPropertyManager.declareTableProperty((String)"fillFactor", (PropertyType)PropertyType.DOUBLE, (Object)0.75);
        HMSPropertyManager.declareTableProperty((String)"someb", (PropertyType)PropertyType.BOOLEAN, (Object)Boolean.FALSE);
        HMSPropertyManager.declareTableProperty((String)"creation date", (PropertyType)PropertyType.DATETIME, (Object)"2023-01-06T12:16:00");
        HMSPropertyManager.declareTableProperty((String)"project", (PropertyType)PropertyType.STRING, (Object)"Hive");
        HMSPropertyManager.declareTableProperty((String)"policy", (PropertyType)PropertyType.JSON, null);
        HMSPropertyManager.declareTableProperty((String)"maint_status", (PropertyType)HMSPropertyManager.MAINTENANCE_STATUS, null);
        HMSPropertyManager.declareTableProperty((String)"maint_operation", (PropertyType)HMSPropertyManager.MAINTENANCE_OPERATION, null);
        TreeMap<String, String> ptys = new TreeMap<String, String>();
        for (int i = 0; i < 16; ++i) {
            String tb = "db1.table" + String.format("%1$02o", i) + ".";
            ptys.put(tb + "id", Integer.toString(1000 + i));
            ptys.put(tb + "name", "TABLE_" + i);
            ptys.put(tb + "fillFactor", Integer.toString(100 - i));
            ptys.put(tb + "someb", i % 2 == 0 ? "true" : "false");
        }
        return ptys;
    }

    protected static interface PropertyClient {
        public boolean setProperties(Map<String, String> var1);

        public Map<String, Map<String, String>> getProperties(String var1, String var2, String ... var3) throws IOException;
    }

    protected static interface HttpPropertyClient
    extends PropertyClient {
        default public Map<String, String> getProperties(List<String> selection) throws IOException {
            throw new UnsupportedOperationException("not implemented in " + this.getClass());
        }
    }
}

