/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import com.github.tomakehurst.wiremock.client.WireMock;
import java.nio.file.Files;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.HMSServletTest;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class HMSServletTestA
extends HMSServletTest {
    protected int thriftPort;

    @Override
    protected int createServer(Configuration conf) throws Exception {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_AUTH, (String)"JWT");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_PORT, (long)0L);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL, (String)"http://localhost:8089/jwks");
        MOCK_JWKS_SERVER.stubFor(WireMock.get((String)"/jwks").willReturn(WireMock.ok().withBody(Files.readAllBytes(jwtVerificationJWKSFile.toPath()))));
        this.thriftPort = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        this.servletServer = HiveMetaStore.getServletServer();
        if (this.servletServer == null || !this.servletServer.isStarted()) {
            Assert.fail((String)"http server did not start");
        }
        this.servletPort = HiveMetaStore.getPropertyServletPort();
        return this.servletPort;
    }

    @Override
    protected void stopServer(int port) throws Exception {
        super.stopServer(port);
        MetaStoreTestUtils.close(this.thriftPort);
    }
}

