/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.metrics.CompactionMetricData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestCompactionMetricData {
    private static final long SINCE_EPOCH = 0L;
    private static final String INITIATED = "initiated";
    private static final String WORKING = "working";
    private static final String READY_FOR_CLEANING = "ready for cleaning";
    private static final String DID_NOT_INITIATE = "did not initiate";
    private static final String SUCCEEDED = "succeeded";
    private static final String FAILED = "failed";

    @Test
    public void testStateCountsCountedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of(null).getStateCount(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", null, INITIATED, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(2L, "t1", null, INITIATED, CompactionType.MAJOR), (Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", WORKING, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(5L, "t2", "part1", WORKING, CompactionType.MAJOR), (Object)TestCompactionMetricData.aCompaction(6L, "t2", "part2", WORKING, CompactionType.MAJOR), (Object)TestCompactionMetricData.aCompaction(7L, "t3", null, READY_FOR_CLEANING, CompactionType.MAJOR))).getStateCount(), (Matcher)CoreMatchers.is((Object)ImmutableMap.of((Object)INITIATED, (Object)1L, (Object)WORKING, (Object)2L, (Object)READY_FOR_CLEANING, (Object)1L)));
    }

    @Test
    public void testOldestEnqueuedValueCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", WORKING, CompactionType.MINOR, 90L, null, null))).getOldestEnqueueTime(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", null, INITIATED, CompactionType.MINOR, 150L, null, null), (Object)TestCompactionMetricData.aCompaction(2L, "t1", null, INITIATED, CompactionType.MAJOR, 100L, null, null), (Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", WORKING, CompactionType.MINOR, 90L, null, null), (Object)TestCompactionMetricData.aCompaction(6L, "t2", "part2", DID_NOT_INITIATE, CompactionType.MAJOR, 50L, null, null), (Object)TestCompactionMetricData.aCompaction(7L, "t3", null, READY_FOR_CLEANING, CompactionType.MAJOR, 300L, null, null))).getOldestEnqueueTime(), (Matcher)CoreMatchers.is((Object)100L));
    }

    @Test
    public void testOldestWorkingValueCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", INITIATED, CompactionType.MINOR, null, 90L, null))).getOldestWorkingTime(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", null, INITIATED, CompactionType.MINOR, null, 150L, null), (Object)TestCompactionMetricData.aCompaction(2L, "t1", null, INITIATED, CompactionType.MAJOR, null, 100L, null), (Object)TestCompactionMetricData.aCompaction(4L, "t2", "part1", WORKING, CompactionType.MINOR, null, 90L, null), (Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", WORKING, CompactionType.MINOR, null, 70L, null), (Object)TestCompactionMetricData.aCompaction(6L, "t2", "part2", DID_NOT_INITIATE, CompactionType.MAJOR, null, 50L, null), (Object)TestCompactionMetricData.aCompaction(7L, "t3", null, READY_FOR_CLEANING, CompactionType.MAJOR, null, 300L, null))).getOldestWorkingTime(), (Matcher)CoreMatchers.is((Object)70L));
    }

    @Test
    public void testOldestCleaningValueCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", INITIATED, CompactionType.MINOR, null, null, 90L))).getOldestCleaningTime(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", null, INITIATED, CompactionType.MINOR, null, null, 150L), (Object)TestCompactionMetricData.aCompaction(2L, "t1", null, READY_FOR_CLEANING, CompactionType.MAJOR, null, null, 100L), (Object)TestCompactionMetricData.aCompaction(4L, "t2", "part1", WORKING, CompactionType.MINOR, null, null, 90L), (Object)TestCompactionMetricData.aCompaction(3L, "t2", "part1", WORKING, CompactionType.MINOR, null, null, 70L), (Object)TestCompactionMetricData.aCompaction(7L, "t3", null, READY_FOR_CLEANING, CompactionType.MAJOR, null, null, 300L))).getOldestCleaningTime(), (Matcher)CoreMatchers.is((Object)100L));
    }

    @Test
    public void testFailedPercentageCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of()).getFailedCompactionPercentage(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", "p1", SUCCEEDED, CompactionType.MINOR))).getFailedCompactionPercentage(), (Matcher)CoreMatchers.is((Object)0.0));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", "p1", FAILED, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(2L, "t2", "p1", SUCCEEDED, CompactionType.MINOR))).getFailedCompactionPercentage(), (Matcher)CoreMatchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", "p1", FAILED, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(2L, "t2", "p1", DID_NOT_INITIATE, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(3L, "t3", "p1", SUCCEEDED, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(4L, "t4", "p1", SUCCEEDED, CompactionType.MINOR))).getFailedCompactionPercentage(), (Matcher)CoreMatchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", "p1", FAILED, CompactionType.MINOR), (Object)TestCompactionMetricData.aCompaction(2L, "t2", "p1", DID_NOT_INITIATE, CompactionType.MINOR))).getFailedCompactionPercentage(), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", "p1", FAILED, CompactionType.MINOR))).getFailedCompactionPercentage(), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, "t1", "p1", DID_NOT_INITIATE, CompactionType.MINOR))).getFailedCompactionPercentage(), (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testInitiatorCountCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of(Collections.emptyList()).getInitiatorsCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, null, null, null, (String)null), (Object)TestCompactionMetricData.aCompaction(2L, "host1-initiator", null, null, (String)null), (Object)TestCompactionMetricData.aCompaction(3L, "host2-initiator-manual", null, null, (String)null), (Object)TestCompactionMetricData.aCompaction(4L, "host3-initiator", null, null, (String)null))).getInitiatorsCount(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testInitiatorVersionsCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of(Collections.emptyList()).getInitiatorVersionsCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, null, "1.0", null, (String)null), (Object)TestCompactionMetricData.aCompaction(2L, null, "3.0", null, (String)null), (Object)TestCompactionMetricData.aCompaction(3L, null, "4.0", null, (String)null), (Object)TestCompactionMetricData.aCompaction(4L, null, null, null, (String)null), (Object)TestCompactionMetricData.aCompaction(5L, null, "4.0", null, (String)null))).getInitiatorVersionsCount(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testWorkerCountCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of(Collections.emptyList()).getWorkersCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, null, null, null, "4.0"), (Object)TestCompactionMetricData.aCompaction(2L, null, null, "host1-worker", "4.0"), (Object)TestCompactionMetricData.aCompaction(3L, null, null, "host2-worker", "4.0"))).getWorkersCount(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testWorkerVersionsCalculatedCorrectly() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of(Collections.emptyList()).getWorkerVersionsCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(1L, null, null, null, "1.0"), (Object)TestCompactionMetricData.aCompaction(2L, null, null, null, "3.0"), (Object)TestCompactionMetricData.aCompaction(3L, null, null, null, "4.0"), (Object)TestCompactionMetricData.aCompaction(4L, null, null, null, (String)null), (Object)TestCompactionMetricData.aCompaction(5L, null, null, null, "4.0"))).getWorkerVersionsCount(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testCollectWorkerVersionsEmptyLists() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of(Collections.emptyList()).allWorkerVersionsSince(0L), (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void testCollectWorkerVersionsDidNotInitiateGettingFilteredOut() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction("DoNotShowUp", DID_NOT_INITIATE, 1L, 1L, 1L), (Object)TestCompactionMetricData.aCompaction("1.0", INITIATED, 1L, 1L, 1L))).allWorkerVersionsSince(0L), (Matcher)CoreMatchers.is(Collections.singletonList("1.0")));
    }

    @Test
    public void testCollectWorkerVersionsNullVersionGettingFilteredOut() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction(null, INITIATED, 1L, 1L, 1L))).allWorkerVersionsSince(0L), (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void testCollectWorkerVersionsTimeThreshold() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction("0.0-not-shown", INITIATED, 99L, null, null), (Object)TestCompactionMetricData.aCompaction("0.1-not-shown", INITIATED, 99L, 99L, null), (Object)TestCompactionMetricData.aCompaction("0.2-not-shown", INITIATED, 99L, 99L, 99L), (Object)TestCompactionMetricData.aCompaction("1.0", INITIATED, 100L, null, null), (Object)TestCompactionMetricData.aCompaction("1.1", WORKING, 99L, 100L, null), (Object)TestCompactionMetricData.aCompaction("1.2", SUCCEEDED, 99L, 99L, 100L))).allWorkerVersionsSince(100L), (Matcher)CoreMatchers.is((Object)ImmutableList.of((Object)"1.0", (Object)"1.1", (Object)"1.2")));
    }

    @Test
    public void testCollectWorkerVersionsSortedAndAvoidDuplicates() {
        MatcherAssert.assertThat((Object)CompactionMetricData.of((List)ImmutableList.of((Object)TestCompactionMetricData.aCompaction("2.0", INITIATED, 1L, null, null), (Object)TestCompactionMetricData.aCompaction("2.1", INITIATED, 1L, null, null), (Object)TestCompactionMetricData.aCompaction("2.10", INITIATED, 1L, null, null), (Object)TestCompactionMetricData.aCompaction("2.2", INITIATED, 1L, null, null), (Object)TestCompactionMetricData.aCompaction("3.0", WORKING, 1L, null, null), (Object)TestCompactionMetricData.aCompaction("1.0", INITIATED, 1L, null, null), (Object)TestCompactionMetricData.aCompaction("1.0", WORKING, 1L, null, null))).allWorkerVersionsSince(0L), (Matcher)CoreMatchers.is((Object)ImmutableList.of((Object)"1.0", (Object)"2.0", (Object)"2.1", (Object)"2.10", (Object)"2.2", (Object)"3.0")));
    }

    private static ShowCompactResponseElement aCompaction(long id, String table, String partition, String state, CompactionType type) {
        ShowCompactResponseElement e = new ShowCompactResponseElement("db_name", table, type, state);
        e.setId(id);
        e.setPartitionname(partition);
        return e;
    }

    private static ShowCompactResponseElement aCompaction(long id, String initiatorId, String initiatorVersion, String workerId, String workerVersion) {
        ShowCompactResponseElement e = new ShowCompactResponseElement("db_name", UUID.randomUUID().toString(), CompactionType.MAJOR, INITIATED);
        e.setId(id);
        e.setInitiatorId(initiatorId);
        e.setInitiatorVersion(initiatorVersion);
        e.setWorkerid(workerId);
        e.setWorkerVersion(workerVersion);
        return e;
    }

    private static ShowCompactResponseElement aCompaction(long id, String table, String partition, String state, CompactionType type, Long enqueuedTime, Long startTime, Long cleanerStart) {
        ShowCompactResponseElement e = new ShowCompactResponseElement("db_name", table, type, state);
        e.setId(id);
        e.setPartitionname(partition);
        if (enqueuedTime != null) {
            e.setEnqueueTime(enqueuedTime.longValue());
        }
        if (startTime != null) {
            e.setStart(startTime.longValue());
        }
        if (cleanerStart != null) {
            e.setCleanerStart(cleanerStart.longValue());
        }
        return e;
    }

    private static ShowCompactResponseElement aCompaction(String workerVersion, String state, Long enqueuedTime, Long startTime, Long endTime) {
        ShowCompactResponseElement e = new ShowCompactResponseElement("db_name", "table_name", CompactionType.MINOR, state);
        e.setWorkerVersion(workerVersion);
        if (enqueuedTime != null) {
            e.setEnqueueTime(enqueuedTime.longValue());
        }
        if (startTime != null) {
            e.setStart(startTime.longValue());
        }
        if (endTime != null) {
            e.setEndTime(endTime.longValue());
        }
        return e;
    }
}

