/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.io.IOException;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.apache.hadoop.hive.metastore.ldap.UserSearchFilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestUserSearchFilter {
    private FilterFactory factory;
    private Configuration conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
        this.factory = new UserSearchFilterFactory();
    }

    @Test
    public void testFactoryWhenNoGroupOrUserFilters() {
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testFactoryWhenGroupFilter() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"Grp1,Grp2");
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testFactoryWhenUserFilter() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1,User2");
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testApplyPositive() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1");
        Filter filter = this.factory.getInstance(this.conf);
        Mockito.when((Object)this.search.findUserDn(Mockito.anyString())).thenReturn((Object)"cn=User1,ou=People,dc=example,dc=com");
        filter.apply(this.search, "User1");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyWhenNamingException() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1");
        Filter filter = this.factory.getInstance(this.conf);
        Mockito.when((Object)this.search.findUserDn(Mockito.anyString())).thenThrow(NamingException.class);
        filter.apply(this.search, "User3");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyWhenNotFound() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1");
        Filter filter = this.factory.getInstance(this.conf);
        Mockito.when((Object)this.search.findUserDn(Mockito.anyString())).thenReturn(null);
        filter.apply(this.search, "User3");
    }
}

