/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.Query;
import org.apache.hadoop.hive.metastore.ldap.QueryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueryFactory {
    private QueryFactory queries;
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GUIDKEY, (String)"guid");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPCLASS_KEY, (String)"superGroups");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPMEMBERSHIP_KEY, (String)"member");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY, (String)"partOf");
        this.queries = new QueryFactory(this.conf);
    }

    @Test
    public void testFindGroupDnById() {
        Query q = this.queries.findGroupDnById("unique_group_id");
        String expected = "(&(objectClass=superGroups)(guid=unique_group_id))";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindUserDnByRdn() {
        Query q = this.queries.findUserDnByRdn("cn=User1");
        String expected = "(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))(cn=User1))";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindDnByPattern() {
        Query q = this.queries.findDnByPattern("cn=User1");
        String expected = "(cn=User1)";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindUserDnByName() {
        Query q = this.queries.findUserDnByName("unique_user_id");
        String expected = "(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))(|(uid=unique_user_id)(sAMAccountName=unique_user_id)))";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindGroupsForUser() {
        Query q = this.queries.findGroupsForUser("user_name", "user_Dn");
        String expected = "(&(objectClass=superGroups)(|(member=user_Dn)(member=user_name)))";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsUserMemberOfGroup() {
        Query q = this.queries.isUserMemberOfGroup("unique_user", "cn=MyGroup,ou=Groups,dc=mycompany,dc=com");
        String expected = "(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))(partOf=cn=MyGroup,ou=Groups,dc=mycompany,dc=com)(guid=unique_user))";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=IllegalStateException.class)
    public void testIsUserMemberOfGroupWhenMisconfigured() {
        QueryFactory misconfiguredQueryFactory = new QueryFactory(MetastoreConf.newMetastoreConf());
        misconfiguredQueryFactory.isUserMemberOfGroup("user", "cn=MyGroup");
    }

    @Test
    public void testFindGroupDNByID() {
        Query q = this.queries.findGroupDnById("unique_group_id");
        String expected = "(&(objectClass=superGroups)(guid=unique_group_id))";
        String actual = q.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

