/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.security.sasl.AuthenticationException;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreLdapAuthenticationProviderImpl;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.Credentials;
import org.junit.Assert;

public final class LdapAuthenticationTestCase {
    private final MetaStoreLdapAuthenticationProviderImpl ldapProvider;

    public static Builder builder() {
        return new Builder();
    }

    private LdapAuthenticationTestCase(Builder builder) {
        this.ldapProvider = new MetaStoreLdapAuthenticationProviderImpl(builder.conf);
    }

    public void assertAuthenticatePasses(Credentials credentials) {
        try {
            this.ldapProvider.authenticate(credentials.getUser(), credentials.getPassword());
        }
        catch (AuthenticationException e) {
            String message = String.format("Authentication failed for user '%s' with password '%s'", credentials.getUser(), credentials.getPassword());
            throw new AssertionError(message, e);
        }
    }

    public void assertAuthenticateFails(Credentials credentials) {
        this.assertAuthenticateFails(credentials.getUser(), credentials.getPassword());
    }

    public void assertAuthenticateFailsUsingWrongPassword(Credentials credentials) {
        this.assertAuthenticateFails(credentials.getUser(), "not" + credentials.getPassword());
    }

    public void assertAuthenticateFails(String user, String password) {
        try {
            this.ldapProvider.authenticate(user, password);
            Assert.fail((String)String.format("Expected authentication to fail for %s", user));
        }
        catch (AuthenticationException expected) {
            Assert.assertNotNull((String)"Expected authentication exception", (Object)expected);
        }
    }

    public static final class Builder {
        private final Map<MetastoreConf.ConfVars, String> overrides = new EnumMap<MetastoreConf.ConfVars, String>(MetastoreConf.ConfVars.class);
        private Configuration conf;

        public Builder baseDN(String baseDN) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_BASEDN, baseDN);
        }

        public Builder guidKey(String guidKey) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GUIDKEY, guidKey);
        }

        public Builder userDNPatterns(String ... userDNPatterns) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERDNPATTERN, Joiner.on((char)':').join((Object[])userDNPatterns));
        }

        public Builder userFilters(String ... userFilters) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, Joiner.on((char)',').join((Object[])userFilters));
        }

        public Builder groupDNPatterns(String ... groupDNPatterns) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPDNPATTERN, Joiner.on((char)':').join((Object[])groupDNPatterns));
        }

        public Builder groupFilters(String ... groupFilters) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, Joiner.on((char)',').join((Object[])groupFilters));
        }

        public Builder groupClassKey(String groupClassKey) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPCLASS_KEY, groupClassKey);
        }

        public Builder ldapServer(LdapServer ldapServer) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_URL, "ldap://localhost:" + ldapServer.getPort());
        }

        public Builder customQuery(String customQuery) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_CUSTOMLDAPQUERY, customQuery);
        }

        public Builder groupMembershipKey(String groupMembershipKey) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPMEMBERSHIP_KEY, groupMembershipKey);
        }

        public Builder userMembershipKey(String userMembershipKey) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY, userMembershipKey);
        }

        public Builder userSearchFilter(String userSearchFilter) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERSEARCHFILTER, userSearchFilter);
        }

        public Builder groupSearchFilter(String groupSearchFilter) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPSEARCHFILTER, groupSearchFilter);
        }

        public Builder groupBaseDN(String groupBaseDN) {
            return this.setVarOnce(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPBASEDN, groupBaseDN);
        }

        private Builder setVarOnce(MetastoreConf.ConfVars confVar, String value) {
            Preconditions.checkState((!this.overrides.containsKey(confVar) ? 1 : 0) != 0, (String)"Property %s has been set already", (Object)confVar);
            this.overrides.put(confVar, value);
            return this;
        }

        private void overrideMetaStoreConf() {
            this.conf.set("hive.root.logger", "DEBUG,console");
            for (Map.Entry<MetastoreConf.ConfVars, String> entry : this.overrides.entrySet()) {
                MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)entry.getKey(), (String)entry.getValue());
            }
        }

        public LdapAuthenticationTestCase build() {
            Preconditions.checkState((this.conf == null ? 1 : 0) != 0, (Object)"Test Case Builder should not be reused. Please create a new instance.");
            this.conf = MetastoreConf.newMetastoreConf();
            this.overrideMetaStoreConf();
            return new LdapAuthenticationTestCase(this);
        }
    }
}

