/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestCommitTxnEventWithDbAndWriteId {
    @Test
    public void testBackwardsCompatibility() {
        String json = "{\"txnid\":12787,\"timestamp\":1654116516,\"server\":\"\",\"servicePrincipal\":\"\"}";
        JSONMessageDeserializer deserializer = new JSONMessageDeserializer();
        CommitTxnMessage commitTxnMsg = deserializer.getCommitTxnMessage("{\"txnid\":12787,\"timestamp\":1654116516,\"server\":\"\",\"servicePrincipal\":\"\"}");
        Assert.assertNull((Object)commitTxnMsg.getDatabases());
        Assert.assertEquals((long)12787L, (long)commitTxnMsg.getTxnId());
    }

    @Test
    public void testSerializeDeserialize() {
        List<String> databases = Arrays.asList("db1", "db22");
        List<Long> writeIds = Arrays.asList(1L, 2L);
        CommitTxnEvent event = new CommitTxnEvent(Long.valueOf(999L), TxnType.DEFAULT, null, databases, writeIds);
        CommitTxnMessage msg = MessageBuilder.getInstance().buildCommitTxnMessage(event.getTxnId(), event.getDatabases(), event.getWriteId());
        JSONMessageEncoder msgEncoder = new JSONMessageEncoder();
        String json = msgEncoder.getSerializer().serialize((EventMessage)msg);
        JSONMessageDeserializer deserializer = new JSONMessageDeserializer();
        CommitTxnMessage commitTxnMsg = deserializer.getCommitTxnMessage(json);
        HashSet<String> expected = new HashSet<String>(databases);
        Assert.assertEquals((long)expected.size(), (long)commitTxnMsg.getDatabases().size());
        List actual = commitTxnMsg.getDatabases();
        Assert.assertTrue((boolean)actual.remove("db1"));
        Assert.assertTrue((boolean)actual.remove("db22"));
        Assert.assertTrue((boolean)actual.isEmpty());
        List actualWriteIds = commitTxnMsg.getWriteIds();
        Assert.assertTrue((boolean)actualWriteIds.remove(1L));
        Assert.assertTrue((boolean)actualWriteIds.remove(2L));
        Assert.assertTrue((boolean)actualWriteIds.isEmpty());
        Assert.assertEquals((long)999L, (long)commitTxnMsg.getTxnId());
    }
}

