/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Postgres;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;

public class PostgresTPCDS
extends Postgres {
    @Override
    public String getDockerImageName() {
        return "zabetak/postgres-tpcds-metastore:1.3";
    }

    @Override
    public String getJdbcUrl(String hostAddress) {
        return "jdbc:postgresql://" + hostAddress + ":5432/metastore";
    }

    @Override
    public String getHiveUser() {
        return "hive";
    }

    @Override
    public String getHivePassword() {
        return "hive";
    }

    @Override
    public void install() {
        String hiveSchemaVer = MetaStoreSchemaInfoFactory.get((Configuration)new Configuration()).getHiveSchemaVersion();
        try (InputStream script = PostgresTPCDS.class.getClassLoader().getResourceAsStream("sql/postgres/upgrade-3.1.3000-to-" + hiveSchemaVer + ".postgres.sql");){
            new MetastoreSchemaTool().runScript(this.buildArray("-upgradeSchema", "-dbType", this.getDbType(), "-userName", this.getHiveUser(), "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()), script);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }
}

