/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import java.sql.DriverManager;
import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;

public class Derby
extends DatabaseRule {
    boolean purgeInAfter;

    public Derby() {
        this(false);
    }

    public Derby(boolean purgeInAfter) {
        this.purgeInAfter = purgeInAfter;
    }

    @Override
    public String getDockerImageName() {
        return null;
    }

    @Override
    public String[] getDockerAdditionalArgs() {
        return null;
    }

    @Override
    public String getDbType() {
        return "derby";
    }

    @Override
    public String getDbRootUser() {
        return "APP";
    }

    @Override
    public String getHiveUser() {
        return "APP";
    }

    @Override
    public String getDbRootPassword() {
        return "mine";
    }

    @Override
    public String getHivePassword() {
        return "mine";
    }

    @Override
    public String getJdbcDriver() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    @Override
    public String getJdbcUrl(String hostAddress) {
        return String.format("jdbc:derby:memory:%s;create=true", this.getDb());
    }

    @Override
    public String getInitialJdbcUrl(String hostAddress) {
        return String.format("jdbc:derby:memory:%s;create=true", this.getDb());
    }

    @Override
    public String getDb() {
        return "junit_metastore_db";
    }

    @Override
    public boolean isContainerReady(DatabaseRule.ProcessResults pr) {
        return true;
    }

    @Override
    public void before() throws Exception {
        MetastoreSchemaTool.setHomeDirForTesting();
    }

    @Override
    public void after() {
        block3: {
            if (this.purgeInAfter) {
                try {
                    DriverManager.getConnection(String.format("jdbc:derby:memory:%s;drop=true", this.getDb())).close();
                }
                catch (Exception e) {
                    if (e.getMessage().contains("dropped")) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public int createUser() {
        return 0;
    }
}

