/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseRule
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseRule.class);
    protected static final String HIVE_USER = "hiveuser";
    protected static final String HIVE_PASSWORD = "hivepassword";
    protected static final String HIVE_DB = "hivedb";
    private static final int MAX_STARTUP_WAIT = 300000;
    private boolean verbose = System.getProperty("verbose.schematool") != null;

    public abstract String getHivePassword();

    public abstract String getDockerImageName();

    public abstract String[] getDockerAdditionalArgs();

    public abstract String getDbType();

    public abstract String getDbRootUser();

    public abstract String getDbRootPassword();

    public abstract String getJdbcDriver();

    public abstract String getJdbcUrl(String var1);

    public final String getJdbcUrl() {
        return this.getJdbcUrl(this.getContainerHostAddress());
    }

    public final String getContainerHostAddress() {
        String hostAddress = System.getenv("HIVE_TEST_DOCKER_HOST");
        if (hostAddress != null) {
            return hostAddress;
        }
        return "localhost";
    }

    public DatabaseRule setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getDb() {
        return HIVE_DB;
    }

    public abstract String getInitialJdbcUrl(String var1);

    public final String getInitialJdbcUrl() {
        return this.getInitialJdbcUrl(this.getContainerHostAddress());
    }

    public abstract boolean isContainerReady(ProcessResults var1);

    protected String[] buildArray(String ... strs) {
        return strs;
    }

    public void before() throws Exception {
        ProcessResults pr;
        this.runCmdAndPrintStreams(this.buildRmCmd(), 600L);
        if (this.runCmdAndPrintStreams((String[])this.buildRunCmd(), (long)600L).rc != 0) {
            this.printDockerEvents();
            throw new RuntimeException("Unable to start docker container");
        }
        long startTime = System.currentTimeMillis();
        do {
            Thread.sleep(1000L);
            pr = this.runCmdAndPrintStreams(this.buildLogCmd(), 30L);
            if (pr.rc == 0) continue;
            this.printDockerEvents();
            throw new RuntimeException("Failed to get docker logs");
        } while (startTime + 300000L >= System.currentTimeMillis() && !this.isContainerReady(pr));
        if (startTime + 300000L < System.currentTimeMillis()) {
            this.printDockerEvents();
            throw new RuntimeException(String.format("Container initialization failed within %d seconds. Please check the hive logs.", 300));
        }
        MetastoreSchemaTool.setHomeDirForTesting();
    }

    public void after() {
        if ("true".equalsIgnoreCase(System.getProperty("metastore.itest.no.stop.container"))) {
            LOG.warn("Not stopping container " + this.getDockerContainerName() + " at user request, please be sure to shut it down before rerunning the test.");
            return;
        }
        try {
            if (this.runCmdAndPrintStreams((String[])this.buildRmCmd(), (long)600L).rc != 0) {
                throw new RuntimeException("Unable to remove docker container");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected String getDockerContainerName() {
        Object suffix = System.getenv("HIVE_TEST_DOCKER_CONTAINER_SUFFIX");
        suffix = suffix == null ? "" : "-" + (String)suffix;
        return String.format("metastore-test-%s-install%s", this.getDbType(), suffix);
    }

    private ProcessResults runCmd(String[] cmd, long secondsToWait) throws IOException, InterruptedException {
        LOG.info("Going to run: " + StringUtils.join((Object[])cmd, (String)" "));
        Process proc = Runtime.getRuntime().exec(cmd);
        if (!proc.waitFor(Math.abs(secondsToWait), TimeUnit.SECONDS)) {
            throw new RuntimeException("Process " + cmd[0] + " failed to run in " + secondsToWait + " seconds");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        StringBuilder lines = new StringBuilder();
        reader.lines().forEach(s -> lines.append((String)s).append('\n'));
        reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        StringBuilder errLines = new StringBuilder();
        reader.lines().forEach(s -> errLines.append((String)s).append('\n'));
        LOG.info("Result lines#: {}(stdout);{}(stderr)", (Object)lines.length(), (Object)errLines.length());
        return new ProcessResults(lines.toString(), errLines.toString(), proc.exitValue());
    }

    private ProcessResults runCmdAndPrintStreams(String[] cmd, long secondsToWait) throws InterruptedException, IOException {
        ProcessResults results = this.runCmd(cmd, secondsToWait);
        LOG.info("Stdout from proc: " + results.stdout);
        LOG.info("Stderr from proc: " + results.stderr);
        return results;
    }

    protected void printDockerEvents() {
        try {
            this.runCmdAndPrintStreams(new String[]{"docker", "events", "--since", "24h", "--until", "0s"}, 3L);
        }
        catch (Exception e) {
            LOG.warn("A problem was encountered while attempting to retrieve Docker events (the system made an analytical best effort to list the events to reveal the root cause). No further actions are necessary.", (Throwable)e);
        }
    }

    private String[] buildRunCmd() {
        ArrayList<String> cmd = new ArrayList<String>(4 + this.getDockerAdditionalArgs().length);
        cmd.add("docker");
        cmd.add("run");
        cmd.add("--rm");
        cmd.add("--name");
        cmd.add(this.getDockerContainerName());
        cmd.addAll(Arrays.asList(this.getDockerAdditionalArgs()));
        cmd.add(this.getDockerImageName());
        return cmd.toArray(new String[cmd.size()]);
    }

    private String[] buildRmCmd() {
        return this.buildArray("docker", "rm", "-f", "-v", this.getDockerContainerName());
    }

    private String[] buildLogCmd() {
        return this.buildArray("docker", "logs", this.getDockerContainerName());
    }

    public String getHiveUser() {
        return HIVE_USER;
    }

    public int createUser() {
        return new MetastoreSchemaTool().setVerbose(this.verbose).run(this.buildArray("-createUser", "-dbType", this.getDbType(), "-userName", this.getDbRootUser(), "-passWord", this.getDbRootPassword(), "-hiveUser", this.getHiveUser(), "-hivePassword", this.getHivePassword(), "-hiveDb", this.getDb(), "-url", this.getInitialJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    public int installLatest() {
        return new MetastoreSchemaTool().setVerbose(this.verbose).run(this.buildArray("-initSchema", "-dbType", this.getDbType(), "-userName", this.getHiveUser(), "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver(), "-verbose"));
    }

    public int installAVersion(String version) {
        return new MetastoreSchemaTool().setVerbose(this.verbose).run(this.buildArray("-initSchemaTo", version, "-dbType", this.getDbType(), "-userName", this.getHiveUser(), "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    public int upgradeToLatest() {
        return new MetastoreSchemaTool().setVerbose(this.verbose).run(this.buildArray("-upgradeSchema", "-dbType", this.getDbType(), "-userName", this.getHiveUser(), "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    public void install() {
        this.createUser();
        this.installLatest();
    }

    public int validateSchema() {
        return new MetastoreSchemaTool().setVerbose(this.verbose).run(this.buildArray("-validate", "-dbType", this.getDbType(), "-userName", this.getHiveUser(), "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    public static class ProcessResults {
        final String stdout;
        final String stderr;
        final int rc;

        public ProcessResults(String stdout, String stderr, int rc) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.rc = rc;
        }
    }
}

