/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerTest;
import org.apache.hadoop.hive.metastore.columnstats.merge.LongColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class LongColumnStatsMergerTest {
    private final LongColumnStatsMerger merger = new LongColumnStatsMerger();
    private static final LongColumnStatsDataInspector DATA_1 = new LongColumnStatsDataInspector();
    private static final LongColumnStatsDataInspector DATA_2 = new LongColumnStatsDataInspector();
    private static final LongColumnStatsDataInspector DATA_3 = new LongColumnStatsDataInspector();

    @Test
    public void testMergeNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(null).high(null).numNulls(1L).numDVs(0L).build());
        this.merger.merge(aggrObj, aggrObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Long>(Long.TYPE).low(null).high(null).numNulls(2L).numDVs(0L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNullWithNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(null).high(null).numNulls(0L).numDVs(0L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(1L).high(3L).numNulls(4L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Long>(Long.TYPE).low(1L).high(3L).numNulls(4L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullWithNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(1L).high(3L).numNulls(4L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(null).high(null).numNulls(2L).numDVs(0L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Long>(Long.TYPE).low(1L).high(3L).numNulls(6L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(2L).high(2L).numNulls(2L).numDVs(1L).hll(2L).kll(2L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(3L).high(3L).numNulls(3L).numDVs(1L).hll(3L).kll(3L).build());
        this.merger.merge(aggrObj, newObj);
        newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Long>(Long.TYPE).low(1L).high(1L).numNulls(1L).numDVs(1L).hll(1L, 1L).kll(1L, 1L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Long>(Long.TYPE).low(1L).high(3L).numNulls(6L).numDVs(3L).hll(2L, 3L, 1L, 1L).kll(2L, 3L, 1L, 1L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testCompareSimple() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector(DATA_1);
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((long)2L, (long)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleFlipped() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector(DATA_2);
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((long)2L, (long)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleReversed() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector(DATA_1);
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((long)1L, (long)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSimpleFlippedReversed() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector(DATA_2);
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((long)1L, (long)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMin() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector();
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMax() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector();
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareFirstNullMin() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector();
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((long)1L, (long)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSecondNullMin() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector(DATA_1);
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector();
        Assert.assertEquals((long)1L, (long)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareFirstNullMax() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector(DATA_1);
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector();
        Assert.assertEquals((long)1L, (long)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSecondNullMax() {
        LongColumnStatsDataInspector data1 = new LongColumnStatsDataInspector();
        LongColumnStatsDataInspector data2 = new LongColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((long)1L, (long)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    static {
        DATA_1.setLowValue(1L);
        DATA_1.setHighValue(1L);
        DATA_2.setLowValue(2L);
        DATA_2.setHighValue(2L);
        DATA_3.setLowValue(3L);
        DATA_3.setHighValue(3L);
    }
}

